/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public enum LoggingThresholdViz {
    ALL(LoggingThreshold.ALL, STLConstants.K0698_ALL.getValue()),
    TRACE(LoggingThreshold.TRACE, STLConstants.K0632_TRACE.getValue()),
    DEBUG(LoggingThreshold.DEBUG, STLConstants.K0630_DEBUG.getValue()),
    INFO(LoggingThreshold.INFO, STLConstants.K0631_INFO.getValue()),
    WARN(LoggingThreshold.WARN, STLConstants.K3002_WARN.getValue()),
    ERROR(LoggingThreshold.ERROR, STLConstants.K0030_ERROR.getValue()),
    OFF(LoggingThreshold.OFF, STLConstants.K0699_OFF.getValue());

    private static final EnumMap<LoggingThreshold, String> loggingThresholdNameMap;
    private static final Map<String, LoggingThreshold> loggingThresholdMap;
    private static final Map<LoggingThreshold, Integer> loggingThresholdMapAtId;
    private final LoggingThreshold threshold;
    private final String name;
    private final int id;

    private LoggingThresholdViz(LoggingThreshold threshold, String name) {
        this.name = name;
        this.threshold = threshold;
        this.id = threshold.getId();
    }

    public LoggingThreshold getThreshold() {
        return this.threshold;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static String getLoggingThresholdName(LoggingThreshold threshold) {
        return loggingThresholdNameMap.get((Object)threshold);
    }

    public static LoggingThreshold getLoggingThreshold(String name) {
        return loggingThresholdMap.get(name);
    }

    public static int getLoggingThresholdAtId(LoggingThreshold threshold) {
        return loggingThresholdMapAtId.get((Object)threshold);
    }

    static {
        loggingThresholdNameMap = new EnumMap(LoggingThreshold.class);
        for (LoggingThresholdViz thresholdViz : LoggingThresholdViz.values()) {
            loggingThresholdNameMap.put(thresholdViz.threshold, thresholdViz.name);
        }
        loggingThresholdMap = new HashMap<String, LoggingThreshold>();
        for (LoggingThresholdViz thresholdViz : LoggingThresholdViz.values()) {
            loggingThresholdMap.put(thresholdViz.getName(), thresholdViz.getThreshold());
        }
        loggingThresholdMapAtId = new HashMap<LoggingThreshold, Integer>();
        for (LoggingThresholdViz thresholdViz : LoggingThresholdViz.values()) {
            loggingThresholdMapAtId.put(thresholdViz.getThreshold(), thresholdViz.getId());
        }
    }
}

