/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.MTUSize;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum MTUSizeViz {
    INVALID(MTUSize.INVALID, STLConstants.K0039_NOT_AVAILABLE.getValue()),
    IB_MTU_2048(MTUSize.IB_MTU_2048, "2048"),
    IB_MTU_4096(MTUSize.IB_MTU_4096, "4096"),
    STL_MTU_8192(MTUSize.STL_MTU_8192, "8192"),
    STL_MTU_10240(MTUSize.STL_MTU_10240, "10240");

    private static final EnumMap<MTUSize, String> mtuSizeMap;
    private final MTUSize mtuSize;
    private final String value;

    private MTUSizeViz(MTUSize mtuSize, String value) {
        this.mtuSize = mtuSize;
        this.value = value;
    }

    public MTUSize getMTUSize() {
        return this.mtuSize;
    }

    public String getValue() {
        return this.value;
    }

    public static MTUSizeViz getMTUSizeViz(byte size) {
        for (MTUSizeViz msv : MTUSizeViz.values()) {
            if (msv.mtuSize.getSize() != size) continue;
            return msv;
        }
        return null;
    }

    public static String getMTUSizeStr(MTUSize mtuSize) {
        return mtuSizeMap.get((Object)mtuSize);
    }

    static {
        mtuSizeMap = new EnumMap(MTUSize.class);
        for (MTUSizeViz msv : MTUSizeViz.values()) {
            mtuSizeMap.put(msv.mtuSize, msv.value);
        }
    }
}

