/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.model.TimedScore;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class NodeScore
extends TimedScore
implements Comparable<NodeScore>,
Serializable {
    private static final long serialVersionUID = -375009123447030706L;
    private final String name;
    private final NodeType type;
    private final int lid;
    private final EventType eventType;

    public NodeScore(String name, NodeType type, int lid, EventType eventType, long time, double score) {
        super(time, score);
        this.name = name;
        this.type = type;
        this.lid = lid;
        this.eventType = eventType;
    }

    public String getName() {
        return this.name;
    }

    public NodeType getType() {
        return this.type;
    }

    public int getLid() {
        return this.lid;
    }

    public boolean isActive() {
        return this.eventType != EventType.PORT_INACTIVE;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public int compareTo(NodeScore o) {
        double s1 = this.getScore();
        double s2 = o.getScore();
        return Double.compare(s1, s2);
    }

    public ImageIcon getIcon() {
        NodeTypeViz viz = NodeTypeViz.getNodeTypeViz(this.type.getId());
        if (viz != null) {
            return viz.getIcon().getImageIcon();
        }
        throw new IllegalArgumentException("Couldn't find NodeTypeViz for " + (Object)((Object)this.type));
    }

    public String getDescription() {
        double score = this.getScore();
        return UILabels.STL10211_WORST_NODE.getDescription(this.name, this.eventType.name(), UIConstants.DECIMAL.format(score));
    }

    @Override
    public String toString() {
        return "NodeScore [getTime()=" + this.getTime() + ", getScore()=" + this.getScore() + ", lid=" + this.lid + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + "]";
    }
}

