/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.monitor.CableInfoPopupController;
import com.intel.stl.ui.monitor.ConnectivityTableController;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.PerformancePage;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.CableInfoPopupView;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ImageIcon;
import net.engio.mbassy.bus.MBassador;

public class ConnectivitySubpageController
implements IPerfSubpageController,
IPortSelectionListener {
    private UndoHandler undoHandler;
    private final String origin = PerformancePage.NAME;
    private final ConnectivityTableController tableController;
    private final ConnectivitySubpageView view;
    private final MBassador<IAppEvent> eventBus;
    private PerformanceTreeController parentController;
    private final CableInfoPopupController cableInfoPopupController;
    private final CableInfoPopupView cableInfoPopupView;

    public ConnectivitySubpageController(ConnectivityTableModel connectTableModel, ConnectivitySubpageView pSubpageView, MBassador<IAppEvent> eventBus) {
        this.tableController = new ConnectivityTableController(connectTableModel, pSubpageView.getTable());
        this.cableInfoPopupView = new CableInfoPopupView(pSubpageView);
        pSubpageView.setCableInfoPopupView(this.cableInfoPopupView);
        this.cableInfoPopupController = new CableInfoPopupController(this.cableInfoPopupView);
        this.cableInfoPopupView.setCableInfoListener(this.cableInfoPopupController);
        this.view = pSubpageView;
        this.view.setPortSelectionListener(this);
        this.eventBus = eventBus;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        if (context != null) {
            this.tableController.setContext(context, observer);
            this.cableInfoPopupController.setContext(context, observer);
            if (context.getController() != null) {
                this.undoHandler = context.getController().getUndoHandler();
            }
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        this.tableController.refreshConnectivity(observer);
    }

    @Override
    public String getName() {
        return STLConstants.K0415_CONNECTIVITY.getValue();
    }

    @Override
    public String getDescription() {
        return STLConstants.K0416_CONNECTIVITY_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void showNode(FVResourceNode node, IProgressObserver observer) {
        switch (node.getType()) {
            case SWITCH: {
                this.processSwitch(node, observer);
                break;
            }
            case HFI: {
                this.processHFI(node, observer);
                break;
            }
        }
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
        this.parentController = parentController;
    }

    protected void processSwitch(FVResourceNode node, IProgressObserver observer) {
        Vector<FVResourceNode> children = node.getChildren();
        if (children.size() > 1) {
            String vfName = null;
            FVResourceNode group = node.getParent();
            if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
                vfName = group.getTitle();
            }
            short[] ports = new short[children.size() - 1];
            for (int i = 1; i < children.size(); ++i) {
                ports[i - 1] = (short)children.get(i).getId();
            }
            this.tableController.showConnectivity(node.getId(), vfName, observer, ports);
        } else {
            observer.onFinish();
        }
    }

    protected void processHFI(FVResourceNode node, IProgressObserver observer) {
        Vector<FVResourceNode> children = node.getChildren();
        if (children.size() > 0) {
            String vfName = null;
            FVResourceNode group = node.getParent();
            if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
                vfName = group.getTitle();
            }
            short[] ports = new short[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                ports[i] = (short)children.get(i).getId();
            }
            this.tableController.showConnectivity(node.getId(), vfName, observer, ports);
        } else {
            observer.onFinish();
        }
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        this.tableController.clear();
    }

    @Override
    public void onPortSelection(int rowIndex) {
    }

    @Override
    public void onJumpToPort(int lid, short portNum, String destination) {
        if (this.eventBus != null) {
            PortsSelectedEvent pse = new PortsSelectedEvent(lid, portNum, this, destination);
            if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
                JumpToEvent oldSel = null;
                FVResourceNode node = this.parentController.getCurrentNode();
                if (node.isNode()) {
                    NodeType type = TreeNodeType.getNodeType(node.getType());
                    oldSel = new NodesSelectedEvent(node.getId(), type, this, this.origin);
                } else if (node.isPort()) {
                    oldSel = new PortsSelectedEvent(node.getParent().getId(), (short)node.getId(), this, this.origin);
                } else {
                    throw new RuntimeException("Unsupported node " + node);
                }
                UndoableJumpEvent undoSel = new UndoableJumpEvent(this.eventBus, oldSel, pse);
                this.undoHandler.addUndoAction(undoSel);
            }
            this.eventBus.publish((Object)pse);
        }
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

