/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import java.util.Date;

public class DeltaConverter {
    private boolean debug;
    private final String name;
    private Date latestTimestamp = null;
    private long latestCummValue;
    private Date earliestTimestamp = null;
    private long earliestCummValue;
    private final Delta delta = new Delta();

    public DeltaConverter(String name) {
        this.name = name;
    }

    public synchronized Delta addValue(long cummValue, Date timestamp) {
        if (this.debug) {
            System.out.println("[" + this.name + "] " + timestamp.getTime() + " " + cummValue);
        }
        if (this.latestTimestamp == null) {
            this.latestTimestamp = timestamp;
            this.latestCummValue = cummValue;
        }
        if (this.earliestTimestamp == null) {
            this.earliestTimestamp = timestamp;
            this.earliestCummValue = cummValue;
        }
        if (timestamp.after(this.latestTimestamp)) {
            this.delta.setValue(cummValue - this.latestCummValue);
            this.delta.setTime(timestamp);
            this.delta.setPeriodInSec((timestamp.getTime() - this.latestTimestamp.getTime()) / 1000L);
            this.latestTimestamp = timestamp;
            this.latestCummValue = cummValue;
            if (this.debug) {
                System.out.println("[" + this.name + "]  " + this.delta);
            }
            return this.delta;
        }
        if (timestamp.before(this.earliestTimestamp)) {
            this.delta.setValue(this.earliestCummValue - cummValue);
            this.delta.setTime(this.earliestTimestamp);
            this.delta.setPeriodInSec((this.earliestTimestamp.getTime() - timestamp.getTime()) / 1000L);
            this.earliestTimestamp = timestamp;
            this.earliestCummValue = cummValue;
            if (this.debug) {
                System.out.println("[" + this.name + "]  " + this.delta);
            }
            return this.delta;
        }
        return null;
    }

    public synchronized void clear() {
        if (this.debug) {
            System.out.println("[" + this.name + "]  CLEAR");
        }
        this.latestTimestamp = null;
        this.earliestTimestamp = null;
    }

    public static class Delta {
        private long periodInSec;
        private Date time;
        private long value;

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public long getValue() {
            return this.value;
        }

        public long getNormalizedValue(long timePeriodInSec) {
            return this.value * timePeriodInSec / this.periodInSec;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getPeriodInSec() {
            return this.periodInSec;
        }

        public void setPeriodInSec(long periodInSec) {
            this.periodInSec = periodInSec;
        }

        public double getRate() {
            return this.value / this.periodInSec;
        }

        public String toString() {
            return "Delta [time=" + this.time + " (" + this.time.getTime() + "), value=" + this.value + "]";
        }
    }
}

