/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.NoticeSeverityViz;
import com.intel.stl.ui.monitor.view.PSEventsCardView;
import java.awt.Color;
import java.util.Date;
import java.util.EnumMap;
import net.engio.mbassy.bus.MBassador;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.TableXYDataset;

public class PSEventsCard
extends BaseCardController<ICardListener, PSEventsCardView> {
    private final TimeTableXYDataset trendDataset;
    private final DefaultPieDataset stateDataset = new DefaultPieDataset();
    private final int maxHistoryLength = 21600000;

    public PSEventsCard(PSEventsCardView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        NoticeSeverityViz[] states = NoticeSeverityViz.values();
        Color[] colors = new Color[states.length + 1];
        for (int i = 0; i < states.length; ++i) {
            this.stateDataset.setValue((Comparable)((Object)states[i].getName()), 0.0);
            colors[i] = states[i].getColor();
        }
        this.stateDataset.setValue((Comparable)((Object)STLConstants.K0056_NONE.getValue()), 0.0);
        colors[states.length] = UIConstants.INTEL_GRAY;
        view.setStateDataset((PieDataset)this.stateDataset, colors);
        this.trendDataset = new TimeTableXYDataset();
        view.setTrendDataset((TableXYDataset)this.trendDataset, NoticeSeverityViz.colors);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getEvents();
    }

    public void updateStates(final EnumMap<NoticeSeverity, Integer> states, final int total, final Date date) {
        final NoticeSeverityViz[] items = NoticeSeverityViz.values();
        final int[] counts = new int[items.length + 1];
        final double[] values = new double[counts.length];
        final String[] labels = new String[counts.length];
        final String[] tooltips = new String[counts.length];
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                int sum = 0;
                PSEventsCard.this.trendDataset.setNotify(false);
                if (PSEventsCard.this.trendDataset.getItemCount() > 0) {
                    long startTime = PSEventsCard.this.trendDataset.getTimePeriod(0).getStart().getTime();
                    long endTime = PSEventsCard.this.trendDataset.getTimePeriod(PSEventsCard.this.trendDataset.getItemCount() - 1).getEnd().getTime();
                    while (endTime - startTime > 21600000L) {
                        for (int i = 0; i < counts.length - 1; ++i) {
                            PSEventsCard.this.trendDataset.remove(PSEventsCard.this.trendDataset.getTimePeriod(0), (Comparable)((Object)items[i]), false);
                        }
                        startTime = PSEventsCard.this.trendDataset.getTimePeriod(0).getStart().getTime();
                    }
                }
                for (int i = 0; i < counts.length; ++i) {
                    if (i < counts.length - 1) {
                        Integer count = (Integer)states.get((Object)items[i].getSeverity());
                        counts[i] = count == null ? 0 : count;
                        sum += counts[i];
                        PSEventsCard.this.trendDataset.add((TimePeriod)new Second(date), (Number)counts[i], (Comparable)((Object)items[i]), false);
                        PSEventsCard.this.stateDataset.setValue((Comparable)((Object)items[i].getName()), (double)counts[i]);
                    } else {
                        counts[i] = total - sum;
                        PSEventsCard.this.stateDataset.setValue((Comparable)((Object)STLConstants.K0056_NONE.getValue()), (double)counts[i]);
                    }
                    values[i] = (double)counts[i] / (double)total;
                    labels[i] = UIConstants.INTEGER.format(counts[i]) + " (" + UIConstants.PERCENTAGE.format(values[i]) + ") ";
                    tooltips[i] = i < counts.length - 1 ? UILabels.STL10203_NODE_EVENTS.getDescription(UIConstants.INTEGER.format(counts[i]), UIConstants.PERCENTAGE.format(values[i]), NoticeSeverityViz.names[i]) : UILabels.STL10204_NODE_NO_EVENTS.getDescription(UIConstants.INTEGER.format(counts[i]), UIConstants.PERCENTAGE.format(values[i]));
                }
                PSEventsCard.this.trendDataset.setNotify(true);
                ((PSEventsCardView)PSEventsCard.this.view).setStates(values, labels, tooltips);
            }
        });
    }

    @Override
    public ICardListener getCardListener() {
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSEventsCard.this.stateDataset.clear();
                PSEventsCard.this.trendDataset.clear();
            }
        });
        ((PSEventsCardView)this.view).clear();
    }
}

