/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.performance.GroupConfigRspBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.VFConfigRspBean;
import com.intel.stl.api.subnet.DefaultDeviceGroup;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.ChartsSectionController;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.event.GroupsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.DevicesStatistics;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.monitor.PSGraphSection;
import com.intel.stl.ui.monitor.PSInfoSection;
import com.intel.stl.ui.monitor.PerformancePage;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.PSGraphSectionView;
import com.intel.stl.ui.monitor.view.PSInfoSectionView;
import com.intel.stl.ui.monitor.view.SummarySubpageView;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.VFSource;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.IEventFilter;
import com.intel.stl.ui.publisher.IStateChangeListener;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.EventSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.engio.mbassy.bus.MBassador;

public class PSSubpageController
implements IPerfSubpageController,
IStateChangeListener {
    private final SummarySubpageView mSubpageView;
    private ISubnetApi subnetApi;
    private IPerformanceApi perfApi;
    private TaskScheduler mTaskScheduler;
    private final List<ISectionController<?>> mSections;
    private final Map<TreeNodeType, NodeType> deviceTypeMap = new HashMap<TreeNodeType, NodeType>();
    private final Map<TreeNodeType, DefaultDeviceGroup> deviceGroupMap = new HashMap<TreeNodeType, DefaultDeviceGroup>();
    private PSInfoSection mInfoSectionController;
    private DevicesStatistics dgStats;
    private final Object dgStatsLock = new Object();
    private ChartsSectionController mGraphSectionController;
    private Context mContext;
    private FVResourceNode selectedTreeNode;
    private final MBassador<IAppEvent> eventBus;
    private NodeType mNodeType;
    private Set<Integer> mNodes;
    private boolean isNewContext;
    private EventSubscriber eventSubscriber;
    private ICallback<StateSummary> stateSummaryCallback;
    private Task<StateSummary> stateSummaryTask;

    public PSSubpageController(SummarySubpageView pSubpageView, MBassador<IAppEvent> eventBus) {
        this.mSubpageView = pSubpageView;
        this.eventBus = eventBus;
        this.mSections = this.getSections();
        this.isNewContext = false;
        ArrayList sectionViews = new ArrayList();
        for (ISectionController<?> section : this.mSections) {
            sectionViews.add((JSectionView<?>)section.getView());
        }
        this.mSubpageView.installSectionViews(sectionViews);
        this.deviceTypeMap.put(TreeNodeType.HCA_GROUP, NodeType.HFI);
        this.deviceTypeMap.put(TreeNodeType.SWITCH_GROUP, NodeType.SWITCH);
        this.deviceGroupMap.put(TreeNodeType.ALL, DefaultDeviceGroup.ALL);
        this.deviceGroupMap.put(TreeNodeType.HCA_GROUP, DefaultDeviceGroup.HFI);
        this.deviceGroupMap.put(TreeNodeType.SWITCH_GROUP, DefaultDeviceGroup.SW);
    }

    protected List<ISectionController<?>> getSections() {
        ArrayList sections = new ArrayList();
        this.mInfoSectionController = new PSInfoSection(new PSInfoSectionView(), this.eventBus);
        sections.add(this.mInfoSectionController);
        this.mGraphSectionController = new PSGraphSection(new PSGraphSectionView(), this.eventBus);
        sections.add(this.mGraphSectionController);
        return sections;
    }

    @Override
    public void setContext(Context pContext, IProgressObserver observer) {
        this.clear();
        this.uninstallEventMonitor();
        this.isNewContext = this.mContext == pContext;
        this.mContext = pContext;
        this.subnetApi = this.mContext.getSubnetApi();
        this.perfApi = this.mContext.getPerformanceApi();
        this.mTaskScheduler = this.mContext.getTaskScheduler();
        this.installEventMonitor();
        this.mGraphSectionController.setContext(pContext, observer);
        observer.onFinish();
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public void clear() {
        for (ISectionController<?> section : this.mSections) {
            section.clear();
        }
        this.selectedTreeNode = null;
    }

    protected void installEventMonitor() {
        this.mContext.getEvtCal().addListener(this);
        this.eventSubscriber = (EventSubscriber)this.mTaskScheduler.getSubscriber(SubscriberType.EVENT);
        this.stateSummaryCallback = new CallbackAdapter<StateSummary>(){

            @Override
            public synchronized void onDone(StateSummary result) {
                if (result != null) {
                    PSSubpageController.this.onStateChange(result);
                }
            }
        };
        this.stateSummaryTask = this.eventSubscriber.registerStateSummary(this.stateSummaryCallback);
    }

    protected void uninstallEventMonitor() {
        if (this.mContext != null && this.mContext.getEvtCal() != null) {
            this.mContext.getEvtCal().removeListener(this);
        }
        if (this.eventSubscriber != null && this.stateSummaryTask != null) {
            this.eventSubscriber.deregisterStateSummary(this.stateSummaryTask, this.stateSummaryCallback);
        }
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupConfig(List<GroupConfigRspBean> portList, long internalPorts, long externalPorts) {
        Object object = this.dgStatsLock;
        synchronized (object) {
            this.dgStats = this.getDevicesStats(portList);
            this.dgStats.setInternalPorts(internalPorts);
            this.dgStats.setExternalPorts(externalPorts);
        }
        this.mInfoSectionController.updateStatistics(this.dgStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVfConfig(List<VFConfigRspBean> portList, int internalPorts, int externalPorts) {
        Object object = this.dgStatsLock;
        synchronized (object) {
            this.dgStats = this.getVFDevicesStats(portList);
            this.dgStats.setInternalPorts(this.dgStats.getNumAtivePorts());
        }
        this.mInfoSectionController.updateStatistics(this.dgStats);
    }

    private DevicesStatistics getDevicesStats(List<GroupConfigRspBean> portList) {
        DevicesStatistics res = new DevicesStatistics();
        HashMap<Integer, NodeType> nodeTypes = new HashMap<Integer, NodeType>();
        EnumMap<NodeType, Long> portsTypeDist = new EnumMap<NodeType, Long>(NodeType.class);
        EnumMap<NodeType, Integer> nodesTypeDist = new EnumMap<NodeType, Integer>(NodeType.class);
        long realNumPorts = 0L;
        long desiredTotalPorts = 0L;
        for (GroupConfigRspBean port : portList) {
            Long portsCount;
            int lid = port.getPort().getNodeLid();
            NodeType nodeType = (NodeType)((Object)nodeTypes.get(lid));
            if (nodeType == null) {
                NodeRecordBean nrb = null;
                try {
                    nrb = this.subnetApi.getNode(lid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nrb == null) continue;
                nodeType = NodeType.getNodeType(nrb.getNodeInfo().getNodeType());
                nodeTypes.put(lid, nodeType);
                switch (nodeType) {
                    case SWITCH: {
                        desiredTotalPorts += (long)(nrb.getNodeInfo().getNumPorts() + 1);
                        break;
                    }
                    case HFI: {
                        ++desiredTotalPorts;
                        break;
                    }
                }
                Integer nodesCount = nodesTypeDist.get((Object)nodeType);
                nodesTypeDist.put(nodeType, nodesCount == null ? 1 : nodesCount + 1);
            }
            portsTypeDist.put(nodeType, (portsCount = portsTypeDist.get((Object)nodeType)) == null ? 1L : portsCount + 1L);
            ++realNumPorts;
        }
        portsTypeDist.put(NodeType.OTHER, desiredTotalPorts - realNumPorts);
        res.setNodeTypesDist(nodesTypeDist);
        res.setNumNodes(nodeTypes.size());
        res.setPortTypesDist(portsTypeDist);
        res.setNumActivePorts(realNumPorts);
        return res;
    }

    private DevicesStatistics getVFDevicesStats(List<VFConfigRspBean> portList) {
        DevicesStatistics res = new DevicesStatistics();
        HashMap<Integer, NodeType> nodeTypes = new HashMap<Integer, NodeType>();
        EnumMap<NodeType, Long> portsTypeDist = new EnumMap<NodeType, Long>(NodeType.class);
        EnumMap<NodeType, Integer> nodesTypeDist = new EnumMap<NodeType, Integer>(NodeType.class);
        long realNumPorts = 0L;
        long desiredTotalPorts = 0L;
        for (VFConfigRspBean port : portList) {
            Long portsCount;
            int lid = port.getPort().getNodeLid();
            NodeType nodeType = (NodeType)((Object)nodeTypes.get(lid));
            if (nodeType == null) {
                NodeRecordBean nrb = null;
                try {
                    nrb = this.subnetApi.getNode(lid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nrb == null) continue;
                nodeType = NodeType.getNodeType(nrb.getNodeInfo().getNodeType());
                nodeTypes.put(lid, nodeType);
                switch (nodeType) {
                    case SWITCH: {
                        desiredTotalPorts += (long)(nrb.getNodeInfo().getNumPorts() + 1);
                        break;
                    }
                    case HFI: {
                        ++desiredTotalPorts;
                        break;
                    }
                }
                Integer nodesCount = nodesTypeDist.get((Object)nodeType);
                nodesTypeDist.put(nodeType, nodesCount == null ? 1 : nodesCount + 1);
            }
            portsTypeDist.put(nodeType, (portsCount = portsTypeDist.get((Object)nodeType)) == null ? 1L : portsCount + 1L);
            ++realNumPorts;
        }
        portsTypeDist.put(NodeType.OTHER, desiredTotalPorts - realNumPorts);
        res.setNodeTypesDist(nodesTypeDist);
        res.setNumNodes(nodeTypes.size());
        res.setPortTypesDist(portsTypeDist);
        res.setNumActivePorts(realNumPorts);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewEvent(StateSummary summary, NodeType type, final Set<Integer> nodes) {
        if (summary == null) {
            return;
        }
        int total = 0;
        EnumMap<NoticeSeverity, Integer> severityMap = null;
        Object object = this.dgStatsLock;
        synchronized (object) {
            if (this.dgStats == null || this.dgStats.getNodeTypesDist() == null) {
                return;
            }
            EnumMap<NodeType, Integer> currenDist = this.dgStats.getNodeTypesDist();
            if (currenDist == null) {
                return;
            }
            if (type == NodeType.HFI) {
                total = Math.max(summary.getBaseTotalHFIs(), currenDist.get((Object)NodeType.HFI));
                severityMap = summary.getHfiStates();
            } else if (type == NodeType.SWITCH) {
                total = Math.max(summary.getBaseTotalSWs(), currenDist.get((Object)NodeType.SWITCH));
                severityMap = summary.getSwitchStates();
            } else if (this.selectedTreeNode != null && this.selectedTreeNode.getType() == TreeNodeType.ALL) {
                total = Math.max(summary.getBaseTotalNodes(), this.dgStats.getNumNodes());
                severityMap = summary.getStates(null);
            } else if (nodes != null && !nodes.isEmpty()) {
                total = nodes.size();
                severityMap = summary.getStates(new IEventFilter(){

                    @Override
                    public boolean accept(int nodeLid, NodeType nodeType) {
                        return nodes.contains(nodeLid);
                    }
                });
            }
        }
        this.mInfoSectionController.updateStates(severityMap, total);
    }

    @Override
    public String getName() {
        return STLConstants.K0200_PERFORMANCE.getValue();
    }

    @Override
    public String getDescription() {
        return STLConstants.K0412_SUMMARY_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.mSubpageView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void showNode(FVResourceNode treeNode, IProgressObserver observer) {
        StateSummary summary;
        boolean newNode;
        if (this.perfApi == null || treeNode == null) {
            return;
        }
        boolean bl = newNode = !treeNode.equals(this.selectedTreeNode);
        if (newNode) {
            this.clear();
            this.selectedTreeNode = treeNode;
        }
        if (treeNode.getType() == TreeNodeType.VIRTUAL_FABRIC) {
            this.processVFTreeNode(treeNode, observer);
        } else {
            this.processTreeNode(treeNode, observer);
        }
        if (!newNode) {
            return;
        }
        this.mNodeType = this.getNodeType(treeNode);
        Set<Integer> set = this.mNodes = this.mNodeType == null ? this.getNodes(treeNode) : null;
        if (this.isNewContext && (summary = this.mContext.getEvtCal().getSummary()) != null) {
            this.isNewContext = false;
            this.initEvents(summary);
        }
        this.mGraphSectionController.setOrigin(new GroupsSelectedEvent(this, PerformancePage.NAME, treeNode.getTitle(), treeNode.getType()));
    }

    protected void processTreeNode(FVResourceNode treeNode, final IProgressObserver observer) {
        DefaultDeviceGroup dg = this.deviceGroupMap.get((Object)treeNode.getType());
        final String name = dg != null ? dg.getName() : treeNode.getTitle();
        this.mTaskScheduler.submitToBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<GroupConfigRspBean> group = PSSubpageController.this.perfApi.getGroupConfig(name);
                    GroupInfoBean bean = PSSubpageController.this.perfApi.getGroupInfo(name);
                    if (group != null && bean != null) {
                        PSSubpageController.this.processGroupConfig(group, bean.getNumInternalPorts(), bean.getNumExternalPorts());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    observer.onFinish();
                }
            }
        });
        TreeNodeType type = treeNode.getType();
        if (type == TreeNodeType.ALL) {
            this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, DataType.EXTERNAL, DataType.TRANSMIT, DataType.RECEIVE);
        } else if (type == TreeNodeType.HCA_GROUP) {
            this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, DataType.INTERNAL);
        } else if (type == TreeNodeType.DEVICE_GROUP) {
            if (treeNode.getTitle().equals(DefaultDeviceGroup.HFI.getName())) {
                this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, DataType.INTERNAL);
            } else if (treeNode.getTitle().equals(DefaultDeviceGroup.ALL.getName())) {
                this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, DataType.EXTERNAL, DataType.TRANSMIT, DataType.RECEIVE);
            } else {
                this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, null);
            }
        } else {
            this.mGraphSectionController.setDisabledDataTypes(null, null);
        }
        this.mGraphSectionController.setDataProvider(DataProviderName.PORT_GROUP);
        this.mGraphSectionController.setSource(new GroupSource(name));
    }

    protected void processVFTreeNode(FVResourceNode treeNode, final IProgressObserver observer) {
        final String name = treeNode.getTitle();
        this.mTaskScheduler.submitToBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<VFConfigRspBean> group = PSSubpageController.this.perfApi.getVFConfig(name);
                    if (group != null) {
                        PSSubpageController.this.processVfConfig(group, 0, 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    observer.onFinish();
                }
            }
        });
        this.mGraphSectionController.setDisabledDataTypes(DataType.ALL, DataType.EXTERNAL, DataType.TRANSMIT, DataType.RECEIVE);
        this.mGraphSectionController.setDataProvider(DataProviderName.VIRTUAL_FABRIC);
        this.mGraphSectionController.setSource(new VFSource(name));
    }

    protected NodeType getNodeType(FVResourceNode treeNode) {
        switch (treeNode.getType()) {
            case HCA_GROUP: {
                return NodeType.HFI;
            }
            case SWITCH_GROUP: {
                return NodeType.SWITCH;
            }
            case DEVICE_GROUP: {
                DefaultDeviceGroup dg = DefaultDeviceGroup.getType(treeNode.getTitle());
                if (dg == null) break;
                switch (dg) {
                    case SW: {
                        return NodeType.SWITCH;
                    }
                    case HFI: 
                    case TFI: {
                        return NodeType.HFI;
                    }
                }
                break;
            }
        }
        return null;
    }

    protected Set<Integer> getNodes(FVResourceNode treeNode) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (FVResourceNode child : treeNode.getChildren()) {
            res.add(child.getId());
        }
        return res;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public void onStateChange(StateSummary summary) {
        if (summary != null) {
            this.processNewEvent(summary, this.mNodeType, this.mNodes);
        }
    }

    @Override
    public String toString() {
        return "PSSubpageController";
    }

    private void initEvents(StateSummary summary) {
        int total = 1;
        try {
            ISubnetApi subnetApi = this.mContext.getSubnetApi();
            if (subnetApi != null) {
                total = subnetApi.getNodes(false).size();
            }
        }
        catch (SubnetDataNotFoundException e) {
            e.printStackTrace();
        }
        EnumMap<NoticeSeverity, Integer> severityMap = null;
        severityMap = summary.getStates(null);
        this.mInfoSectionController.updateStates(severityMap, total);
    }
}

