/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.CreationBasedNodesSynchronizer;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.ITreeUpdater;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTypesTreeUpdater
implements ITreeUpdater {
    private static final Logger log = LoggerFactory.getLogger(DeviceTypesTreeUpdater.class);
    private final ISubnetApi subnetApi;
    protected final Comparator<FVResourceNode> typeNodeComparator;
    protected final Comparator<FVResourceNode> nodeComparator;

    public DeviceTypesTreeUpdater(ISubnetApi subnetApi) {
        this.subnetApi = subnetApi;
        this.typeNodeComparator = TreeNodeFactory.getTypeNodeComparator();
        this.nodeComparator = TreeNodeFactory.getNodeComparator();
    }

    @Override
    public void addNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void updateNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void removeNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    public void updateNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        NodeRecordBean bean = null;
        try {
            bean = this.subnetApi.getNode(lid);
        }
        catch (SubnetDataNotFoundException e) {
            // empty catch block
        }
        if (bean == null || !bean.isActive()) {
            this.removeDeviceTypesNode(lid, tree, true, monitors);
            return;
        }
        long guid = bean.getNodeInfo().getNodeGUID();
        HashMap<Long, NodeRecordBean> nodeMap = new HashMap<Long, NodeRecordBean>();
        nodeMap.put(guid, bean);
        CreationBasedNodesSynchronizer nodeUpdater = new CreationBasedNodesSynchronizer(this.subnetApi, nodeMap);
        FVResourceNode typeNode = this.getTypeNode(bean, tree);
        FVResourceNode node = TreeNodeFactory.createNode(bean);
        Vector<FVResourceNode> children = typeNode.getChildren();
        int index = Collections.binarySearch(children, node, this.nodeComparator);
        if (index < 0) {
            index = -index - 1;
            nodeUpdater.addNode(index, guid, typeNode, monitors, (IProgressObserver)null);
        } else {
            FVResourceNode updateNode = typeNode.getChildAt(index);
            nodeUpdater.updateNode(updateNode, typeNode, monitors, null);
        }
    }

    protected FVResourceNode getTypeNode(NodeRecordBean bean, FVResourceNode parent) {
        TreeNodeType treeNodeType = TreeNodeFactory.getTreeNodeType(bean.getNodeType());
        FVResourceNode node = TreeNodeFactory.createTypeNode(treeNodeType);
        Vector<FVResourceNode> children = parent.getChildren();
        int index = Collections.binarySearch(children, node, this.typeNodeComparator);
        if (index < 0) {
            int pos = -index - 1;
            parent.addChild(pos, node);
        } else {
            node = parent.getChildAt(index);
        }
        return node;
    }

    public void removeDeviceTypesNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            FVResourceNode typeNode = tree.getChildAt(i);
            for (int j = 0; j < typeNode.getChildCount(); ++j) {
                FVResourceNode node = typeNode.getChildAt(j);
                if (node.getId() != lid) continue;
                int index = j;
                FVResourceNode parent = typeNode;
                if (removeEmptyParents && typeNode.getChildCount() == 1) {
                    index = tree.getIndex(typeNode);
                    parent = tree;
                }
                parent.removeChild(index);
                if (monitors != null) {
                    for (ITreeMonitor monitor : monitors) {
                        monitor.fireTreeNodesRemoved(this, parent.getPath().getPath(), new int[]{index}, new FVResourceNode[]{node});
                    }
                }
                return;
            }
        }
        log.warn("Node lid=" + lid + " doesn't exist!");
    }
}

