/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.FVHeaderRenderer;
import com.intel.stl.ui.common.view.FVTableRenderer;
import com.intel.stl.ui.common.view.FVXTableView;
import com.intel.stl.ui.common.view.JumpPopupUtil;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.model.ConnectivityTableColumns;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.LinkQualityViz;
import com.intel.stl.ui.monitor.ConnectivityTableData;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.view.CableInfoPopupView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.decorator.PatternPredicate;

public class ConnectivitySubpageView
extends FVXTableView<ConnectivityTableModel> {
    private static final long serialVersionUID = -2465696391555897980L;
    protected IPortSelectionListener listener;
    private CableInfoPopupView cableInfoPopupView;

    public ConnectivitySubpageView(ConnectivityTableModel model) {
        super(model);
        this.installPopupMenu();
        this.installListeners();
    }

    public CableInfoPopupView getCableInfoPopupView() {
        return this.cableInfoPopupView;
    }

    public void setCableInfoPopupView(CableInfoPopupView cableInfoPopupView) {
        this.cableInfoPopupView = cableInfoPopupView;
    }

    @Override
    protected JXTable createTable(final ConnectivityTableModel model) {
        JXTable table = new JXTable((TableModel)model);
        table.setColumnControlVisible(true);
        table.setHorizontalScrollEnabled(true);
        table.setAutoscrolls(true);
        table.setFillsViewportHeight(true);
        table.setPreferredScrollableViewportSize(this.getMaximumSize());
        table.setAutoCreateColumnsFromModel(true);
        table.setAlignmentX(0.0f);
        table.setBackground(UIConstants.INTEL_WHITE);
        table.setVisibleRowCount(15);
        table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.INTEL_WHITE, (Color)UIConstants.INTEL_TABLE_ROW_GRAY)});
        table.getTableHeader().setReorderingAllowed(false);
        PatternPredicate predicate = new PatternPredicate(STLConstants.K0525_NEIGHBOR.getValue());
        ColorHighlighter highlighter = new ColorHighlighter((HighlightPredicate)predicate, UIConstants.INTEL_TABLE_ROW_GRAY, UIConstants.INTEL_BLUE, null, null);
        table.setHighlighters(new Highlighter[]{highlighter});
        predicate = new PatternPredicate(STLConstants.K0524_INACTIVE.getValue());
        highlighter = new ColorHighlighter((HighlightPredicate)predicate, UIConstants.INTEL_GRAY, null, null, null);
        table.addHighlighter((Highlighter)highlighter);
        table.setSortable(false);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JXTable table = (JXTable)e.getSource();
                if (table.getRowCount() <= 0) {
                    return;
                }
                try {
                    int row = table.convertRowIndexToModel(table.rowAtPoint(e.getPoint()));
                    int col = table.convertColumnIndexToModel(table.columnAtPoint(e.getPoint()));
                    if (col == ConnectivityTableColumns.CABLE_INFO.getId()) {
                        ConnectivitySubpageView.this.cableInfoPopupView.onCableInfoSelection(table, row, col, model, e);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return table;
    }

    protected void installPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JumpPopupUtil.appendPopupMenu(popupMenu, false, new JumpPopupUtil.IActionCreator(){

            @Override
            public Action createAction(final JumpDestination destination) {
                return new AbstractAction(destination.getName()){
                    private static final long serialVersionUID = -2783822215801105313L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ConnectivitySubpageView.this.listener == null) {
                            return;
                        }
                        int vRow = ConnectivitySubpageView.this.mTable.getSelectedRow();
                        if (vRow >= 0) {
                            int mRow = ConnectivitySubpageView.this.mTable.convertRowIndexToModel(vRow);
                            ConnectivityTableData data = (ConnectivityTableData)((ConnectivityTableModel)ConnectivitySubpageView.this.model).getEntry(mRow);
                            ConnectivitySubpageView.this.listener.onJumpToPort(data.getNodeLidValue(), data.getPortNumValue(), destination.getName());
                        }
                    }
                };
            }
        });
        this.mTable.setComponentPopupMenu(popupMenu);
    }

    protected void installListeners() {
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ConnectivitySubpageView.this.listener == null) {
                    return;
                }
                int vRow = ConnectivitySubpageView.this.mTable.getSelectedRow();
                if (vRow >= 0) {
                    int mRow = ConnectivitySubpageView.this.mTable.convertRowIndexToModel(vRow);
                    ConnectivitySubpageView.this.listener.onPortSelection(mRow);
                }
            }
        };
        this.mTable.getSelectionModel().addListSelectionListener(selectionListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ConnectivitySubpageView.this.listener == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                    Point p = e.getPoint();
                    int vRow = ConnectivitySubpageView.this.mTable.rowAtPoint(p);
                    if (vRow >= 0) {
                        int mRow = ConnectivitySubpageView.this.mTable.convertRowIndexToModel(vRow);
                        ConnectivityTableData data = (ConnectivityTableData)((ConnectivityTableModel)ConnectivitySubpageView.this.model).getEntry(mRow);
                        ConnectivitySubpageView.this.listener.onJumpToPort(data.getNodeLidValue(), data.getPortNumValue(), JumpDestination.DEFAULT.getName());
                    }
                }
            }
        };
        this.mTable.addMouseListener((MouseListener)mouseListener);
    }

    public void setPortSelectionListener(IPortSelectionListener listener) {
        this.listener = listener;
    }

    public JComponent getMainComponent() {
        return this;
    }

    @Override
    public void formatTable() {
        FVTableRenderer tableRenderer = new FVTableRenderer(){
            private static final long serialVersionUID = 4771573417795067808L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Component cell = super.getTableCellRendererComponent(table, value, false, hasFocus, row, col);
                return ConnectivitySubpageView.this.renderCell(table, value, isSelected, hasFocus, row, col, cell);
            }
        };
        FVHeaderRenderer headerRenderer = new FVHeaderRenderer(this.mTable);
        this.mHeader = this.createTableHeader(this.mTable.getColumnModel());
        this.mTable.setTableHeader((JTableHeader)this.mHeader);
        this.mHeader.setFont(UIConstants.H3_FONT);
        for (int i = 0; i < this.mTable.getColumnCount(); ++i) {
            this.mTable.getColumnModel().getColumn(i).setHeaderRenderer(headerRenderer);
            this.mTblCol = this.mTable.getColumnModel().getColumn(i);
            this.mTblCol.setCellRenderer(tableRenderer);
        }
        this.filterColumns();
        this.mTable.packTable(2);
    }

    protected JXTableHeader createTableHeader(TableColumnModel columnModel) {
        JXTableHeader header = new JXTableHeader(columnModel){
            private static final long serialVersionUID = 1552295147223847158L;

            public String getToolTipText(MouseEvent e) {
                Point point = e.getPoint();
                int column = this.columnModel.getColumnIndexAtX(point.x);
                int modelIndex = this.table.convertColumnIndexToModel(column);
                return ConnectivityTableColumns.values()[modelIndex].getToolTip();
            }
        };
        return header;
    }

    protected void filterColumns() {
        ConnectivityTableColumns[] toShow = new ConnectivityTableColumns[]{ConnectivityTableColumns.NODE_NAME, ConnectivityTableColumns.PORT_NUMBER, ConnectivityTableColumns.CABLE_INFO, ConnectivityTableColumns.LINK_STATE, ConnectivityTableColumns.PHYSICAL_LINK_STATE, ConnectivityTableColumns.LINK_QUALITY, ConnectivityTableColumns.ACTIVE_LINK_WIDTH, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_TX, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_RX, ConnectivityTableColumns.ACTIVE_LINK_SPEED, ConnectivityTableColumns.RX_DATA, ConnectivityTableColumns.TX_DATA, ConnectivityTableColumns.LINK_DOWNED};
        ConnectivityTableColumns[] all = ConnectivityTableColumns.values();
        boolean[] vis = new boolean[all.length];
        for (ConnectivityTableColumns col : toShow) {
            vis[col.getId()] = true;
        }
        for (int i = 0; i < vis.length; ++i) {
            this.mTable.getColumnExt((Object)all[i].getTitle()).setVisible(vis[i]);
        }
    }

    private Component renderLinkState(JTable table, int row, int col, Component cell, Object value) {
        String str;
        JLabel label = (JLabel)cell;
        ConnectivityTableData tableEntry = (ConnectivityTableData)((ConnectivityTableModel)this.model).getEntry(row);
        ImageIcon icon = null;
        icon = tableEntry.isSlowLinkState() ? UIImages.SLOW_LINK.getImageIcon() : ((str = (String)table.getModel().getValueAt(row, ConnectivityTableColumns.LINK_STATE.getId())).equals(STLConstants.K0524_INACTIVE.getValue()) ? UIImages.INACTIVE_LINK.getImageIcon() : UIImages.NORMAL_LINK.getImageIcon());
        if (label.getIcon() != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(label.getBackground());
            JLabel stateLabel = new JLabel(icon);
            panel.add((Component)stateLabel, "West");
            panel.add((Component)label, "Center");
            return panel;
        }
        label.setIcon(icon);
        return label;
    }

    private Component renderCell(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col, Component cell) {
        NodeType nodeType;
        String str;
        ((JLabel)cell).setIcon(null);
        ((JLabel)cell).setToolTipText(null);
        ((JLabel)cell).setHorizontalAlignment(10);
        Color lastForegroundColor = cell.getForeground();
        Color lastBackgroundColor = cell.getBackground();
        if (value == null) {
            ((JLabel)cell).setText(STLConstants.K0383_NA.getValue());
        }
        if ((str = (nodeType = (NodeType)((Object)table.getModel().getValueAt(row, ConnectivityTableColumns.NODE_TYPE.getId()))).name()).equals(STLConstants.K0524_INACTIVE.getValue())) {
            cell.setFont(UIConstants.H6_FONT.deriveFont(1));
        }
        if ((str = (String)table.getModel().getValueAt(row, ConnectivityTableColumns.PORT_NUMBER.getId())).contains(STLConstants.K0525_NEIGHBOR.getValue())) {
            cell.setFont(UIConstants.H6_FONT.deriveFont(2));
        }
        if (row % 2 == 0) {
            cell.setBackground(UIConstants.INTEL_WHITE);
            cell.setFont(UIConstants.H6_FONT.deriveFont(1));
        } else {
            cell.setBackground(UIConstants.INTEL_TABLE_ROW_GRAY);
        }
        if (isSelected) {
            lastForegroundColor = cell.getForeground();
            lastBackgroundColor = cell.getBackground();
            cell.setForeground(UIConstants.INTEL_WHITE);
            cell.setBackground(UIConstants.INTEL_MEDIUM_BLUE);
        } else {
            cell.setForeground(lastForegroundColor);
            cell.setBackground(lastBackgroundColor);
        }
        int cableInfoColumn = -1;
        try {
            cableInfoColumn = table.getColumnModel().getColumnIndex(ConnectivityTableColumns.CABLE_INFO.getTitle());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (cableInfoColumn == col && value != null) {
            ((JLabel)cell).setIcon(UIImages.CABLE.getImageIcon());
            ((JLabel)cell).setToolTipText(STLConstants.K3050_CABLE_INFO_TOOL_TIP.getValue());
            ((JLabel)cell).setHorizontalAlignment(0);
        }
        int qualityIndex = -1;
        try {
            qualityIndex = table.getColumnModel().getColumnIndex(ConnectivityTableColumns.LINK_QUALITY.getTitle());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (qualityIndex == col) {
            if (value != null) {
                ((JLabel)cell).setIcon(LinkQualityViz.getLinkQualityIcon(((Integer)value).byteValue()));
                ((JLabel)cell).setToolTipText(LinkQualityViz.getLinkQualityDescription(((Integer)value).byteValue()));
            }
            ((JLabel)cell).setText("");
            cell.setForeground(cell.getBackground());
            ((JLabel)cell).setHorizontalAlignment(0);
        }
        if (col == 0) {
            cell = this.renderLinkState(table, row, col, cell, value);
        }
        return cell;
    }
}

