/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.common.view.SafeTextField;
import com.intel.stl.ui.monitor.ISearchListener;
import com.intel.stl.ui.monitor.TreeSearchType;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.view.ISearchView;
import com.intel.stl.ui.monitor.view.IStack;
import com.intel.stl.ui.monitor.view.StackPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class SearchView
extends JPanel
implements ISearchView,
IStack {
    private static final long serialVersionUID = -7812859211672953591L;
    private JComboBox<TreeSearchType> searchTypeList;
    private SafeTextField searchTextField;
    private JFormattedTextField.AbstractFormatter nameInputFormatter;
    private JFormattedTextField.AbstractFormatter lidInputFormatter;
    private JFormattedTextField.AbstractFormatter guidInputFormatter;
    private ActionListener searchTypeListener;
    private JButton searchBtn;
    private ISearchListener searchListener;
    private JScrollPane resultsTree;
    private EnumMap<TreeTypeEnum, StackPanel> stackPanels;
    private JLabel messageLabel;
    private JPanel progressPanel;
    private JLabel running;
    private JProgressBar progressBar;

    public SearchView() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setLayout(new BorderLayout());
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridBagLayout());
        searchPanel.setBackground(UIConstants.INTEL_WHITE);
        GridBagConstraints gc1 = new GridBagConstraints();
        gc1.weightx = 0.0;
        this.searchTypeList = new JComboBox<TreeSearchType>(TreeSearchType.values());
        IntelComboBoxUI ui = new IntelComboBoxUI(){

            @Override
            protected String getValueString(Object value) {
                return ((TreeSearchType)((Object)value)).getName();
            }

            @Override
            protected String getValueTooltip(Object value) {
                return ((TreeSearchType)((Object)value)).getName();
            }
        };
        ui.setEditorBorder(BorderFactory.createEmptyBorder());
        ui.setArrowButtonTooltip(UILabels.STL10103_MORE_SELECTIONS.getDescription());
        ui.setArrowButtonBorder(null);
        this.searchTypeList.setUI(ui);
        searchPanel.add(this.searchTypeList, gc1);
        gc1.fill = 2;
        gc1.insets = new Insets(3, 2, 5, 2);
        gc1.weighty = 0.0;
        gc1.weightx = 1.0;
        gc1.gridwidth = 1;
        this.searchTextField = new SafeTextField(true);
        this.searchTextField.setValidChars("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz .-=_");
        this.searchTextField.setText(STLConstants.K0115_TREE_SEARCH.getValue());
        this.searchTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchView.this.searchTextField.selectAll();
            }
        });
        this.nameInputFormatter = this.searchTextField.getFormatter();
        ((SafeTextField.SafeStringFormatter)this.nameInputFormatter).setParent(this.searchTextField);
        searchPanel.add((Component)this.searchTextField, gc1);
        gc1.weightx = 0.0;
        gc1.gridwidth = 0;
        this.searchBtn = ComponentFactory.getImageButton(UIImages.SEARCH.getImageIcon());
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchView.this.searchBtn.isSelected()) {
                    SearchView.this.searchBtn.setEnabled(false);
                    SearchView.this.searchListener.cancel();
                } else {
                    SearchView.this.searchTypeList.setEnabled(false);
                    SearchView.this.searchBtn.setIcon(UIImages.STOP_RED.getImageIcon());
                    SearchView.this.searchBtn.setSelected(true);
                    SearchView.this.messageLabel.setVisible(false);
                    SearchView.this.progressPanel.setVisible(true);
                    SearchView.this.resultsTree.setVisible(false);
                    SearchView.this.setProgress(0);
                    SearchView.this.setProgressNote("");
                    SearchView.this.searchListener.setSearchValue(SearchView.this.searchTextField.getText());
                    SearchView.this.searchListener.searchTree();
                }
            }
        });
        this.searchBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).requestFocusInWindow();
            }
        });
        this.searchBtn.requestFocusInWindow();
        this.searchBtn.setToolTipText(STLConstants.K0115_TREE_SEARCH.getValue());
        searchPanel.add((Component)this.searchBtn, gc1);
        this.progressPanel = new JPanel(new BorderLayout());
        this.progressPanel.setOpaque(true);
        this.progressPanel.setBackground(UIConstants.INTEL_WHITE);
        this.progressPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.running = new JLabel();
        this.running.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.progressPanel.add((Component)this.running, "West");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setUI(new BasicProgressBarUI());
        this.progressBar.setBorderPainted(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(false);
        this.progressPanel.add((Component)this.progressBar, "Center");
        gc1.weightx = 0.0;
        gc1.gridwidth = 0;
        this.progressPanel.setVisible(false);
        searchPanel.add((Component)this.progressPanel, gc1);
        this.messageLabel = ComponentFactory.getH4Label("", 1);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVisible(false);
        searchPanel.add((Component)this.messageLabel, gc1);
        this.add((Component)searchPanel, "North");
        JPanel mPnlTree = new JPanel(new GridBagLayout());
        mPnlTree.setBackground(UIConstants.INTEL_WHITE);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.stackPanels = this.getStackPanels();
        for (StackPanel stackPanel : this.stackPanels.values()) {
            stackPanel.setVisible(false);
            mPnlTree.add((Component)stackPanel, gc);
        }
        gc.weighty = 1.0;
        mPnlTree.add(Box.createGlue(), gc);
        this.resultsTree = new JScrollPane();
        ScrollPaneLayout spTreeLayout = new ScrollPaneLayout();
        this.resultsTree.createHorizontalScrollBar();
        this.resultsTree.createVerticalScrollBar();
        spTreeLayout.setHorizontalScrollBarPolicy(30);
        spTreeLayout.setVerticalScrollBarPolicy(20);
        this.resultsTree.getVerticalScrollBar().setUnitIncrement(10);
        this.resultsTree.setLayout(spTreeLayout);
        this.resultsTree.add(mPnlTree);
        this.resultsTree.setViewportView(mPnlTree);
        this.resultsTree.setVisible(false);
        this.add((Component)this.resultsTree, "Center");
    }

    public void enableSearch() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SearchView.this.searchBtn.setEnabled(true);
                SearchView.this.searchTypeList.setEnabled(true);
                SearchView.this.setRunning(false);
                SearchView.this.progressPanel.setVisible(false);
            }
        });
    }

    public void setRunning(boolean b) {
        if (!b) {
            this.searchBtn.setSelected(b);
            this.searchBtn.setIcon(UIImages.SEARCH.getImageIcon());
        }
        this.running.setIcon(b ? UIImages.RUNNING.getImageIcon() : null);
    }

    public void setProgress(int progress) {
        this.progressBar.setValue(progress);
    }

    public void setProgressNote(String note) {
        if (note != null) {
            this.progressBar.setString(note);
        }
    }

    public void showMessage(String msg) {
        this.messageLabel.setVisible(true);
        this.messageLabel.setText(msg);
        this.resultsTree.setVisible(false);
    }

    public void addSearchListener(ISearchListener listener) {
        this.searchListener = listener;
        if (this.searchTypeList == null || listener == null) {
            return;
        }
        if (this.searchTypeListener != null) {
            this.searchTypeList.removeActionListener(this.searchTypeListener);
        }
        this.searchTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchView.this.searchTextField.setBackground(UIConstants.INTEL_WHITE);
                SearchView.this.searchTextField.setToolTipText(null);
                SearchView.this.showTree(false);
                SearchView.this.progressPanel.setVisible(false);
                SearchView.this.messageLabel.setVisible(false);
                String text = SearchView.this.searchTextField.getText();
                Object value = null;
                SearchView.this.searchTextField.setValue(null);
                TreeSearchType type = (TreeSearchType)((Object)SearchView.this.searchTypeList.getSelectedItem());
                switch (type) {
                    case NAME: {
                        SearchView.this.searchTextField.setFixedFormatter(SearchView.this.nameInputFormatter);
                        SearchView.this.searchTextField.setValue(text);
                        break;
                    }
                    case LID: {
                        if (SearchView.this.lidInputFormatter == null) {
                            SearchView.this.lidInputFormatter = new SafeNumberField.SafeNumberFormatter<Integer>(new DecimalFormat("###"), 0, true, Integer.MAX_VALUE, true);
                            ((SafeNumberField.SafeNumberFormatter)SearchView.this.lidInputFormatter).setParent(SearchView.this.searchTextField);
                        }
                        try {
                            value = SearchView.this.lidInputFormatter.stringToValue(text);
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        SearchView.this.searchTextField.setFixedFormatter(SearchView.this.lidInputFormatter);
                        SearchView.this.searchTextField.setValue(value);
                        break;
                    }
                    case GUID: {
                        if (SearchView.this.guidInputFormatter == null) {
                            SafeTextField.SafeStringFormatter formatter = new SafeTextField.SafeStringFormatter(true, 18);
                            formatter.setValidCharacters("0123456789abcdefxABCDEFX");
                            formatter.setParent(SearchView.this.searchTextField);
                            SearchView.this.guidInputFormatter = formatter;
                        }
                        try {
                            value = SearchView.this.guidInputFormatter.stringToValue(text);
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        SearchView.this.searchTextField.setFixedFormatter(SearchView.this.guidInputFormatter);
                        SearchView.this.searchTextField.setValue(value);
                        break;
                    }
                }
                SearchView.this.searchListener.setSearchType(type);
            }
        };
        this.searchTypeList.addActionListener(this.searchTypeListener);
        this.searchTypeList.setSelectedItem((Object)TreeSearchType.NAME);
        this.searchTextField.setText(STLConstants.K0115_TREE_SEARCH.getValue());
    }

    protected EnumMap<TreeTypeEnum, StackPanel> getStackPanels() {
        EnumMap<TreeTypeEnum, StackPanel> panels = new EnumMap<TreeTypeEnum, StackPanel>(TreeTypeEnum.class);
        panels.put(TreeTypeEnum.DEVICE_TYPES_TREE, new StackPanel(TreeTypeEnum.DEVICE_TYPES_TREE, this.createTree(), this));
        panels.put(TreeTypeEnum.DEVICE_GROUPS_TREE, new StackPanel(TreeTypeEnum.DEVICE_GROUPS_TREE, this.createTree(), this));
        panels.put(TreeTypeEnum.VIRTUAL_FABRICS_TREE, new StackPanel(TreeTypeEnum.VIRTUAL_FABRICS_TREE, this.createTree(), this));
        return panels;
    }

    protected StackPanel getStackPanel(TreeTypeEnum type) {
        StackPanel sp = this.stackPanels.get((Object)type);
        if (sp != null) {
            return sp;
        }
        throw new IllegalArgumentException("Couldn't find StackPanel for " + (Object)((Object)type));
    }

    protected JTree createTree() {
        JTree res = new JTree();
        res.setModel(null);
        res.setRootVisible(false);
        return res;
    }

    @Override
    public void stackChange(final TreeTypeEnum stack) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (TreeTypeEnum treeType : SearchView.this.stackPanels.keySet()) {
                    if (treeType == stack) continue;
                    StackPanel panel = SearchView.this.getStackPanel(treeType);
                    panel.close();
                    panel.clearSelection();
                }
            }
        });
    }

    @Override
    public void setTreeModel(final TreeTypeEnum treeType, final FVTreeModel pModel, final int nodeCount) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                StackPanel panel = SearchView.this.getStackPanel(treeType);
                panel.setVisible(true);
                panel.setTreeModel(pModel);
                panel.setSearchCount(nodeCount);
            }
        });
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener listener) {
        for (TreeTypeEnum id : this.stackPanels.keySet()) {
            this.stackPanels.get((Object)id).addTreeListener(listener);
        }
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        for (StackPanel sp : this.stackPanels.values()) {
            sp.setSelectionMode(selectionMode);
        }
    }

    @Override
    public void showTree(final boolean b) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SearchView.this.resultsTree.setVisible(b);
                SearchView.this.validate();
                SearchView.this.repaint();
            }
        });
    }
}

