/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.view.IStack;
import com.intel.stl.ui.monitor.view.NodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class StackPanel
extends JPanel {
    private static final long serialVersionUID = -2905931691586163645L;
    private final TreeTypeEnum id;
    private final JPanel headerPanel;
    private final JLabel nameLabel;
    private final JLabel arrowLabel;
    private JTree tree;
    private JLabel txtLabel;
    private boolean opened = false;

    public StackPanel(TreeTypeEnum type, JTree tree, final IStack stackInterface) {
        super(new GridBagLayout());
        this.id = type;
        this.setOpaque(false);
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        this.headerPanel.setPreferredSize(new Dimension(200, 30));
        this.headerPanel.setBackground(UIConstants.INTEL_WHITE);
        this.nameLabel = ComponentFactory.getH4Label(this.id.getName(), 1);
        this.headerPanel.add((Component)this.nameLabel, "West");
        this.arrowLabel = new JLabel(UIImages.DOWN_ICON.getImageIcon());
        this.headerPanel.add((Component)this.arrowLabel, "East");
        this.headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (StackPanel.this.opened) {
                    StackPanel.this.close();
                } else {
                    StackPanel.this.open();
                }
                stackInterface.stackChange(StackPanel.this.id);
            }
        });
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.add((Component)this.headerPanel, gc);
        gc.fill = 1;
        gc.insets = new Insets(2, 5, 5, 5);
        if (tree != null) {
            tree.setName(type.getName());
            tree.setCellRenderer(new NodeRenderer());
            tree.setVisible(false);
            this.tree = tree;
            this.add((Component)tree, gc);
        } else {
            this.txtLabel = new JLabel("Tree is unavailable at this time!");
            this.txtLabel.setVisible(false);
            this.add((Component)this.txtLabel, gc);
        }
    }

    public void setSearchCount(int n) {
        this.nameLabel.setText(this.id.getName() + " (" + String.valueOf(n) + ")");
    }

    public void setTreeModel(FVTreeModel pModel) {
        if (this.tree != null) {
            TreePath[] selections = null;
            Enumeration<TreePath> expanedPaths = null;
            if (this.tree.getModel() != null && this.tree.getModel().getRoot().equals(pModel.getRoot())) {
                selections = this.tree.getSelectionPaths();
                expanedPaths = this.tree.getExpandedDescendants(this.tree.getPathForRow(0));
            }
            this.tree.setModel(pModel);
            pModel.fireTreeStructureChanged(this, ((FVResourceNode)pModel.getRoot()).getPath());
            if (expanedPaths != null) {
                while (expanedPaths.hasMoreElements()) {
                    TreePath path = (TreePath)expanedPaths.nextElement();
                    this.tree.expandPath(path);
                }
            }
            if (selections != null) {
                TreeSelectionListener[] listeners;
                for (TreeSelectionListener listener : listeners = this.tree.getTreeSelectionListeners()) {
                    this.tree.removeTreeSelectionListener(listener);
                }
                TreePath[] newSels = pModel.getTreePaths(selections);
                this.tree.setSelectionPaths(newSels);
                for (TreeSelectionListener listener : listeners) {
                    this.tree.addTreeSelectionListener(listener);
                }
            }
        }
    }

    public TreeModel getTreeModel() {
        if (this.tree != null) {
            return this.tree.getModel();
        }
        return null;
    }

    public void open() {
        if (this.tree != null) {
            this.tree.setVisible(true);
            TreePath[] currentPaths = this.tree.getSelectionPaths();
            if (currentPaths != null && currentPaths.length > 0) {
                this.tree.removeSelectionPaths(currentPaths);
                this.tree.setSelectionPaths(currentPaths);
            } else {
                this.tree.setSelectionRow(0);
                this.tree.scrollRowToVisible(0);
            }
        } else {
            this.txtLabel.setVisible(true);
        }
        this.arrowLabel.setIcon(UIImages.UP_ICON.getImageIcon());
        this.opened = true;
    }

    public void close() {
        if (!this.opened) {
            return;
        }
        if (this.tree != null) {
            this.tree.setVisible(false);
        } else {
            this.txtLabel.setVisible(false);
        }
        this.arrowLabel.setIcon(UIImages.DOWN_ICON.getImageIcon());
        this.opened = false;
    }

    public void setSelectionMode(int selectionMode) {
        if (this.tree != null) {
            this.tree.getSelectionModel().setSelectionMode(selectionMode);
        }
    }

    public void select(int index) {
        if (this.tree != null) {
            this.tree.setSelectionRow(index);
        }
    }

    public void select(TreePath[] paths, boolean[] isExpanded) {
        if (this.tree != null) {
            TreePath[] newSels = ((FVTreeModel)this.tree.getModel()).getTreePaths(paths);
            this.tree.setSelectionPaths(newSels);
            if (paths.length > 0) {
                for (int i = 0; i < paths.length; ++i) {
                    if (!isExpanded[i]) {
                        this.tree.collapsePath(paths[i]);
                    } else {
                        this.tree.expandPath(paths[i]);
                    }
                    this.tree.makeVisible(paths[i]);
                }
                int row = this.tree.getRowForPath(paths[0]);
                if ((row += 5) > this.tree.getRowCount()) {
                    row = this.tree.getRowCount() - 1;
                }
                this.tree.scrollRowToVisible(row);
            }
        }
    }

    public void clearSelection() {
        if (this.tree != null) {
            this.tree.clearSelection();
        }
    }

    public void collapse(TreePath path) {
        if (this.tree != null) {
            this.tree.collapsePath(path);
        }
    }

    public void expand(TreePath path) {
        if (this.tree != null) {
            this.tree.expandPath(path);
        }
    }

    public void addTreeListener(TreeSelectionListener treeListener) {
        if (this.tree != null) {
            this.tree.addTreeSelectionListener(treeListener);
        }
    }

    public boolean isOpened() {
        return this.opened;
    }
}

