/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.configuration.view.IPropertyListener;
import com.intel.stl.ui.configuration.view.PropertyGroupPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.PropertySet;
import com.intel.stl.ui.model.SimplePropertyGroup;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.ResourceSection;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopSummaryGroupController;
import com.intel.stl.ui.network.TopologySummaryProcessor;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.view.ResourceAllView;
import com.intel.stl.ui.network.view.TopSummaryGroupPanel;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.SingleTaskManager;
import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import net.engio.mbassy.bus.MBassador;

public class ResourceAllSection
extends ResourceSection<ResourceAllView>
implements IPropertyListener {
    private final String SUBNET_SUMMARY = STLConstants.K2063_OVERALL_SUMMARY.getValue();
    private final String TOP_SUMMARY = STLConstants.K2064_TOP_SUMMARY.getValue();
    private final PropertyVizStyle style = new PropertyVizStyle(true, false);
    private final ResourceAllView view;
    private PropertySet<SimplePropertyGroup> model;
    private ISubnetApi subnetApi;
    private final SingleTaskManager taskMgr;
    private FVResourceNode[] selectedResources;
    protected UndoHandler undoHandler;

    public ResourceAllSection(ResourceAllView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.view = view;
        view.setInitialStyle(this.style.isShowBorder(), this.style.isAlternatRows());
        view.setStyleListener(this);
        this.taskMgr = new SingleTaskManager();
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getNameOfSubnet();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        if (context != null) {
            this.subnetApi = context.getSubnetApi();
            if (context.getController() != null) {
                this.undoHandler = context.getController().getUndoHandler();
            }
        }
    }

    @Override
    public void setCurrentSubpage(String subpageName) {
    }

    @Override
    public String getPreviousSubpage() {
        return null;
    }

    @Override
    public String getCurrentSubpage() {
        return null;
    }

    @Override
    public ResourceAllView getView() {
        return this.view;
    }

    public void showAll(final FVResourceNode[] selectedResources, final String name, final Icon icon, final TopologyTreeModel topArch, final TopGraph graph, final TopGraph fullGraph) {
        this.selectedResources = selectedResources;
        CancellableCall<PropertySet<SimplePropertyGroup>> caller = new CancellableCall<PropertySet<SimplePropertyGroup>>(){

            @Override
            public PropertySet<SimplePropertyGroup> call(ICancelIndicator cancelIndicator) throws Exception {
                TopologySummaryProcessor topProcessor = new TopologySummaryProcessor(ResourceAllSection.this.SUBNET_SUMMARY, ResourceAllSection.this.TOP_SUMMARY, topArch, graph, fullGraph, ResourceAllSection.this.subnetApi, cancelIndicator);
                PropertySet<SimplePropertyGroup> model = topProcessor.populate();
                return model;
            }
        };
        CallbackAdapter<PropertySet<SimplePropertyGroup>> callback = new CallbackAdapter<PropertySet<SimplePropertyGroup>>(){

            @Override
            public void onDone(PropertySet<SimplePropertyGroup> result) {
                ResourceAllSection.this.view.setTitle(name, icon);
                ResourceAllSection.this.updateMode(selectedResources, result);
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    protected void updateMode(FVResourceNode[] selResources, PropertySet<SimplePropertyGroup> model) {
        this.model = model;
        this.view.clearPanel();
        for (SimplePropertyGroup group : model.getGroups()) {
            if (group.getGroupName() == this.SUBNET_SUMMARY) {
                this.updateSubnetSummaryModel(group);
                continue;
            }
            if (group.getGroupName() != this.TOP_SUMMARY) continue;
            this.updateTopSummaryModel(selResources, group);
        }
        this.view.setModel(model);
    }

    protected void updateSubnetSummaryModel(SimplePropertyGroup model) {
        PropertyGroupPanel groupPanel = new PropertyGroupPanel(this.style);
        groupPanel.setModel(model);
        groupPanel.enableHelp(true);
        HelpAction helpAction = HelpAction.getInstance();
        helpAction.getHelpBroker().enableHelpOnButton((Component)groupPanel.getHelpButton(), helpAction.getOverallSummary(), helpAction.getHelpSet());
        this.view.addPropertyGroupPanel(groupPanel);
    }

    protected SimplePropertyGroup populateTopSummaryModel() {
        SimplePropertyGroup model = new SimplePropertyGroup(STLConstants.K2064_TOP_SUMMARY.getValue());
        return model;
    }

    protected void updateTopSummaryModel(FVResourceNode[] selResources, SimplePropertyGroup model) {
        TopSummaryGroupPanel groupPanel = new TopSummaryGroupPanel(this.style);
        TopSummaryGroupController groupController = new TopSummaryGroupController(groupPanel, (MBassador<IAppEvent>)this.eventBus, this.undoHandler);
        groupController.setModel(selResources, model);
        this.view.addPropertyGroupPanel(groupPanel);
    }

    @Override
    public ICardController<?>[] getCards() {
        return null;
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    @Override
    public void onShowBorder(boolean b) {
        this.style.setShowBorder(b);
        this.updateMode(this.selectedResources, this.model);
    }

    @Override
    public void onShowAlternation(boolean b) {
        this.style.setAlternateRows(b);
        this.updateMode(this.selectedResources, this.model);
    }

    @Override
    public void onDisplayChanged(Map<String, Boolean> newSelections) {
    }
}

