/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.configuration.view.DevicePropertiesPanel;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.model.ConnectivityTableColumns;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.DeviceProperties;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.monitor.CableInfoPopupController;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.CableInfoPopupView;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import com.intel.stl.ui.network.IResourceNodeSubpageController;
import com.intel.stl.ui.network.ResourceNodePage;
import com.intel.stl.ui.network.ResourcePortPage;
import com.intel.stl.ui.network.ResourceSection;
import com.intel.stl.ui.network.TopologyPage;
import com.intel.stl.ui.network.UndoableNodeSubpageSelection;
import com.intel.stl.ui.network.view.ResourcePortView;
import com.intel.stl.ui.network.view.ResourceSubpageView;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public class ResourceNodeSection
extends ResourceSection<ResourceSubpageView>
implements IPortSelectionListener,
IPageListener {
    private List<IResourceNodeSubpageController> mSubpages;
    private GraphNode lastNode;
    private EnumMap<TreeNodeType, List<IResourceNodeSubpageController>> pageMap;
    private final DeviceProperties model;
    private CableInfoPopupController cableInfoPopupController;
    private String previousSubpageName;
    private String currentSubpageName;
    private UndoHandler undoHandler;
    private final String origin = TopologyPage.NAME;

    public ResourceNodeSection(ResourceSubpageView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.view = view;
        view.setPageListener(this);
        this.model = new DeviceProperties();
        this.initSubpages();
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getTopologyNode();
    }

    @Override
    public void setContext(Context pContext, IProgressObserver observer) {
        this.cableInfoPopupController.setContext(pContext, observer);
        if (pContext != null && pContext.getController() != null) {
            this.undoHandler = pContext.getController().getUndoHandler();
        }
        IProgressObserver[] subObservers = observer.createSubObservers(this.mSubpages.size());
        for (int i = 0; i < this.mSubpages.size(); ++i) {
            this.mSubpages.get(i).setContext(pContext, subObservers[i]);
            subObservers[i].onFinish();
            if (!observer.isCancelled()) continue;
            for (int j = 0; j <= i; ++j) {
                this.mSubpages.get(j).clear();
            }
            return;
        }
    }

    @Override
    public void setCurrentSubpage(String subpageName) {
        this.previousSubpageName = this.currentSubpageName;
        this.currentSubpageName = subpageName;
    }

    @Override
    public String getPreviousSubpage() {
        return this.previousSubpageName;
    }

    @Override
    public String getCurrentSubpage() {
        return this.currentSubpageName;
    }

    protected void showNode(FVResourceNode source, GraphNode node) {
        if (source == null) {
            return;
        }
        ((ResourceSubpageView)this.view).setTitle(source.getName(), source.getType().getIcon());
        if (this.lastNode != null && this.lastNode.equals(node)) {
            IResourceNodeSubpageController currentSubpage = this.getCurrentSubpage(source.getType());
            if (currentSubpage != null) {
                currentSubpage.showNode(source, node);
            }
            return;
        }
        this.lastNode = node;
        for (IResourceNodeSubpageController page : this.mSubpages) {
            page.clear();
        }
        List<IResourceNodeSubpageController> subpages = this.getSubpagesByType(source.getType());
        if (subpages != null) {
            if (this.currentSubpageName == null) {
                this.previousSubpageName = null;
                this.currentSubpageName = ((ResourceSubpageView)this.view).getCurrentSubpage();
            }
            int curIndex = -1;
            for (int i = 0; i < subpages.size(); ++i) {
                IResourceNodeSubpageController subpage = subpages.get(i);
                if (subpage.getName().equals(this.currentSubpageName)) {
                    curIndex = i;
                }
                subpage.showNode(source, node);
            }
            ((ResourceSubpageView)this.view).setTabs(subpages, curIndex);
        }
    }

    protected IResourceNodeSubpageController getCurrentSubpage(TreeNodeType type) {
        List<IResourceNodeSubpageController> subpages = this.getSubpagesByType(type);
        if (subpages != null) {
            String current = ((ResourceSubpageView)this.view).getCurrentSubpage();
            if (current != null) {
                for (int i = 0; i < subpages.size(); ++i) {
                    IResourceNodeSubpageController subpage = subpages.get(i);
                    if (!current.equals(subpage.getName())) continue;
                    return subpage;
                }
            } else {
                return subpages.get(0);
            }
        }
        return null;
    }

    protected void initSubpages() {
        ConnectivityTableModel portTableModel = new ConnectivityTableModel();
        ConnectivitySubpageView portTableView = this.createPortView(portTableModel);
        CableInfoPopupView cableInfoPopupView = new CableInfoPopupView(portTableView);
        portTableView.setCableInfoPopupView(cableInfoPopupView);
        this.cableInfoPopupController = new CableInfoPopupController(cableInfoPopupView);
        cableInfoPopupView.setCableInfoListener(this.cableInfoPopupController);
        portTableView.setPortSelectionListener(this);
        DevicePropertiesPanel switchNodeView = new DevicePropertiesPanel();
        DevicePropertiesPanel hfiNodeView = new DevicePropertiesPanel();
        ResourcePortView portView = new ResourcePortView();
        ResourceNodePage switchNodePage = new ResourceNodePage(this.model, switchNodeView, (MBassador<IAppEvent>)this.eventBus);
        ResourceNodePage hfiNodePage = new ResourceNodePage(this.model, hfiNodeView, (MBassador<IAppEvent>)this.eventBus);
        ResourcePortPage portPage = new ResourcePortPage(portTableModel, portTableView, portView);
        this.mSubpages = Arrays.asList(hfiNodePage, switchNodePage, portPage);
        this.pageMap = new EnumMap(TreeNodeType.class);
        this.pageMap.put(TreeNodeType.SWITCH, Arrays.asList(switchNodePage, portPage));
        this.pageMap.put(TreeNodeType.HFI, Arrays.asList(hfiNodePage, portPage));
    }

    protected List<IResourceNodeSubpageController> getSubpagesByType(TreeNodeType type) {
        return this.pageMap.get((Object)type);
    }

    @Override
    public boolean canPageChange(String oldPage, String newPage) {
        return true;
    }

    @Override
    public synchronized void onPageChanged(String oldPage, String newPage) {
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableNodeSubpageSelection undoSel = new UndoableNodeSubpageSelection((ResourceSubpageView)this.view, oldPage, newPage);
            this.undoHandler.addUndoAction(undoSel);
        }
        this.previousSubpageName = oldPage;
        this.currentSubpageName = newPage;
    }

    protected ConnectivitySubpageView createPortView(ConnectivityTableModel portTableModel) {
        ConnectivitySubpageView portTableView = new ConnectivitySubpageView(portTableModel){
            private static final long serialVersionUID = 5930204470646720711L;

            @Override
            protected void filterColumns() {
                ConnectivityTableColumns[] toShow = new ConnectivityTableColumns[]{ConnectivityTableColumns.NODE_NAME, ConnectivityTableColumns.PORT_NUMBER, ConnectivityTableColumns.CABLE_INFO, ConnectivityTableColumns.LINK_STATE, ConnectivityTableColumns.PHYSICAL_LINK_STATE, ConnectivityTableColumns.LINK_QUALITY, ConnectivityTableColumns.ACTIVE_LINK_WIDTH, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_TX, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_RX, ConnectivityTableColumns.ACTIVE_LINK_SPEED, ConnectivityTableColumns.RX_DATA, ConnectivityTableColumns.TX_DATA, ConnectivityTableColumns.LINK_DOWNED};
                ConnectivityTableColumns[] all = ConnectivityTableColumns.values();
                boolean[] vis = new boolean[all.length];
                for (ConnectivityTableColumns col : toShow) {
                    vis[col.getId()] = true;
                }
                for (int i = 0; i < vis.length; ++i) {
                    this.mTable.getColumnExt((Object)all[i].getTitle()).setVisible(vis[i]);
                }
            }
        };
        return portTableView;
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    @Override
    public void onPortSelection(int rowIndex) {
    }

    @Override
    public void onJumpToPort(int lid, short portNum, String destination) {
        if (this.eventBus != null) {
            PortsSelectedEvent pse = new PortsSelectedEvent(lid, portNum, this, destination);
            this.eventBus.publish((Object)pse);
            if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
                NodeType type = NodeType.getNodeType(this.lastNode.getType());
                UndoableJumpEvent undoSel = new UndoableJumpEvent((MBassador<IAppEvent>)this.eventBus, new NodesSelectedEvent(this.lastNode.getLid(), type, this, this.origin), pse);
                this.undoHandler.addUndoAction(undoSel);
            }
        }
    }

    @Override
    public ICardController<?>[] getCards() {
        return null;
    }
}

