/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.GraphNode;
import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.io.mxObjectCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphSelectionModel;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxStylesheet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopGraph
extends mxGraph {
    private static final String TOP = "N";
    private static final Logger log = LoggerFactory.getLogger(TopGraph.class);
    private AtomicReference<mxIGraphModel> modelRef;
    private Map<String, Map<String, Object>> highlightedEdges;
    private Map<Map<String, Object>, Map<String, Object>> cachedHighlighStyle;
    private Set<String> markedEdges;
    private double vertexScaleThreshold;

    public TopGraph() {
        this(null, null);
    }

    public TopGraph(mxIGraphModel model) {
        this(model, null);
    }

    public TopGraph(mxStylesheet stylesheet) {
        this(null, stylesheet);
    }

    public TopGraph(mxIGraphModel model, mxStylesheet stylesheet) {
        super(model, stylesheet);
    }

    protected mxGraphSelectionModel createSelectionModel() {
        return new TopSelectionModel(this);
    }

    public void setVertexScaleThreshold(double vertexScaleThreshold) {
        this.vertexScaleThreshold = vertexScaleThreshold;
    }

    public String getToolTipForCell(Object cell) {
        GraphNode node;
        if (this.model.isVertex(cell) && (node = (GraphNode)((mxCell)cell).getValue()).hasEndNodes() && node.isCollapsed()) {
            return UILabels.STL70001_COLLAPSABLE_NODE_TOOLTIP.getDescription(node.getName(), Integer.toString(node.getEndNeighbor().size()));
        }
        return super.getToolTipForCell(cell);
    }

    protected mxGraphView createGraphView() {
        this.highlightedEdges = new HashMap<String, Map<String, Object>>();
        this.cachedHighlighStyle = new HashMap<Map<String, Object>, Map<String, Object>>();
        this.markedEdges = new HashSet<String>();
        return new GraphView(this);
    }

    public mxIGraphModel getModel() {
        if (this.modelRef == null) {
            throw new RuntimeException("modelRef get is null in getModel.");
        }
        return this.modelRef.get();
    }

    public void setModel(mxIGraphModel model) {
        super.setModel(model);
        this.restoreSelection(model, null);
        if (this.modelRef == null) {
            this.modelRef = new AtomicReference();
        }
        this.modelRef.set(model);
        if (this.highlightedEdges != null || this.markedEdges != null) {
            this.refresh();
        }
    }

    public void setModel(mxIGraphModel model, ICancelIndicator indicator) {
        super.setModel(model);
        this.restoreSelection(model, indicator);
        this.modelRef.set(model);
        if (this.highlightedEdges != null || this.markedEdges != null) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSelection(mxIGraphModel model, ICancelIndicator indicator) {
        Object[] children;
        Object[] curSelections = this.getSelectionCells();
        if (curSelections.length == 0) {
            return;
        }
        LinkedHashMap<String, mxCell> selections = new LinkedHashMap<String, mxCell>();
        for (Object obj : curSelections) {
            selections.put(((mxCell)obj).getId(), null);
        }
        for (Object child : children = mxGraphModel.getChildCells((mxIGraphModel)model, (Object)this.getDefaultParent(), (boolean)false, (boolean)false)) {
            if (indicator != null && indicator.isCancelled()) {
                log.info("setModel " + ((mxCell)model.getRoot()).getId() + " cancelled.");
                return;
            }
            mxCell cell = (mxCell)child;
            if (!selections.containsKey(cell.getId())) continue;
            selections.put(cell.getId(), cell);
        }
        TopGraph topGraph = this;
        synchronized (topGraph) {
            this.selectionModel.setCells(selections.values().toArray());
        }
        if (indicator != null && indicator.isCancelled()) {
            log.info("setModel " + ((mxCell)model.getRoot()).getId() + " cancelled.");
            return;
        }
    }

    public mxCell getVertex(int lid) {
        String cellId = TopGraph.getVertexId(lid);
        return (mxCell)((mxGraphModel)this.getModel()).getCell(cellId);
    }

    public mxCell getEdge(int fromId, int toId) {
        String cellId = TopGraph.getEdgeId(fromId, toId);
        mxCell res = (mxCell)((mxGraphModel)this.getModel()).getCell(cellId);
        if (res == null) {
            cellId = TopGraph.getEdgeId(toId, fromId);
            res = (mxCell)((mxGraphModel)this.getModel()).getCell(cellId);
        }
        return res;
    }

    public Object[] getVertices() {
        return mxGraphModel.getChildCells((mxIGraphModel)this.model, (Object)this.getDefaultParent(), (boolean)true, (boolean)false);
    }

    public void collapseAll() {
        this.setCollapseState(true);
    }

    public void expandAll() {
        this.setCollapseState(false);
    }

    protected void setCollapseState(boolean b) {
        Object[] children;
        for (Object child : children = mxGraphModel.getChildCells((mxIGraphModel)this.model, (Object)this.getDefaultParent(), (boolean)true, (boolean)false)) {
            GraphNode node = (GraphNode)((mxCell)child).getValue();
            if (!node.hasEndNodes()) continue;
            node.setCollapsed(b);
        }
    }

    private void highlight(mxCell cell) {
        Map<String, Object> style = this.highlightedEdges.get(cell.getId());
        if (style == null) {
            Map orgStyle = this.getCellStyle(cell);
            style = this.cachedHighlighStyle.get(orgStyle);
            if (style == null) {
                style = new HashMap<String, Object>(orgStyle);
                style.put(mxConstants.STYLE_STROKECOLOR, "#DD8800");
                style.put(mxConstants.STYLE_STROKEWIDTH, "3");
                style.put(mxConstants.STYLE_OPACITY, "100");
                this.cachedHighlighStyle.put(orgStyle, style);
            }
            this.highlightedEdges.put(cell.getId(), style);
        }
    }

    private void dehighlight(mxCell cell) {
        this.highlightedEdges.remove(cell.getId());
    }

    public synchronized void highlightConnections(mxCell cell, boolean highlight) {
        if (cell == null) {
            return;
        }
        int numEdges = cell.getEdgeCount();
        for (int i = 0; i < numEdges; ++i) {
            mxCell edge = (mxCell)cell.getEdgeAt(i);
            if (highlight) {
                this.highlight(edge);
                continue;
            }
            this.dehighlight(edge);
        }
        this.refresh();
    }

    public synchronized void clearHighlightedEdges() {
        this.highlightedEdges.clear();
        this.refresh();
    }

    private void mark(mxCell cell) {
        this.markedEdges.add(cell.getId());
    }

    private void demark(mxCell cell) {
        this.markedEdges.remove(cell.getId());
    }

    public synchronized void markConnections(Collection<mxCell> cells, boolean selected, ICancelIndicator indicator) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        for (mxCell cell : cells) {
            int numEdges = cell.getEdgeCount();
            for (int i = 0; i < numEdges; ++i) {
                if (indicator != null && indicator.isCancelled()) {
                    return;
                }
                mxCell edge = (mxCell)cell.getEdgeAt(i);
                if (selected) {
                    this.mark(edge);
                    continue;
                }
                this.demark(edge);
            }
        }
        this.fireMarkEvent();
        this.refresh();
    }

    public synchronized void markEdges(Collection<mxCell> cells, boolean selected) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        for (mxCell cell : cells) {
            if (selected) {
                this.mark(cell);
                continue;
            }
            this.demark(cell);
        }
        this.fireMarkEvent();
        this.refresh();
    }

    public synchronized void clearMarkedEdges() {
        this.markedEdges.clear();
        this.fireMarkEvent();
        this.refresh();
    }

    protected void fireMarkEvent() {
        this.fireEvent(new mxEventObject(mxEvent.MARK));
    }

    public synchronized boolean isMarked(mxCell cell) {
        String cellId = cell.getId();
        return this.markedEdges.contains(cellId);
    }

    public void setSelectionCells(Object[] cells) {
        mxGraphModel model = (mxGraphModel)this.getModel();
        Object[] realCells = null;
        if (cells != null) {
            realCells = new Object[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                String id = ((mxCell)cells[i]).getId();
                realCells[i] = model.getCell(id);
            }
        }
        super.setSelectionCells(realCells);
    }

    public synchronized void clearSelection() {
        super.clearSelection();
    }

    public void clear() {
        mxCell root = (mxCell)this.getDefaultParent();
        while (root.getChildCount() > 0) {
            root.remove(0);
        }
        mxGraphModel model = (mxGraphModel)this.getModel();
        if (model != null) {
            model.getCells().clear();
        }
    }

    public TopGraph getGraphCopy(int modelId, ICancelIndicator indicator) {
        mxIGraphModel org = this.getModel();
        Object[] rootCopy = org.cloneCells(new Object[]{org.getRoot()}, true);
        mxCell rootCell = (mxCell)rootCopy[0];
        rootCell.setId(this.getModelName(modelId));
        int childCount = rootCell.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (indicator != null && indicator.isCancelled()) {
                throw new CancellationException();
            }
            mxCell child = (mxCell)rootCell.getChildAt(i);
            this.resetId(child);
        }
        mxGraphModel newModel = new mxGraphModel(rootCopy[0]);
        TopGraph newGraph = TopGraph.createGraph();
        newGraph.setModel((mxIGraphModel)newModel);
        this.cloneGraphNodes(newGraph, indicator);
        return newGraph;
    }

    protected void resetId(mxCell cell) {
        cell.setId(TopGraph.getPreferedId(cell));
        int childCount = cell.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            mxCell child = (mxCell)cell.getChildAt(i);
            this.resetId(child);
        }
    }

    public TopGraph filterBy(int modelId, Collection<Integer> members, boolean includeNeighbors, ICancelIndicator indicator) {
        if (members == null) {
            return this.getGraphCopy(modelId, indicator);
        }
        if (members.isEmpty()) {
            return TopGraph.createGraph();
        }
        mxGraphModel org = (mxGraphModel)this.getModel();
        mxCell rootCell = new mxCell();
        rootCell.setId(this.getModelName(modelId));
        mxCell baseCell = new mxCell();
        rootCell.insert((mxICell)baseCell);
        try {
            HashMap<String, mxCell> newCells = new HashMap<String, mxCell>();
            for (int lid : members) {
                if (indicator != null && indicator.isCancelled()) {
                    throw new CancellationException();
                }
                String cellId = TopGraph.getVertexId(lid);
                mxCell cell = (mxCell)org.getCell(cellId);
                mxCell copy = (mxCell)cell.clone();
                copy.setId(cellId);
                baseCell.insert((mxICell)copy);
                newCells.put(cellId, copy);
            }
            for (int lid : members) {
                if (indicator != null && indicator.isCancelled()) {
                    throw new CancellationException();
                }
                mxCell cell = (mxCell)org.getCell(TopGraph.getVertexId(lid));
                int numEdges = cell.getEdgeCount();
                if (numEdges <= 0) continue;
                for (int i = 0; i < numEdges; ++i) {
                    mxCell target;
                    mxCell cloneTarget;
                    mxCell edge = (mxCell)cell.getEdgeAt(i);
                    mxCell cloneEdge = (mxCell)edge.clone();
                    cloneEdge.setId(edge.getId());
                    mxCell source = (mxCell)edge.getTerminal(true);
                    mxCell cloneSource = (mxCell)newCells.get(source.getId());
                    if (cloneSource == null && includeNeighbors) {
                        cloneSource = (mxCell)source.clone();
                        cloneSource.setId(source.getId());
                        baseCell.insert((mxICell)cloneSource);
                        newCells.put(source.getId(), cloneSource);
                    }
                    if ((cloneTarget = (mxCell)newCells.get((target = (mxCell)edge.getTerminal(false)).getId())) == null && includeNeighbors) {
                        cloneTarget = (mxCell)target.clone();
                        cloneTarget.setId(target.getId());
                        baseCell.insert((mxICell)cloneTarget);
                        newCells.put(target.getId(), cloneTarget);
                    }
                    if (cloneSource == null || cloneTarget == null) continue;
                    baseCell.insert((mxICell)cloneEdge);
                    cloneSource.insertEdge((mxICell)cloneEdge, true);
                    cloneTarget.insertEdge((mxICell)cloneEdge, false);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        mxGraphModel newModel = new mxGraphModel((Object)rootCell);
        TopGraph newGraph = TopGraph.createGraph();
        newGraph.setModel((mxIGraphModel)newModel);
        this.cloneGraphNodes(newGraph, indicator);
        return newGraph;
    }

    protected void dump(String prefix, mxCell cell) {
        System.out.println(prefix + cell.getId() + " edges=" + cell.getEdgeCount() + " " + cell.getSource() + "->" + cell.getTarget());
        Object val = cell.getValue();
        if (val != null) {
            ((GraphNode)val).dump(System.out);
        }
        int count = cell.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.dump(prefix + "  ", (mxCell)cell.getChildAt(i));
        }
    }

    protected String getModelName(int modelId) {
        return "Model " + modelId;
    }

    protected void cloneGraphNodes(TopGraph graph, ICancelIndicator indicator) {
        GraphNode gNode;
        mxCell cell;
        Object[] children;
        for (Object child : children = mxGraphModel.getChildCells((mxIGraphModel)graph.getModel(), (Object)graph.getDefaultParent(), (boolean)true, (boolean)false)) {
            if (indicator != null && indicator.isCancelled()) {
                throw new CancellationException();
            }
            cell = (mxCell)child;
            gNode = (GraphNode)cell.getValue();
            cell.setValue((Object)gNode.copy());
        }
        for (Object child : children) {
            TreeMap<GraphNode, TreeMap<Integer, Integer>> endNodes;
            if (indicator != null && indicator.isCancelled()) {
                throw new CancellationException();
            }
            cell = (mxCell)child;
            gNode = (GraphNode)cell.getValue();
            TreeMap<GraphNode, TreeMap<Integer, Integer>> middleNodes = gNode.getMiddleNodes();
            if (middleNodes != null) {
                TreeMap<GraphNode, TreeMap<Integer, Integer>> newMiddleNodes = this.updateNodeMap(middleNodes, graph);
                gNode.setMiddleNodes(newMiddleNodes);
            }
            if ((endNodes = gNode.getEndNodes()) == null) continue;
            TreeMap<GraphNode, TreeMap<Integer, Integer>> newEndNodes = this.updateNodeMap(endNodes, graph);
            gNode.setEndNodes(newEndNodes);
        }
    }

    protected TreeMap<GraphNode, TreeMap<Integer, Integer>> updateNodeMap(TreeMap<GraphNode, TreeMap<Integer, Integer>> target, TopGraph graph) {
        TreeMap<GraphNode, TreeMap<Integer, Integer>> res = new TreeMap<GraphNode, TreeMap<Integer, Integer>>();
        for (GraphNode node : target.keySet()) {
            mxCell cell = graph.getVertex(node.getLid());
            if (cell == null) continue;
            GraphNode newNode = (GraphNode)cell.getValue();
            res.put(newNode, target.get(node));
        }
        return res;
    }

    public static TopGraph createGraph() {
        TopGraph graph = new TopGraph();
        graph.setAllowDanglingEdges(false);
        graph.setCellsResizable(false);
        graph.setCellsEditable(false);
        graph.setCellsCloneable(false);
        graph.setEdgeLabelsMovable(false);
        graph.setCellsDisconnectable(false);
        graph.setSplitEnabled(false);
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_NOLABEL, "1");
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_MOVABLE, "0");
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_ENDARROW, "0");
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_STARTARROW, "0");
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_STROKECOLOR, "gray");
        graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_OPACITY, "25");
        graph.getStylesheet().getDefaultVertexStyle().put(mxConstants.STYLE_NOLABEL, "1");
        return graph;
    }

    public static String getPreferedId(mxCell cell) {
        if (cell.isVertex()) {
            int lid = ((GraphNode)cell.getValue()).getLid();
            return TopGraph.getVertexId(lid);
        }
        if (cell.isEdge()) {
            mxCell source = (mxCell)cell.getSource();
            mxCell target = (mxCell)cell.getTarget();
            return TopGraph.getEdgeId(source, target);
        }
        return cell.getId();
    }

    public static String getVertexId(int lid) {
        return "N_" + Integer.toString(lid);
    }

    public static String getEdgeId(mxCell source, mxCell target) {
        int sourceLid = ((GraphNode)source.getValue()).getLid();
        int targetLid = ((GraphNode)target.getValue()).getLid();
        return TopGraph.getEdgeId(sourceLid, targetLid);
    }

    public static String getEdgeId(int sourceLid, int targetLid) {
        return TopGraph.getVertexId(sourceLid) + ":" + TopGraph.getVertexId(targetLid);
    }

    static {
        mxCodecRegistry.addPackage((String)GraphNode.class.getPackage().getName());
        mxCodecRegistry.register((mxObjectCodec)new mxObjectCodec((Object)new GraphNode()));
    }

    class TopSelectionModel
    extends mxGraphSelectionModel {
        private boolean isVertexSelection;

        public TopSelectionModel(mxGraph graph) {
            super(graph);
        }

        public void setCells(Object[] cells) {
            if (cells != null) {
                Object[][] splittedCells = this.split(cells);
                Object[] vertices = splittedCells[0];
                Object[] edges = splittedCells[1];
                if (vertices.length > 0) {
                    this.isVertexSelection = true;
                    super.setCells(vertices);
                } else {
                    this.isVertexSelection = false;
                    super.setCells(edges);
                }
            } else {
                this.clear();
            }
        }

        public void addCells(Object[] cells) {
            if (cells == null) {
                return;
            }
            Set remove = null;
            ArrayList<Object> tmp = new ArrayList<Object>(cells.length);
            if (this.singleSelection) {
                remove = this.cells;
                cells = new Object[]{this.getFirstSelectableCell(cells)};
            } else {
                Object[][] splittedCells = this.split(cells);
                Object[] vertices = splittedCells[0];
                Object[] edges = splittedCells[1];
                if (vertices.length > 0) {
                    if (!this.isVertexSelection) {
                        remove = this.cells;
                        this.isVertexSelection = true;
                    }
                    cells = vertices;
                } else {
                    if (this.isVertexSelection) {
                        remove = this.cells;
                        this.isVertexSelection = false;
                    }
                    cells = edges;
                }
            }
            for (int i = 0; i < cells.length; ++i) {
                if (this.isSelected(cells[i]) || !this.graph.isCellSelectable(cells[i])) continue;
                tmp.add(cells[i]);
            }
            this.changeSelection(tmp, remove);
        }

        protected Object[][] split(Object[] cells) {
            ArrayList<Object> vertices = new ArrayList<Object>();
            ArrayList<Object> edges = new ArrayList<Object>();
            mxIGraphModel model = this.graph.getModel();
            for (Object cell : cells) {
                if (model.isVertex(cell)) {
                    vertices.add(cell);
                    continue;
                }
                edges.add(cell);
            }
            return new Object[][]{vertices.toArray(), edges.toArray()};
        }
    }

    class GraphView
    extends mxGraphView {
        public GraphView(mxGraph graph) {
            super(graph);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public mxCellState createState(Object cell) {
            Map style = null;
            GraphView graphView = this;
            synchronized (graphView) {
                String cellId = ((mxCell)cell).getId();
                style = (Map)TopGraph.this.highlightedEdges.get(cellId);
            }
            if (style != null) {
                return new mxCellState((mxGraphView)this, cell, style);
            }
            return super.createState(cell);
        }

        public void updateVertexLabelOffset(mxCellState state) {
            super.updateVertexLabelOffset(state);
        }
    }
}

