/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.event.GroupsSelectedEvent;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.SimplePropertyCategory;
import com.intel.stl.ui.model.SimplePropertyGroup;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.TopologyPage;
import com.intel.stl.ui.network.TopologyTier;
import com.intel.stl.ui.network.view.TopSummaryGroupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public class TopSummaryGroupController {
    private final TopSummaryGroupPanel view;
    private final MBassador<IAppEvent> eventBus;
    private final UndoHandler undoHandler;

    public TopSummaryGroupController(TopSummaryGroupPanel view, MBassador<IAppEvent> eventBus, UndoHandler undoHandler) {
        this.view = view;
        this.eventBus = eventBus;
        this.undoHandler = undoHandler;
        view.enableHelp(true);
        HelpAction helpAction = HelpAction.getInstance();
        helpAction.getHelpBroker().enableHelpOnButton((Component)view.getHelpButton(), helpAction.getTopologySummary(), helpAction.getHelpSet());
    }

    public void setModel(FVResourceNode[] selResources, SimplePropertyGroup model) {
        JumpToEvent origin = this.getOrigin(selResources);
        this.view.init(model.size());
        List<SimplePropertyCategory> categories = model.getList();
        int maxPortsSegment = this.getMaxPortsSegment(categories);
        for (int i = 0; i < categories.size(); ++i) {
            TopologyTier tier = (TopologyTier)categories.get(i).getItems().iterator().next().getObject();
            this.updateTierView(i, tier, maxPortsSegment, origin);
        }
    }

    protected JumpToEvent getOrigin(FVResourceNode[] selResources) {
        GroupsSelectedEvent event = new GroupsSelectedEvent(this, TopologyPage.NAME);
        for (FVResourceNode node : selResources) {
            event.addGroup(node.getTitle(), node.getType());
        }
        return event;
    }

    protected void updateTierView(int index, TopologyTier tier, double maxPortsSegment, JumpToEvent origin) {
        this.view.setTierName(index, tier.getName());
        String numSwitches = UIConstants.INTEGER.format(tier.getNumSwitches());
        String numHFIs = UIConstants.INTEGER.format(tier.getNumHFIs());
        String numPorts = UIConstants.INTEGER.format(tier.getTotalPorts());
        this.view.setSummary(index, numSwitches, numHFIs, numPorts);
        TopologyTier.Quality up = tier.getUpQuality();
        TopologyTier.Quality down = tier.getDownQuality();
        double[] normalizedVals = new double[]{(double)up.getTotalPorts() / maxPortsSegment, (double)down.getTotalPorts() / maxPortsSegment, (double)tier.getNumOtherPorts() / maxPortsSegment};
        String[] values = new String[]{UIConstants.INTEGER.format(up.getTotalPorts()), UIConstants.INTEGER.format(down.getTotalPorts()), UIConstants.INTEGER.format(tier.getNumOtherPorts())};
        String[] labels = new String[]{STLConstants.K2069_UP_PORTS.getValue(), STLConstants.K2070_DOWN_PORTS.getValue(), STLConstants.K2071_OTHER_PORTS.getValue()};
        Color[] colors = new Color[]{UIConstants.INTEL_DARK_BLUE, UIConstants.INTEL_DARK_GREEN, UIConstants.INTEL_DARK_ORANGE};
        this.view.setPortsDist(index, normalizedVals, values, colors, labels, null);
        normalizedVals = new double[]{(double)up.getNumSlowPorts() / maxPortsSegment, (double)down.getNumSlowPorts() / maxPortsSegment};
        values = new String[]{UIConstants.INTEGER.format(up.getNumSlowPorts()), UIConstants.INTEGER.format(down.getNumSlowPorts())};
        labels = new String[]{STLConstants.K2072_SLOW_UP_PORTS.getValue(), STLConstants.K2073_SLOW_DOWN_PORTS.getValue()};
        colors = new Color[]{UIConstants.INTEL_DARK_BLUE, UIConstants.INTEL_DARK_GREEN};
        if (up.getNumSlowPorts() > 0) {
            colors[0] = UIConstants.INTEL_RED;
        }
        if (down.getNumSlowPorts() > 0) {
            colors[1] = UIConstants.INTEL_RED;
        }
        String[] tooltips = new String[2];
        tooltips[0] = tooltips[1] = UILabels.STL70002_SLOW_PORTS.getDescription();
        ActionListener[] actions = new ActionListener[]{this.createAction(up.getSlowPorts(), origin), this.createAction(down.getSlowPorts(), origin)};
        this.view.setSlowPortsDist(index, normalizedVals, values, colors, labels, tooltips, actions);
        normalizedVals = new double[]{(double)up.getNumDegPorts() / maxPortsSegment, (double)down.getNumDegPorts() / maxPortsSegment};
        values = new String[]{UIConstants.INTEGER.format(up.getNumDegPorts()), UIConstants.INTEGER.format(down.getNumDegPorts())};
        colors = new Color[]{UIConstants.INTEL_DARK_BLUE, UIConstants.INTEL_DARK_GREEN};
        if (up.getNumDegPorts() > 0) {
            colors[0] = UIConstants.INTEL_RED;
        }
        if (down.getNumDegPorts() > 0) {
            colors[1] = UIConstants.INTEL_RED;
        }
        labels = new String[]{STLConstants.K2074_DEG_UP_PORTS.getValue(), STLConstants.K2075_DEG_DOWN_PORTS.getValue()};
        tooltips = new String[2];
        tooltips[0] = tooltips[1] = UILabels.STL70003_DEG_PORTS.getDescription();
        actions = new ActionListener[]{this.createAction(up.getDegPorts(), origin), this.createAction(down.getDegPorts(), origin)};
        this.view.setDegPortsDist(index, normalizedVals, values, colors, labels, tooltips, actions);
    }

    protected ActionListener createAction(List<Point> ports, final JumpToEvent origin) {
        if (ports == null || ports.isEmpty()) {
            return null;
        }
        final PortsSelectedEvent event = new PortsSelectedEvent(this, TopologyPage.NAME);
        for (Point port : ports) {
            event.addPort(port.x, (short)port.y);
        }
        ActionListener res = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopSummaryGroupController.this.eventBus.publish((Object)event);
                if (TopSummaryGroupController.this.undoHandler != null && !TopSummaryGroupController.this.undoHandler.isInProgress()) {
                    UndoableJumpEvent undoSel = new UndoableJumpEvent((MBassador<IAppEvent>)TopSummaryGroupController.this.eventBus, origin, event);
                    TopSummaryGroupController.this.undoHandler.addUndoAction(undoSel);
                }
            }
        };
        return res;
    }

    protected int getMaxPortsSegment(List<SimplePropertyCategory> categories) {
        int max = 0;
        for (int i = 0; i < categories.size(); ++i) {
            TopologyTier tier = (TopologyTier)categories.get(i).getItems().iterator().next().getObject();
            TopologyTier.Quality up = tier.getUpQuality();
            TopologyTier.Quality down = tier.getDownQuality();
            int tmp = this.maxNumber(up.getTotalPorts(), down.getTotalPorts(), tier.getNumOtherPorts());
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    private int maxNumber(int ... vals) {
        int max = 0;
        for (int val : vals) {
            if (val <= max) continue;
            max = val;
        }
        return max;
    }
}

