/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.event.TaskStatusEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.network.TopologyTreeController;
import com.intel.stl.ui.network.view.TopologyView;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;

public class TopologyPage
implements IPageController {
    public static final String NAME = STLConstants.K1000_TOPOLOGY.getValue();
    private final TopologyView view;
    private final TopologyTreeController controller;
    private final MBassador<IAppEvent> eventBus;

    public TopologyPage(TopologyView view, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder) {
        this.view = view;
        this.controller = new TopologyTreeController(view, eventBus, treeBuilder);
        this.eventBus = eventBus;
        eventBus.subscribe((Object)this);
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.controller.setContext(context, observer);
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        this.controller.onRefresh(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler(priority=1)
    public synchronized void onNodeUpdate(NodeUpdateEvent evt) {
        TaskStatusEvent<NodeUpdateEvent> taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.STARTED);
        this.eventBus.publish(taskEvent);
        try {
            this.controller.onNodeUpdate(evt);
        }
        finally {
            taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.FINISHED);
            this.eventBus.publish(taskEvent);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return STLConstants.K1001_TOPOLOGY_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
        this.controller.cleanup();
    }

    @Override
    public void onEnter() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopologyPage.this.view.initView();
            }
        });
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.HIGH;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.HIGH;
    }

    public String toString() {
        return this.getName();
    }
}

