/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.event.PortUpdateEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoableSelection;
import com.intel.stl.ui.model.GraphCells;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.monitor.SearchController;
import com.intel.stl.ui.monitor.TreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.TreeSelection;
import com.intel.stl.ui.monitor.TreeSubpageSelection;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.UndoableTopTreeSelection;
import com.intel.stl.ui.network.view.TopologyView;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyTreeController
extends TreeController<TopologyView> {
    private static final Logger log = LoggerFactory.getLogger(TopologyTreeController.class);
    private static final boolean DEBUG = true;
    private FVResourceNode[] lastTreeSelection;
    private final TopologyGraphController graphSelectionController;
    private String previousSubpageName;
    private String currentSubpageName;

    public TopologyTreeController(TopologyView pTreeView, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder) {
        super(pTreeView, eventBus, treeBuilder);
        this.graphSelectionController = new TopologyGraphController(this, eventBus);
        new SearchController(((TopologyView)this.view).getSearchView(), eventBus, treeBuilder, this);
    }

    @Override
    public synchronized void setContext(Context pContext, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.graphSelectionController.setContext(pContext, subObservers[0]);
        subObservers[0].onFinish();
        if (observer.isCancelled()) {
            return;
        }
        super.setContext(pContext, subObservers[1]);
        subObservers[1].onFinish();
    }

    @Override
    public void onRefresh(final IProgressObserver observer) {
        this.isSystemUpdate = true;
        this.lastTreeSelection = null;
        final IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.graphSelectionController.onRefresh(subObservers[0], (ICallback<Void>)new CallbackAdapter<Void>(){

            @Override
            public void onDone(Void result) {
                if (!observer.isCancelled()) {
                    TopologyTreeController.this.refreshTreeOnBackground(subObservers[1]);
                }
            }
        });
    }

    protected void refreshTreeOnBackground(final IProgressObserver observer) {
        this.mContext.getTaskScheduler().submitToBackground(new Runnable(){

            @Override
            public void run() {
                TopologyTreeController.super.onRefresh(observer);
            }
        });
    }

    @Override
    public synchronized void onNodeUpdate(final NodeUpdateEvent evt) {
        if (evt instanceof PortUpdateEvent || this.mContext == null) {
            return;
        }
        this.isSystemUpdate = true;
        this.lastTreeSelection = null;
        this.graphSelectionController.onRefresh(null, (ICallback<Void>)new CallbackAdapter<Void>(){

            @Override
            public void onDone(Void result) {
                TopologyTreeController.this.updateTreeOnBackground(evt);
            }
        });
    }

    protected void updateTreeOnBackground(final NodeUpdateEvent evt) {
        this.mContext.getTaskScheduler().submitToBackground(new Runnable(){

            @Override
            public void run() {
                TopologyTreeController.super.onNodeUpdate(evt);
            }
        });
    }

    @Override
    protected void showNode(FVResourceNode node) {
        if (node != null) {
            this.showNodes(new FVResourceNode[]{node});
        }
    }

    @Override
    protected synchronized void showNodes(FVResourceNode[] nodes) {
        System.out.println("Current TreeNodes " + Arrays.toString(nodes));
        System.out.println("Last TreeNodes " + Arrays.toString(this.lastTreeSelection));
        if (nodes == null || nodes.length == 0 || this.areSameNodes(this.lastTreeSelection, nodes)) {
            return;
        }
        this.previousSubpageName = this.graphSelectionController.getCurrentSubpage();
        if (!this.undoHandler.isInProgress()) {
            this.currentSubpageName = null;
        }
        this.graphSelectionController.setCurrentSubpage(this.currentSubpageName);
        this.collapseTreeSelections(this.lastTreeSelection, nodes);
        this.lastTreeSelection = nodes;
        switch (nodes[0].getType()) {
            case SWITCH: 
            case HFI: {
                this.graphSelectionController.processTreeNodes(nodes);
                break;
            }
            case ACTIVE_PORT: 
            case INACTIVE_PORT: {
                this.graphSelectionController.processTreePorts(nodes);
                break;
            }
            case HCA_GROUP: 
            case SWITCH_GROUP: 
            case DEVICE_GROUP: 
            case VIRTUAL_FABRIC: {
                this.graphSelectionController.processTreeGroups(nodes);
                break;
            }
            default: {
                this.graphSelectionController.onSelectionChange(new GraphCells(), this.graphSelectionController, nodes);
            }
        }
    }

    protected boolean areSameNodes(FVResourceNode[] nodes1, FVResourceNode[] nodes2) {
        if (!Arrays.equals(nodes1, nodes2)) {
            return false;
        }
        for (int i = 0; i < nodes1.length; ++i) {
            if (!nodes1[i].hasSamePath(nodes2[i])) {
                return false;
            }
            if (nodes1[i].getRoot() == nodes2[i].getRoot()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected UndoableSelection<?> getUndoableSelection(TreeSelection oldSelection, TreeSelection newSelection) {
        TreeSubpageSelection oldTSSelection = new TreeSubpageSelection(oldSelection, this.previousSubpageName);
        TreeSubpageSelection newTSSelection = new TreeSubpageSelection(newSelection, this.currentSubpageName);
        return new UndoableTopTreeSelection(this, oldTSSelection, newTSSelection);
    }

    @Override
    protected FVResourceNode getCurrentNode() {
        if (this.lastTreeSelection == null || this.lastTreeSelection.length == 0) {
            return null;
        }
        return this.lastTreeSelection[this.lastTreeSelection.length - 1];
    }

    protected void collapseTreeSelections(FVResourceNode[] previous, FVResourceNode[] current) {
        if (previous == null || previous.length == 0) {
            return;
        }
        HashSet<TreePath> toCollapse = new HashSet<TreePath>();
        for (FVResourceNode node : previous) {
            TreePath path = null;
            switch (node.getType()) {
                case SWITCH: 
                case HFI: {
                    if (node.getParent() == null) break;
                    path = node.getParent().getPath();
                    break;
                }
                case ACTIVE_PORT: 
                case INACTIVE_PORT: {
                    if (node.getParent() == null) break;
                    path = node.getParent().getPath();
                    break;
                }
            }
            if (path == null) continue;
            toCollapse.add(path);
        }
        block9: for (FVResourceNode node : current) {
            switch (node.getType()) {
                case SWITCH: 
                case HFI: {
                    if (node.getParent() == null) continue block9;
                    toCollapse.remove(node.getParent().getPath());
                    continue block9;
                }
                case ACTIVE_PORT: 
                case INACTIVE_PORT: {
                    FVResourceNode parent = node.getParent();
                    if (parent == null) continue block9;
                    toCollapse.remove(parent.getPath());
                    parent = parent.getParent();
                    if (parent == null) continue block9;
                    toCollapse.remove(parent.getPath());
                    continue block9;
                }
            }
        }
        for (TreePath path : toCollapse) {
            ((TopologyView)this.view).collapseTreePath(this.getCurrentTreeModel(), path);
        }
    }

    protected void selectTreeSelections(FVResourceNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = nodes[i].getPath();
        }
        ((TopologyView)this.view).setTreeSelection(this.getCurrentTreeModel(), paths);
    }

    public void clearTreeSelection() {
        ((TopologyView)this.view).clearTreeSelection(this.getCurrentTreeModel());
    }

    protected FVResourceNode[] selectTreeNodes(List<GraphNode> nodes, ICancelIndicator indicator) {
        FVTreeModel model = this.getCurrentTreeModel();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        ArrayList<FVResourceNode> treeNodes = new ArrayList<FVResourceNode>();
        for (GraphNode node : nodes) {
            if (indicator.isCancelled()) {
                return null;
            }
            int lid = node.getLid();
            TreePath path = null;
            path = model.getTreePath(lid, node.isEndNode() ? TreeNodeType.HFI : TreeNodeType.SWITCH, this.getSearchHint());
            if (path == null) {
                log.warn("Couldn't find tree node for node Lid=" + lid);
                continue;
            }
            paths.add(path);
            treeNodes.add((FVResourceNode)path.getLastPathComponent());
        }
        if (!indicator.isCancelled() && !paths.isEmpty()) {
            this.lastTreeSelection = treeNodes.toArray(new FVResourceNode[0]);
            ((TopologyView)this.view).setTreeSelection(model, paths.toArray(new TreePath[0]));
        }
        return this.lastTreeSelection;
    }

    protected FVResourceNode getSearchHint() {
        if (this.lastTreeSelection == null || this.lastTreeSelection.length == 0) {
            return null;
        }
        FVResourceNode hint = this.lastTreeSelection[0];
        switch (hint.getType()) {
            case SWITCH: 
            case HFI: {
                hint = hint.getParent();
                break;
            }
            case ACTIVE_PORT: 
            case INACTIVE_PORT: {
                hint = hint.getParent().getParent();
                break;
            }
        }
        return hint;
    }

    protected FVResourceNode[] selectTreePorts(List<GraphEdge> edges, ICancelIndicator indicator) {
        FVTreeModel model = this.getCurrentTreeModel();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (GraphEdge edge : edges) {
            if (indicator.isCancelled()) {
                return null;
            }
            int lid = edge.getFromLid();
            Collection<Integer> ports = edge.getLinks().keySet();
            this.populatePaths(lid, ports, paths);
            lid = edge.getToLid();
            ports = edge.getLinks().values();
            this.populatePaths(lid, ports, paths);
        }
        if (indicator.isCancelled()) {
            return null;
        }
        int firstPath = -1;
        if (this.lastTreeSelection != null && paths.size() > 1) {
            block1: for (FVResourceNode node : this.lastTreeSelection) {
                for (int i = 0; i < paths.size(); ++i) {
                    if (((TreePath)paths.get(i)).getLastPathComponent() != node) continue;
                    firstPath = i;
                    continue block1;
                }
            }
        }
        if (firstPath >= 0) {
            TreePath path = (TreePath)paths.remove(firstPath);
            paths.add(0, path);
        }
        if (!paths.isEmpty()) {
            ArrayList<FVResourceNode> treeNodes = new ArrayList<FVResourceNode>();
            TreePath[] pathArray = new TreePath[paths.size()];
            for (int i = 0; i < paths.size(); ++i) {
                pathArray[i] = (TreePath)paths.get(i);
                treeNodes.add((FVResourceNode)pathArray[i].getLastPathComponent());
            }
            this.lastTreeSelection = treeNodes.toArray(new FVResourceNode[0]);
            ((TopologyView)this.view).setTreeSelection(model, pathArray);
        }
        return this.lastTreeSelection;
    }

    protected void populatePaths(int lid, Collection<Integer> ports, List<TreePath> paths) {
        FVTreeModel model = this.getCurrentTreeModel();
        TreePath path = model.getTreePath(lid, TreeNodeType.NODE, this.getSearchHint());
        if (path == null) {
            log.warn("Couldn't find tree node for node Lid=" + lid);
        } else {
            FVResourceNode node = (FVResourceNode)path.getLastPathComponent();
            if (node.getType() == TreeNodeType.HFI) {
                paths.add(path.pathByAddingChild(node.getChildAt(0)));
            } else {
                for (int port : ports) {
                    paths.add(path.pathByAddingChild(node.getChildAt(port)));
                }
            }
        }
    }

    @Override
    public String getName() {
        return JumpDestination.TOPOLOGY.getName();
    }

    public void cleanup() {
        this.graphSelectionController.cleanup();
    }

    public void showNode(FVTreeModel treeModel, TreePath[] paths, boolean[] expanded, String subpageName) {
        this.currentSubpageName = subpageName;
        this.showNode(treeModel, paths, expanded);
    }
}

