/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.network.TopGraph;
import com.mxgraph.model.mxCell;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyTreeModel {
    private static final Logger log = LoggerFactory.getLogger(TopologyTreeModel.class);
    private final List<List<Integer>> ranks;
    private final int maxWidth;
    private final int numTotalNodes;
    private final List<Integer> unclassifiedNodes;

    public TopologyTreeModel(List<List<Integer>> ranks, int maxRankSize, List<Integer> unclassifiedNodes, int numTotalNodes) {
        this.ranks = Collections.unmodifiableList(ranks);
        this.maxWidth = maxRankSize;
        this.unclassifiedNodes = unclassifiedNodes;
        this.numTotalNodes = numTotalNodes;
    }

    public List<List<Integer>> getRanks() {
        return this.ranks;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getNumRanks() {
        return this.ranks.size();
    }

    public int getNumTotalNodes() {
        return this.numTotalNodes;
    }

    public List<Integer> getUnclassifiedNodes() {
        return this.unclassifiedNodes;
    }

    public TopologyTreeModel filterBy(TopGraph graph) {
        Object[] allNodes = graph.getVertices();
        HashSet<Integer> allLids = new HashSet<Integer>();
        for (Object node : allNodes) {
            allLids.add(((GraphNode)((mxCell)node).getValue()).getLid());
        }
        ArrayList<List<Integer>> newRanks = new ArrayList<List<Integer>>();
        int newMaxWidth = 0;
        for (List<Integer> rank : this.ranks) {
            ArrayList<Integer> newRank = new ArrayList<Integer>();
            for (Integer nodeId : rank) {
                mxCell cell = graph.getVertex(nodeId);
                if (cell == null) continue;
                newRank.add(nodeId);
                allLids.remove(nodeId);
                Set<GraphNode> neighbors = ((GraphNode)cell.getValue()).getEndNeighbor();
                for (GraphNode nbr : neighbors) {
                    allLids.remove(nbr.getLid());
                }
            }
            newRanks.add(newRank);
            if (newRank.size() <= newMaxWidth) continue;
            newMaxWidth = newRank.size();
        }
        return new TopologyTreeModel(newRanks, newMaxWidth, new ArrayList<Integer>(allLids), allNodes.length);
    }

    public void dump(PrintStream out) {
        out.println(this.ranks.size() + " tiers");
        for (int i = 0; i < this.ranks.size(); ++i) {
            out.println(i + " " + this.ranks.get(i));
        }
        out.println(this.unclassifiedNodes.size() + " unclassifiedNodes " + this.unclassifiedNodes);
    }
}

