/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.network.CollapseChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayout
extends mxGraphLayout {
    private static final Logger log = LoggerFactory.getLogger(TreeLayout.class);
    public static final double DEFAULT_INTRA_SPACE = 30.0;
    public static final double DEFAULT_INTER_SPACE = 30.0;
    public static final double CIRCLE_ANGLE = 1.0471975511965976;
    private final TopGraph topGraph;
    private final TopologyTreeModel model;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double minWidth = 100.0;
    protected double minHeight = 100.0;
    protected boolean resetEdges = true;
    protected Style style;
    protected double r;
    protected mxRectangle prefRec;
    private int[] numOpenNodes;

    public TreeLayout(TopGraph graph, TopologyTreeModel model) {
        this(graph, model, Style.CIRCLE);
    }

    public TreeLayout(TopGraph graph, TopologyTreeModel model, Style style) {
        super((mxGraph)graph);
        this.model = model;
        this.style = style;
        this.setUseBoundingBox(false);
        this.topGraph = graph;
        graph.setVertexScaleThreshold(64.0 / (64.0 + this.intraCellSpacing));
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double intraCellSpacing) {
        this.intraCellSpacing = intraCellSpacing;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double interRankCellSpacing) {
        this.interRankCellSpacing = interRankCellSpacing;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(double minWidth) {
        this.minWidth = minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(double minHeight) {
        this.minHeight = minHeight;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean resetEdges) {
        this.resetEdges = resetEdges;
    }

    public void execute(Object parent) {
        this.execute(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object parent, ICancelIndicator cancelIndicator) {
        log.info("layout start @ " + (Object)((Object)this.topGraph) + " " + Thread.currentThread());
        super.execute(parent);
        mxIGraphModel gModel = this.graph.getModel();
        this.r = this.intraCellSpacing + 64.0;
        this.prefRec = this.calculateSize(cancelIndicator);
        if (this.prefRec == null || this.isCancelled(cancelIndicator)) {
            log.info("layout execute cancelled " + (Object)((Object)this.topGraph) + " " + Thread.currentThread());
            return;
        }
        gModel.beginUpdate();
        try {
            this.placeMiddleNodes(cancelIndicator);
            log.info("layout finished " + (Object)((Object)this.topGraph) + " " + Thread.currentThread());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            gModel.endUpdate();
        }
    }

    protected boolean isCancelled(ICancelIndicator cancelIndicator) {
        return cancelIndicator == null ? false : cancelIndicator.isCancelled();
    }

    protected mxRectangle getMaxSize(mxIGraphModel gModel) {
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int childCount = gModel.getChildCount(this.parent);
        for (int i = 0; i < childCount; ++i) {
            Object cell = gModel.getChildAt(this.parent, i);
            if (!this.isVertexIgnored(cell)) {
                mxRectangle bounds = this.getVertexBounds(cell);
                maxWidth = Math.max(maxWidth, bounds.getWidth());
                maxHeight = Math.max(maxHeight, bounds.getHeight());
                continue;
            }
            if (this.isEdgeIgnored(cell) || !this.isResetEdges()) continue;
            this.graph.resetEdge(cell);
        }
        return new mxRectangle(0.0, 0.0, maxWidth, maxHeight);
    }

    protected mxRectangle calculateSize(ICancelIndicator cancelIndicator) {
        if (this.model == null) {
            return null;
        }
        int numColumns = this.model.getMaxWidth();
        double width = (double)numColumns * (64.0 + this.intraCellSpacing) + this.intraCellSpacing * 2.0;
        double height = (double)this.model.getNumRanks() * (64.0 + this.interRankCellSpacing) + this.interRankCellSpacing * 2.0;
        List<List<Integer>> ranks = this.model.getRanks();
        this.numOpenNodes = new int[ranks.size()];
        if (this.style == Style.CIRCLE) {
            for (int i = 0; i < ranks.size(); ++i) {
                if (this.isCancelled(cancelIndicator)) {
                    log.info("calculateSize cancelled");
                    return null;
                }
                List<Integer> nodeLids = ranks.get(i);
                double w = (double)nodeLids.size() * (64.0 + this.intraCellSpacing) + this.intraCellSpacing * 2.0;
                this.numOpenNodes[i] = 0;
                for (Integer nodeLid : nodeLids) {
                    GraphNode node = (GraphNode)this.topGraph.getVertex(nodeLid).getValue();
                    if (node.isCollapsed()) continue;
                    int n = i;
                    this.numOpenNodes[n] = this.numOpenNodes[n] + 1;
                }
                width = Math.max(width, w += 2.0 * this.r * (double)this.numOpenNodes[i]);
            }
        }
        height = Math.max(height, width / 2.0);
        mxRectangle rec = new mxRectangle(64.0, 64.0, Math.max(width, this.minWidth), Math.max(height, this.minHeight));
        return rec;
    }

    protected void placeMiddleNodes(ICancelIndicator cancelIndicator) {
        List<List<Integer>> rwen = this.model.getRanks();
        HashSet<GraphNode> sharedEndNodes = new HashSet<GraphNode>();
        HashSet<mxCell> collapsedVertices = new HashSet<mxCell>();
        HashSet<mxCell> expandedVertices = new HashSet<mxCell>();
        double x0 = this.prefRec.getX();
        double y0 = this.prefRec.getY();
        double stepX = 0.0;
        double stepY = this.prefRec.getHeight() / (double)(rwen.size() - 1);
        double x = x0;
        double y = y0;
        double startAngle = 1.0471975511965979;
        double startCircleHeight = Math.sin(startAngle);
        double angleStep = 0.0;
        double circleR = 0.0;
        for (int i = 0; i < rwen.size(); ++i) {
            List<Integer> rank = rwen.get(i);
            stepX = (this.prefRec.getWidth() - (double)(this.numOpenNodes[i] * 2) * this.r) / (double)rank.size();
            x = x0 + stepX / 2.0;
            boolean circleLayout = this.hasInternalConnection(rank);
            if (circleLayout) {
                angleStep = 1.0471975511965976 / (double)(rank.size() - 1);
                circleR = stepX * (double)(rank.size() - 1) / (2.0 * Math.cos(startAngle));
            }
            LinkedHashMap<Object, List<GraphNode>> endNodes = new LinkedHashMap<Object, List<GraphNode>>();
            for (int j = 0; j < rank.size(); ++j) {
                if (this.isCancelled(cancelIndicator)) {
                    log.info("placeMiddleNodes cancelled");
                    return;
                }
                mxCell cell = this.topGraph.getVertex(rank.get(j));
                GraphNode node = null;
                if (cell == null) {
                    System.out.println("Couldn't find vertex lid=" + rank.get(j));
                    continue;
                }
                node = (GraphNode)cell.getValue();
                mxCell vertex = null;
                if (node == null) continue;
                if (this.style == Style.CIRCLE && !node.isCollapsed()) {
                    x += this.r;
                }
                if (this.isVertexMovable(vertex = this.topGraph.getVertex(node.getLid()))) {
                    if (circleLayout) {
                        double circleY = y - (Math.sin(startAngle + angleStep * (double)j) - startCircleHeight) * circleR;
                        this.setVertexLocation(vertex, x, (int)(circleY + 0.5));
                    } else {
                        this.setVertexLocation(vertex, x, y);
                    }
                }
                if (this.style == Style.CIRCLE && node != null && !node.isCollapsed()) {
                    x += this.r;
                }
                x += stepX;
                if (node != null && (!node.hasEndNodes() || node.isEndNode())) continue;
                mxGraphModel gModel = (mxGraphModel)this.graph.getModel();
                if (node != null && !node.isEndNode()) {
                    if (node.isCollapsed()) {
                        collapsedVertices.add(vertex);
                    } else {
                        expandedVertices.add(vertex);
                    }
                }
                boolean hasChange = false;
                ArrayList<GraphNode> toPlace = new ArrayList<GraphNode>();
                if (node != null) {
                    for (GraphNode endNode : node.getEndNeighbor()) {
                        mxCell enVertex = this.topGraph.getVertex(endNode.getLid());
                        if (endNode.getMiddleNeighbor().size() > 1) {
                            sharedEndNodes.add(endNode);
                            if (gModel.isVisible((Object)enVertex)) continue;
                            gModel.setVisible((Object)enVertex, true);
                            hasChange = true;
                            continue;
                        }
                        if (!node.isCollapsed()) {
                            toPlace.add(endNode);
                            if (gModel.isVisible((Object)enVertex)) continue;
                            gModel.setVisible((Object)enVertex, true);
                            hasChange = true;
                            continue;
                        }
                        if (!gModel.isVisible((Object)enVertex)) continue;
                        gModel.setVisible((Object)enVertex, false);
                        hasChange = true;
                    }
                }
                if (hasChange) {
                    CollapseChange collapseChange = new CollapseChange(gModel, node, node.isCollapsed());
                    gModel.execute((mxIGraphModel.mxAtomicGraphModelChange)collapseChange);
                    collapseChange.setPrevious(!node.isCollapsed());
                }
                if (toPlace.isEmpty()) continue;
                endNodes.put(vertex, toPlace);
            }
            double expand = this.placeEndNodes(endNodes);
            y += Math.max(stepY, expand + this.interRankCellSpacing);
        }
        for (GraphNode node : sharedEndNodes) {
            if (this.isCancelled(cancelIndicator)) {
                log.info("placeMiddleNodes cancelled");
                return;
            }
            this.placeSharedNode(node);
        }
        this.graph.setCellStyles(mxConstants.STYLE_IMAGE, UIImages.SWITCH_COLLAPSED_IMG.getFileName(), collapsedVertices.toArray());
        this.graph.setCellStyles(mxConstants.STYLE_IMAGE, UIImages.SWITCH_EXPANDED_IMG.getFileName(), expandedVertices.toArray());
    }

    protected boolean hasInternalConnection(List<Integer> rank) {
        for (Integer id : rank) {
            mxCell cell = this.topGraph.getVertex(id);
            GraphNode node = (GraphNode)cell.getValue();
            for (GraphNode peer : node.getMiddleNeighbor()) {
                if (!rank.contains(peer.getLid())) continue;
                return true;
            }
        }
        return false;
    }

    protected double placeEndNodes(Map<Object, List<GraphNode>> endNodes) {
        double expand = 0.0;
        for (Object vertex : endNodes.keySet()) {
            List<GraphNode> toPlace = endNodes.get(vertex);
            mxRectangle rec = this.getVertexBounds(vertex);
            double x0 = rec.getCenterX();
            double y0 = rec.getCenterY() + this.interRankCellSpacing * 2.0 + 32.0;
            if (this.style == Style.CIRCLE) {
                this.circleNodes(toPlace, x0, y0, this.r - this.intraCellSpacing);
                if (expand != 0.0) continue;
                expand = this.r;
                continue;
            }
            if (this.style == Style.SLASH) {
                double height = 0.0;
                if ((double)(toPlace.size() * 32) > this.r) {
                    height = toPlace.size() * 32;
                }
                this.slashNodes(toPlace, x0, y0, this.r - this.intraCellSpacing, height);
                expand = Math.max(expand, height);
                continue;
            }
            if (this.style != Style.LINE) continue;
            this.lineNodes(toPlace, x0, y0, expand += this.intraCellSpacing + 32.0);
        }
        return expand;
    }

    protected void circleNodes(List<GraphNode> nodes, double x0, double y0, double r) {
        int size = nodes.size();
        double step = Math.PI / (double)(size + 1);
        double alpha = Math.PI;
        double x = x0;
        double y = y0;
        double weight = 1.0;
        for (int i = 0; i < size; ++i) {
            mxCell v = this.topGraph.getVertex(nodes.get(i).getLid());
            alpha += step;
            double d = weight = i % 2 == 0 ? 0.8 : 1.2;
            if (!this.isVertexMovable(v)) continue;
            this.setVertexLocation(v, x + r * Math.cos(alpha) * weight, y - r * Math.sin(alpha) * weight);
        }
    }

    protected void slashNodes(List<GraphNode> nodes, double x0, double y0, double w, double h) {
        int size = nodes.size();
        double xStep = size < 1 ? w : w / (double)(size - 1);
        double yStep = size < 1 ? 0.0 : h / (double)(size - 1);
        double x = x0 - w / 2.0;
        double y = y0;
        for (int i = 0; i < size; ++i) {
            mxCell v = this.topGraph.getVertex(nodes.get(i).getLid());
            if (this.isVertexMovable(v)) {
                this.setVertexLocation(v, x, y);
            }
            x += xStep;
            y += yStep;
        }
    }

    protected void lineNodes(List<GraphNode> nodes, double x0, double y0, double h) {
        int size = nodes.size();
        double xStep = 32.0 + this.intraCellSpacing;
        double x = x0 - xStep * (double)(nodes.size() - 1) / 2.0;
        if (x < this.intraCellSpacing) {
            x = this.intraCellSpacing;
        }
        double y = y0 + h;
        for (int i = 0; i < size; ++i) {
            mxCell v = this.topGraph.getVertex(nodes.get(i).getLid());
            if (this.isVertexMovable(v)) {
                this.setVertexLocation(v, x, y);
            }
            x += xStep;
        }
    }

    protected void placeSharedNode(GraphNode node) {
        mxCell vertex = this.topGraph.getVertex(node.getLid());
        double x = 0.0;
        double y = 0.0;
        Set<GraphNode> neighbor = node.getMiddleNeighbor();
        for (GraphNode gn : neighbor) {
            mxCell v = this.topGraph.getVertex(gn.getLid());
            mxRectangle rec = this.getVertexBounds(v);
            x += rec.getX();
            y += rec.getY();
        }
        this.setVertexLocation(vertex, x / (double)neighbor.size(), y / (double)neighbor.size());
    }

    public mxRectangle setVertexLocation(Object vertex, double x, double y) {
        try {
            mxRectangle rec = this.getVertexBounds(vertex);
            return super.setVertexLocation(vertex, x - rec.getWidth() / 2.0, y - rec.getHeight() / 2.0);
        }
        catch (Exception e) {
            log.warn(((mxCell)vertex).getValue() + " " + e.getMessage());
            System.out.println(((mxCell)vertex).getValue());
            e.printStackTrace();
            return null;
        }
    }

    public static enum Style {
        CIRCLE,
        SLASH,
        LINE;

    }
}

