/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import com.mxgraph.model.mxCell;
import java.util.Collection;
import java.util.Collections;

public class ShowNodeTask
extends TopologyUpdateTask {
    private final GraphNode node;
    private TopologyTreeModel tmpTreeMode;
    private final LayoutType defaultLayout = LayoutType.TREE_LINE;

    public ShowNodeTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources, GraphNode node) {
        super(controller, source, selectedResources);
        this.node = node;
    }

    @Override
    public void preBackgroundTask(ICancelIndicator indicator, TopGraph oldGraph) {
    }

    @Override
    protected Collection<Integer> getInvolvedNodes(ICancelIndicator indicator, TopGraph oldGraph) {
        return Collections.singletonList(this.node.getLid());
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        this.tmpTreeMode = this.controller.getFullTopTreeModel().filterBy(newGraph);
        LayoutChange change = new LayoutChange(this.defaultLayout, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(final ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        FVResourceNode[] selectedNodes = this.selectedResources;
        if (!indicator.isCancelled() && this.source != this.controller) {
            selectedNodes = this.controller.selectTreeNodes(Collections.singletonList(this.node), indicator);
        }
        if (selectedNodes != null && selectedNodes.length > 0) {
            this.resourceController.showNode(selectedNodes[0], this.node);
        }
        final mxCell cell = newGraph.getVertex(this.node.getLid());
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                ShowNodeTask.this.graphView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowNodeTask.this.graphView.selectNodes(new mxCell[]{cell});
                    ShowNodeTask.this.graphView.selectConnections(Collections.singletonList(cell), true, indicator);
                }
                ShowNodeTask.this.graphView.updateGraph();
            }
        });
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                ShowNodeTask.this.guideView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowNodeTask.this.guideView.selectNodes(new mxCell[]{cell});
                    ShowNodeTask.this.guideView.selectConnections(Collections.singletonList(cell), true, indicator);
                }
                ShowNodeTask.this.guideView.updateGraph();
            }
        });
        this.guideView.setSelectedResources(selectedNodes);
        this.setLayout(this.defaultLayout);
    }
}

