/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.IModelChange;
import com.intel.stl.ui.network.ResourceController;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.task.ITopologyUpdateTask;
import com.intel.stl.ui.network.view.TopologyGraphView;
import com.intel.stl.ui.network.view.TopologyGuideView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopologyUpdateTask
implements ITopologyUpdateTask {
    private int id;
    protected TopologyGraphController controller;
    protected final TopologyGraphView graphView;
    protected final TopologyGuideView guideView;
    protected final ResourceController resourceController;
    protected boolean includeNeighbors = true;
    private final List<IModelChange> modelChanges = new ArrayList<IModelChange>();
    protected final Object source;
    protected final FVResourceNode[] selectedResources;
    private final IBackgroundService graphService;
    private final IBackgroundService outlineService;

    public TopologyUpdateTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources) {
        this.controller = controller;
        this.graphView = controller.getGraphView();
        this.guideView = controller.getGuideView();
        this.resourceController = controller.getResourceController();
        this.graphService = this.graphView.getUpdateService();
        this.outlineService = this.guideView.getUpdateService();
        this.source = source;
        this.selectedResources = selectedResources;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public boolean isIncludeNeighbors() {
        return this.includeNeighbors;
    }

    public void setIncludeNeighbors(boolean includeNeighbors) {
        this.includeNeighbors = includeNeighbors;
    }

    public void addModelChange(IModelChange change) {
        this.modelChanges.add(change);
    }

    @Override
    public void preBackgroundTask(ICancelIndicator indicator, TopGraph oldGraph) {
    }

    @Override
    public TopGraph createNewGraph(ICancelIndicator indicator, TopGraph oldGraph) {
        Collection<Integer> nodes = this.getInvolvedNodes(indicator, oldGraph);
        return oldGraph.filterBy(this.getId(), nodes, this.isIncludeNeighbors(), indicator);
    }

    protected Collection<Integer> getInvolvedNodes(ICancelIndicator indicator, TopGraph oldGraph) {
        return null;
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        boolean modelChanged = false;
        if (!this.modelChanges.isEmpty()) {
            for (IModelChange change : this.modelChanges) {
                if (change == null) continue;
                boolean ret = change.execute(newGraph, indicator);
                modelChanged = modelChanged || ret;
            }
        }
        return modelChanged;
    }

    @Override
    public void postBackgroundTask(ICancelIndicator indicator, TopGraph oldGraph) {
    }

    @Override
    public void onSuccess(ICancelIndicator indicator, final TopGraph graph) {
        if (this.graphView.getGraph() != graph) {
            this.submitGraphTask(new Runnable(){

                @Override
                public void run() {
                    TopologyUpdateTask.this.graphView.setGraph(graph);
                }
            });
        }
    }

    @Override
    public void onError(ICancelIndicator indicator, Throwable ... errors) {
        for (Throwable error : errors) {
            error.printStackTrace();
        }
    }

    @Override
    public void onFinally(ICancelIndicator indicator) {
    }

    protected void submitGraphTask(Runnable runnable) {
        this.graphService.submit(runnable);
    }

    protected void submitOutlineTask(Runnable runnable) {
        this.outlineService.submit(runnable);
    }

    protected void setLayout(LayoutType layout) {
        this.controller.setCurrentLayout(layout);
        this.graphView.setLayoutType(layout);
    }
}

