/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.common.view.JHorizontalBar;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.NodeTypeViz;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TopSummaryGroupPanel
extends JCardView<ICardListener> {
    private static final long serialVersionUID = -3101042683294419137L;
    private final PropertyVizStyle style;
    private JPanel mainPanel;
    private int tiers;
    private TierPanelWrapper[] tierPanels;

    public TopSummaryGroupPanel(PropertyVizStyle style) {
        super(STLConstants.K2064_TOP_SUMMARY.getValue());
        this.style = style;
        this.getMainComponent();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setOpaque(false);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        }
        return this.mainPanel;
    }

    public void init(int numTiers) {
        this.tiers = numTiers;
        this.mainPanel.removeAll();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        this.tierPanels = new TierPanelWrapper[this.tiers];
        for (int i = 0; i < this.tiers; ++i) {
            TierPanelWrapper tierPanel;
            this.tierPanels[i] = tierPanel = new TierPanelWrapper();
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = new Insets(1, 1, 1, 0);
            this.mainPanel.add((Component)tierPanel.nameLabel, gc);
            gc.insets = new Insets(1, 0, 1, 0);
            this.mainPanel.add((Component)tierPanel.totalPanel, gc);
            gc.weightx = 1.0;
            this.mainPanel.add((Component)tierPanel.portsPanel, gc);
            this.mainPanel.add((Component)tierPanel.slowPortsPanel, gc);
            gc.gridwidth = 0;
            gc.insets = new Insets(1, 0, 1, 5);
            this.mainPanel.add((Component)tierPanel.degPortsPanel, gc);
            if (this.style == null) continue;
            this.style.decorateKey(tierPanel.nameLabel, i);
            this.style.decorateValue(tierPanel.totalPanel, i);
            this.style.decorateValue(tierPanel.portsPanel, i);
            this.style.decorateValue(tierPanel.slowPortsPanel, i);
            this.style.decorateValue(tierPanel.degPortsPanel, i);
        }
    }

    public void setTierName(int index, String name) {
        this.tierPanels[index].nameLabel.setText(name);
    }

    public void setSummary(int index, String numSwitches, String numHFIs, String numPorts) {
        this.tierPanels[index].totalPanel.setContent(numSwitches, numHFIs, numPorts);
    }

    public void setPortsDist(int index, double[] normalizedVals, String[] values, Color[] colors, String[] labels, String[] tooltips) {
        this.tierPanels[index].portsPanel.setContent(normalizedVals, values, colors, labels, tooltips, null);
    }

    public void setSlowPortsDist(int index, double[] normalizedVals, String[] values, Color[] colors, String[] labels, String[] tooltips, ActionListener[] actions) {
        this.tierPanels[index].slowPortsPanel.setContent(normalizedVals, values, colors, labels, tooltips, actions);
    }

    public void setDegPortsDist(int index, double[] normalizedVals, String[] values, Color[] colors, String[] labels, String[] tooltips, ActionListener[] actions) {
        this.tierPanels[index].degPortsPanel.setContent(normalizedVals, values, colors, labels, tooltips, actions);
    }

    class PortsPanel
    extends JPanel {
        private static final long serialVersionUID = -4597232952448379838L;
        private final int size;
        private JHorizontalBar[] bars;
        private ActionListener[] actions;
        private JLabel[] nameLabels;

        public PortsPanel(int size) {
            this.size = size;
            this.initComponents();
        }

        protected void initComponents() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.bars = new JHorizontalBar[this.size];
            this.nameLabels = new JLabel[this.size];
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            for (int i = 0; i < this.size; ++i) {
                gc.gridwidth = 1;
                gc.weightx = 1.0;
                gc.insets = new Insets(2, 5, 2, 2);
                this.bars[i] = new JHorizontalBar();
                this.bars[i].setUpperMargin(0.8);
                this.bars[i].setLowerMargin(0.0);
                this.bars[i].setPreferredSize(new Dimension(60, 20));
                this.bars[i].setVerticalAlignment(1);
                this.bars[i].setFont(UIConstants.H5_FONT.deriveFont(1));
                final int index = i;
                this.bars[i].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (PortsPanel.this.actions != null && PortsPanel.this.actions[index] != null) {
                            PortsPanel.this.actions[index].actionPerformed(new ActionEvent(PortsPanel.this.bars[index], e.getID(), e.paramString()));
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (PortsPanel.this.actions != null && PortsPanel.this.actions[index] != null) {
                            PortsPanel.this.bars[index].setCursor(Cursor.getPredefinedCursor(12));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        PortsPanel.this.bars[index].setCursor(Cursor.getDefaultCursor());
                    }
                });
                this.add((Component)this.bars[i], gc);
                gc.gridwidth = 0;
                gc.weightx = 0.0;
                gc.insets = new Insets(2, 2, 2, 5);
                this.nameLabels[i] = ComponentFactory.getH4Label("", 0);
                this.add((Component)this.nameLabels[i], gc);
            }
        }

        public void setContent(double[] normalizedVals, String[] values, Color[] colors, String[] labels, String[] tooltips, ActionListener[] actions) {
            if (normalizedVals.length != this.size) {
                throw new IllegalArgumentException("Incorrect normalized values size. Expecte " + this.size + ", got " + normalizedVals.length);
            }
            this.checkSize("values", values, this.size);
            this.checkSize("colors", colors, this.size);
            this.checkSize("labels", labels, this.size);
            this.checkSize("tooltips", tooltips, this.size);
            this.checkSize("actions", actions, this.size);
            for (int i = 0; i < this.size; ++i) {
                this.bars[i].setText(values[i]);
                this.bars[i].setForeground(colors[i]);
                this.bars[i].setNormalizedValue(normalizedVals[i]);
                this.nameLabels[i].setText(labels[i]);
                if (tooltips != null) {
                    this.nameLabels[i].setToolTipText(tooltips[i]);
                    continue;
                }
                this.nameLabels[i].setToolTipText(null);
            }
            this.actions = actions;
            this.repaint();
        }

        protected void checkSize(String name, Object[] values, int size) {
            if (values != null && values.length != size) {
                throw new IllegalArgumentException("Incorrect " + name + " size. Expecte " + size + ", got " + values.length);
            }
        }
    }

    class TotalPanel
    extends JPanel {
        private static final long serialVersionUID = -499235218493665238L;
        private JLabel switchesLabel;
        private JLabel hfisLabel;
        private JLabel portsLabel;

        public TotalPanel() {
            this.initComponents();
        }

        protected void initComponents() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(2, 2, 2, 5);
            gc.weightx = 1.0;
            this.switchesLabel = ComponentFactory.getH4Label("", 0);
            this.switchesLabel.setHorizontalAlignment(4);
            this.add((Component)this.switchesLabel, gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            JLabel label = ComponentFactory.getH4Label(NodeTypeViz.SWITCH.getPluralName(), 0);
            this.add((Component)label, gc);
            gc.weightx = 1.0;
            gc.gridwidth = 1;
            this.hfisLabel = ComponentFactory.getH4Label("", 0);
            this.hfisLabel.setHorizontalAlignment(4);
            this.add((Component)this.hfisLabel, gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            label = ComponentFactory.getH4Label(STLConstants.K2076_CONNECTED_HFIS.getValue(), 0);
            this.add((Component)label, gc);
            gc.weightx = 1.0;
            gc.gridwidth = 1;
            this.portsLabel = ComponentFactory.getH4Label("", 0);
            this.portsLabel.setHorizontalAlignment(4);
            this.add((Component)this.portsLabel, gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            label = ComponentFactory.getH4Label(STLConstants.K1026_PORT_RESOURCE.getValue(), 0);
            this.add((Component)label, gc);
        }

        public void setContent(String numSwitches, String numHFIs, String numPorts) {
            this.switchesLabel.setText(numSwitches);
            this.hfisLabel.setText(numHFIs);
            this.portsLabel.setText(numPorts);
            this.repaint();
        }
    }

    class TierPanelWrapper {
        private final JLabel nameLabel = ComponentFactory.getH4Label("", 1);
        private final TotalPanel totalPanel;
        private final PortsPanel portsPanel;
        private final PortsPanel slowPortsPanel;
        private final PortsPanel degPortsPanel;

        public TierPanelWrapper() {
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
            this.totalPanel = new TotalPanel();
            this.portsPanel = new PortsPanel(3);
            this.slowPortsPanel = new PortsPanel(2);
            this.degPortsPanel = new PortsPanel(2);
        }
    }
}

