/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IChartCreator;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;

public class PortCounterChartsCreator
implements IChartCreator {
    private static final PortCounterChartsCreator instance = new PortCounterChartsCreator();

    private PortCounterChartsCreator() {
    }

    public static PortCounterChartsCreator instance() {
        return instance;
    }

    @Override
    public JFreeChart createChart(String name, Dataset dataset) {
        if (STLConstants.K0881_PC_PACKET.getValue().equals(name)) {
            return this.getPacketsChart(dataset);
        }
        if (STLConstants.K0880_PC_DATA.getValue().equals(name)) {
            return this.getDataChart(dataset);
        }
        return this.getErrorChart(dataset);
    }

    protected JFreeChart getPacketsChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K3311_PACKETS.getValue(), (IntervalXYDataset)dataset, false);
        NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    protected JFreeChart getDataChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0748_FLITS.getValue(), (IntervalXYDataset)dataset, false);
        NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    protected JFreeChart getErrorChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0882_COUNT.getValue(), (IntervalXYDataset)dataset, true);
        return chart;
    }
}

