/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PortSourceName;

public class PortCounterSourceName
extends PortSourceName {
    private String fieldName;

    public PortCounterSourceName(String vfName, String nodeDesc, int lid, short portNum) {
        this(vfName, nodeDesc, lid, portNum, null);
    }

    public PortCounterSourceName(int nodeLid, short portNumber) {
        this(null, null, nodeLid, portNumber, null);
    }

    public PortCounterSourceName(String vfName, String nodeDesc, int lid, short portNum, String fieldName) {
        super(vfName, nodeDesc, lid, portNum);
        this.fieldName = fieldName;
        if (fieldName != null) {
            this.sourceName = this.sourceName + ":" + fieldName;
        }
    }

    public PortCounterSourceName(int nodeLid, short portNumber, String field) {
        this(null, null, nodeLid, portNumber, field);
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ISource copy() {
        return new PortCounterSourceName(this.vfName, this.nodeDesc, this.lid, this.portNum, this.fieldName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortCounterSourceName other = (PortCounterSourceName)obj;
        String fieldName = this.getFieldName();
        String otherName = other.getFieldName();
        return !(fieldName == null ? otherName != null : !fieldName.equals(otherName));
    }

    @Override
    public String toString() {
        return "PortCounterSourceName [vfName=" + this.vfName + ", nodeDesc=" + this.nodeDesc + ", lid=" + this.lid + ", portNum=" + this.portNum + ", fieldName=" + this.fieldName + "]";
    }
}

