/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.monitor.ChartScaleGroupManager;
import com.intel.stl.ui.monitor.DataRateChartScaleGroupManager;
import com.intel.stl.ui.monitor.PacketRateChartScaleGroupManager;
import com.intel.stl.ui.monitor.view.TrafficChartsCreator;
import com.intel.stl.ui.performance.AbstractGroupController;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.PortChartArgument;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.PortCountersItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;
import org.jfree.data.time.TimePeriodValuesCollection;

public class PortGroupController
extends AbstractGroupController<PortSourceName> {
    private ChartsCard rxCard;
    private ChartsCard txCard;
    private final PacketRateChartScaleGroupManager packetScaleManager = PacketRateChartScaleGroupManager.getInstance();
    private final DataRateChartScaleGroupManager dataScaleManager;

    public PortGroupController(MBassador<IAppEvent> eventBus, String name, PortCountersItem rxPktItem, PortCountersItem rxDataItem, PortCountersItem txPktItem, PortCountersItem txDataItem, HistoryType[] historyTypes) {
        super(eventBus, name, new IPerformanceItem[]{rxPktItem, rxDataItem, txPktItem, txDataItem});
        if (this.rxCard != null) {
            this.packetScaleManager.addChart(((ChartsView)this.rxCard.getView()).getChart(rxPktItem.getName()), (TimePeriodValuesCollection)rxPktItem.getDataset());
        }
        if (this.txCard != null) {
            this.packetScaleManager.addChart(((ChartsView)this.txCard.getView()).getChart(txPktItem.getName()), (TimePeriodValuesCollection)txPktItem.getDataset());
        }
        rxPktItem.setScaleManager(this.packetScaleManager);
        txPktItem.setScaleManager(this.packetScaleManager);
        this.dataScaleManager = DataRateChartScaleGroupManager.getInstance();
        if (this.rxCard != null) {
            this.dataScaleManager.addChart(((ChartsView)this.rxCard.getView()).getChart(rxDataItem.getName()), (TimePeriodValuesCollection)rxDataItem.getDataset());
        }
        if (this.txCard != null) {
            this.dataScaleManager.addChart(((ChartsView)this.txCard.getView()).getChart(txDataItem.getName()), (TimePeriodValuesCollection)txDataItem.getDataset());
        }
        rxDataItem.setScaleManager(this.dataScaleManager);
        txDataItem.setScaleManager(this.dataScaleManager);
    }

    @Override
    protected List<ChartsCard> initCards(Map<String, DatasetDescription> map) {
        ArrayList<ChartsCard> res = new ArrayList<ChartsCard>();
        this.rxCard = this.createCard(new IPerformanceItem[]{this.allItems[0], this.allItems[1]}, map);
        res.add(this.rxCard);
        this.txCard = this.createCard(new IPerformanceItem[]{this.allItems[2], this.allItems[3]}, map);
        res.add(this.txCard);
        return res;
    }

    public void setHelpIDs(String rxHelpID, String txHelpID) {
        if (this.rxCard != null) {
            this.rxCard.setHelpID(rxHelpID);
        }
        if (this.txCard != null) {
            this.txCard.setHelpID(txHelpID);
        }
    }

    @Override
    protected ChartsView getItemView(IPerformanceItem<PortSourceName> item) {
        if (this.allItems[0] == item || this.allItems[1] == item) {
            return (ChartsView)this.rxCard.getView();
        }
        if (this.allItems[2] == item || this.allItems[3] == item) {
            return (ChartsView)this.txCard.getView();
        }
        return null;
    }

    public ChartsCard getRxCard() {
        return this.rxCard;
    }

    public ChartsCard getTxCard() {
        return this.txCard;
    }

    @Override
    protected void clearPin(ChartsCard pinCard, IPerformanceItem<PortSourceName> pinItem) {
        super.clearPin(pinCard, pinItem);
        ChartScaleGroupManager<TimePeriodValuesCollection> scaleMgr = ((PortCountersItem)pinItem).getScaleManager();
        scaleMgr.removeChart(((ChartsView)pinCard.getView()).getChart(pinItem.getName()));
    }

    @Override
    protected ChartsCard getPinCard(ChartArgument<PortSourceName> arg, IPerformanceItem<PortSourceName> source) {
        ChartScaleGroupManager scaleMgr;
        ChartsCard res = super.getPinCard(arg, source);
        PortCountersItem pinItem = (PortCountersItem)this.pinItems.get(arg);
        if (pinItem != null && (scaleMgr = pinItem.getScaleManager()) == null) {
            if (source.getName().equals(this.allItems[0].getName()) || source.getName().equals(this.allItems[2].getName())) {
                scaleMgr = this.packetScaleManager;
            } else if (source.getName().equals(this.allItems[1].getName()) || source.getName().equals(this.allItems[3].getName())) {
                scaleMgr = this.dataScaleManager;
            }
            if (scaleMgr != null) {
                scaleMgr.addChart(((ChartsView)res.getView()).getChart(arg.getName()), (TimePeriodValuesCollection)pinItem.getDataset());
                pinItem.setScaleManager(scaleMgr);
                scaleMgr.updateChartsRange();
            }
        }
        return res;
    }

    @Override
    protected IChartCreator getChartCreator() {
        return TrafficChartsCreator.instance();
    }

    @Override
    protected ChartArgument<PortSourceName> getChartArgument(IPerformanceItem<PortSourceName> item) {
        Object[] sourceNames;
        PortChartArgument<PortSourceName> arg = new PortChartArgument<PortSourceName>();
        String name = item.getName();
        arg.setName(name);
        arg.setFullName(item.getFullName());
        arg.setProvider(item.getCurrentProviderName().name());
        if (item.getType() != null) {
            arg.setDataType(item.getType());
        }
        if (item.getHistoryType() != null) {
            arg.setHistoryType(item.getHistoryType());
        }
        if ((sourceNames = (PortSourceName[])item.getSources()) == null || sourceNames.length != 1) {
            throw new RuntimeException("Strange performance item with sources: " + Arrays.toString(sourceNames));
        }
        arg.setSources((PortSourceName[])item.getSources());
        return arg;
    }
}

