/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.performance.ISource;

public class PortSourceName
implements ISource {
    public static final String DELIMITER = ":";
    protected String vfName;
    protected String nodeDesc;
    protected int lid;
    protected short portNum;
    protected String sourceName;

    public PortSourceName(String sourceName) {
        this.sourceName = sourceName;
        this.fillSource(sourceName);
    }

    public PortSourceName(int lid, short portNum) {
        this(null, null, lid, portNum);
    }

    public PortSourceName(String nodeDesc, int lid, short portNum) {
        this(null, nodeDesc, lid, portNum);
    }

    public PortSourceName(String vfName, String nodeDesc, int lid, short portNum) {
        this.vfName = vfName;
        this.nodeDesc = nodeDesc;
        this.lid = lid;
        this.portNum = portNum;
        this.sourceName = PortSourceName.getSourceName(vfName, nodeDesc, lid, portNum);
    }

    protected void fillSource(String name) {
        String[] segs = name.split(DELIMITER);
        if (segs.length == 3) {
            this.nodeDesc = segs[0];
            this.lid = Integer.parseInt(segs[1]);
            this.portNum = Short.parseShort(segs[2]);
        } else if (segs.length == 4) {
            this.vfName = segs[0];
            this.nodeDesc = segs[1];
            this.lid = Integer.parseInt(segs[2]);
            this.portNum = Short.parseShort(segs[3]);
        } else {
            throw new IllegalArgumentException("Invalid port source name format '" + name + "'");
        }
    }

    public String getVfName() {
        return this.vfName;
    }

    public String getNodeDesc() {
        return this.nodeDesc;
    }

    public int getLid() {
        return this.lid;
    }

    public short getPortNum() {
        return this.portNum;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public String getPrettyName() {
        return this.nodeDesc + DELIMITER + this.portNum;
    }

    @Override
    public ISource copy() {
        return new PortSourceName(this.vfName, this.nodeDesc, this.lid, this.portNum);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lid;
        result = 31 * result + this.portNum;
        result = 31 * result + (this.vfName == null ? 0 : this.vfName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortSourceName other = (PortSourceName)obj;
        if (this.lid != other.lid) {
            return false;
        }
        if (this.portNum != other.portNum) {
            return false;
        }
        return !(this.vfName == null ? other.vfName != null : !this.vfName.equals(other.vfName));
    }

    public String toString() {
        return "PortSourceName [vfName=" + this.vfName + ", nodeDesc=" + this.nodeDesc + ", lid=" + this.lid + ", portNum=" + this.portNum + "]";
    }

    public static String getSourceName(String vfName, String nodeDesc, int lid, short portNum) {
        StringBuffer sb = new StringBuffer();
        if (vfName != null) {
            sb.append(vfName + DELIMITER);
        }
        if (nodeDesc != null) {
            sb.append(nodeDesc + DELIMITER);
        }
        sb.append(lid + DELIMITER + portNum);
        return sb.toString();
    }

    public static String getSourceName(String nodeDesc, int lid, short portNum) {
        return PortSourceName.getSourceName(null, nodeDesc, lid, portNum);
    }

    public static String getSourceName(int lid, short portNum) {
        return PortSourceName.getSourceName(null, null, lid, portNum);
    }
}

