/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.IDataProvider;
import com.intel.stl.ui.performance.provider.ISourceObserver;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jfree.data.general.Dataset;

public abstract class AbstractPerformanceItem<S extends ISource>
implements IPerformanceItem<S>,
ISourceObserver<S> {
    public static final int DEFAULT_DATA_POINTS = 100;
    private static final boolean DEBUG = false;
    protected volatile int maxDataPoints;
    protected final String name;
    protected String shortName;
    protected String description;
    protected S[] sourceNames;
    protected DatasetDescription datasetDescription;
    private final Map<DataProviderName, IDataProvider<?, S>> providers = new HashMap();
    protected final Map<DataProviderName, IDataObserver<?>> observers = new HashMap();
    protected DataProviderName currentProviderName;
    private Context currentContext;
    private boolean isActive;
    private DataType type;
    private HistoryType historyType;

    public AbstractPerformanceItem(String name, String shortName, String fullName) {
        this(name, shortName, fullName, 100);
    }

    public AbstractPerformanceItem(String name, String shortName, String fullName, int maxDataPoints) {
        this.name = name;
        this.shortName = shortName;
        this.description = fullName;
        this.maxDataPoints = maxDataPoints;
    }

    public AbstractPerformanceItem(AbstractPerformanceItem<S> item) {
        this(item.name, item.shortName, item.description, item.maxDataPoints);
        this.copyPreparation(item);
        this.copyDataProvider(item);
        this.copyDataObserver(item);
        this.copyDataset(item);
        this.copyState(item);
    }

    protected void copyPreparation(AbstractPerformanceItem<S> item) {
        this.initDataProvider();
    }

    protected void copyDataProvider(AbstractPerformanceItem<S> item) {
        IDataProvider<?, S> curProvider = item.getCurrentProvider();
        if (curProvider != null) {
            HistoryType type = curProvider.getHistoryType();
            for (IDataProvider<?, S> provider : this.providers.values()) {
                provider.setHistoryType(type, false);
            }
        }
    }

    protected void copyDataObserver(AbstractPerformanceItem<S> item) {
        IDataObserver<?> curObserver = item.getCurrentObserver();
        if (curObserver != null) {
            DataType type = curObserver.getType();
            for (IDataObserver<?> observer : this.observers.values()) {
                observer.setType(type);
            }
        }
    }

    protected abstract void copyDataset(AbstractPerformanceItem<S> var1);

    protected void copyState(AbstractPerformanceItem<S> item) {
        this.currentProviderName = item.currentProviderName;
        if (item.sourceNames != null && item.sourceNames.length > 0) {
            this.sourceNames = (ISource[])Array.newInstance(item.sourceNames[0].getClass(), item.sourceNames.length);
            for (int i = 0; i < this.sourceNames.length; ++i) {
                this.sourceNames[i] = item.sourceNames[i].copy();
            }
        }
        this.isActive = item.isActive;
        this.currentContext = item.currentContext;
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null) {
            provider.removeSourceObserver(this);
            if (provider != null && this.isActive) {
                provider.setContext(this.currentContext, null, (ISource[])this.sourceNames);
            }
            provider.addSourceObserver(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getFullName() {
        return this.description;
    }

    public int getMaxDataPoints() {
        return this.maxDataPoints;
    }

    @Override
    public DatasetDescription getDatasetDescription() {
        if (this.datasetDescription == null && this.getDataset() != null) {
            this.datasetDescription = new DatasetDescription(this.name, this.description, this.getDataset(), this.isJumpable());
        }
        return this.datasetDescription;
    }

    protected abstract void initDataProvider();

    protected abstract Dataset getDataset();

    protected abstract boolean isJumpable();

    @Override
    public <E> void registerDataProvider(DataProviderName name, IDataProvider<E, S> provider, IDataObserver<E> observer) {
        this.providers.put(name, provider);
        this.observers.put(name, observer);
        provider.addObserver(observer);
        provider.addSourceObserver(this);
        if (this.currentProviderName == null) {
            this.currentProviderName = name;
        }
    }

    @Override
    public void setDataProvider(DataProviderName name) {
        if (this.currentProviderName != null && this.currentProviderName.equals((Object)name)) {
            return;
        }
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null) {
            provider.clear();
        }
        this.currentProviderName = name;
        if (this.sourceNames != null) {
            this.clear();
        }
        this.sourceNames = null;
    }

    @Override
    public DataProviderName getCurrentProviderName() {
        return this.currentProviderName;
    }

    protected IDataProvider<?, S> getCurrentProvider() {
        if (this.currentProviderName == null) {
            return null;
        }
        return this.providers.get((Object)this.currentProviderName);
    }

    protected IDataObserver<?> getCurrentObserver() {
        if (this.currentProviderName == null) {
            return null;
        }
        return this.observers.get((Object)this.currentProviderName);
    }

    @Override
    public void setSources(S[] sourceNames) {
        if (this.sameSources((ISource[])sourceNames)) {
            this.onRefresh(null);
            return;
        }
        this.clear();
        this.sourceNames = sourceNames;
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null && this.isActive) {
            provider.setContext(this.currentContext, null, (ISource[])sourceNames);
        }
    }

    protected boolean sameSources(S[] sources) {
        if (this.sourceNames == null) {
            return sources == null;
        }
        if (sources == null) {
            return true;
        }
        HashSet<S> set1 = new HashSet<S>(Arrays.asList(this.sourceNames));
        HashSet<S> set2 = new HashSet<S>(Arrays.asList(sources));
        return set1.equals(set2);
    }

    @Override
    public S[] getSources() {
        return this.sourceNames;
    }

    protected S getPrimarySource() {
        if (this.sourceNames == null || this.sourceNames.length == 0) {
            return null;
        }
        return this.sourceNames[0];
    }

    @Override
    public void sourcesToRemove(S[] names) {
    }

    @Override
    public void sourcesToAdd(S[] names) {
    }

    @Override
    public void sourcesRemoved(S[] names) {
    }

    @Override
    public void sourcesAdded(S[] names) {
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.clear();
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null && this.isActive) {
            provider.setContext(context, observer, (ISource[])this.sourceNames);
        }
        if (observer != null) {
            observer.onFinish();
        }
        if (this.currentContext != context) {
            this.currentContext = context;
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null && this.isActive) {
            provider.onRefresh(observer);
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    @Override
    public void setType(DataType type) {
        if (this.type == type) {
            return;
        }
        if (this.type != null) {
            this.clear();
        }
        this.type = type;
        for (IDataObserver<?> observer : this.observers.values()) {
            observer.setType(type);
        }
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public void setHistoryType(HistoryType type, boolean forcedUpdate) {
        if (this.historyType == type && !forcedUpdate) {
            return;
        }
        if (this.historyType != null) {
            this.clear();
        }
        this.historyType = type;
        if (this.currentContext != null && type != HistoryType.CURRENT) {
            int refreshRate = this.currentContext.getTaskScheduler().getRefreshRate();
            this.maxDataPoints = type.getMaxDataPoints(refreshRate);
        } else {
            this.maxDataPoints = 100;
        }
        for (IDataProvider<?, S> provider : this.providers.values()) {
            provider.setHistoryType(type, forcedUpdate);
        }
    }

    @Override
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    @Override
    public void setActive(boolean b) {
        if (this.isActive == b) {
            return;
        }
        this.isActive = b;
        IDataProvider<?, S> provider = this.getCurrentProvider();
        if (provider != null) {
            if (b && this.currentContext != null) {
                provider.setContext(this.currentContext, null, (ISource[])this.sourceNames);
            } else {
                provider.clear();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }
}

