/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.api.performance.ErrStatBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.ErrorDataObserver;
import com.intel.stl.ui.performance.observer.VFErrorDataObserver;
import com.intel.stl.ui.performance.provider.CombinedGroupInfoProvider;
import com.intel.stl.ui.performance.provider.CombinedVFInfoProvider;
import com.intel.stl.ui.performance.provider.DataProviderName;

public class BBTrendItem
extends TrendItem<GroupSource> {
    public BBTrendItem() {
        this(100);
    }

    public BBTrendItem(int maxDataPoints) {
        super(STLConstants.K0861_SHORT_BUBBLE_TREND.getValue(), STLConstants.K0876_BUBBLE_TREND.getValue(), maxDataPoints);
    }

    public BBTrendItem(BBTrendItem item) {
        super(item);
    }

    @Override
    protected void initDataProvider() {
        CombinedGroupInfoProvider provider = new CombinedGroupInfoProvider();
        ErrorDataObserver observer = new ErrorDataObserver(this){

            @Override
            protected long getValue(ErrStatBean error) {
                return error.getErrorMaximums().getBubbleErrors();
            }
        };
        this.registerDataProvider(DataProviderName.PORT_GROUP, provider, observer);
        CombinedVFInfoProvider vfProvider = new CombinedVFInfoProvider();
        VFErrorDataObserver vfObserver = new VFErrorDataObserver(this){

            @Override
            protected long getValue(ErrStatBean error) {
                return error.getErrorMaximums().getBubbleErrors();
            }
        };
        this.registerDataProvider(DataProviderName.VIRTUAL_FABRIC, vfProvider, vfObserver);
    }

    @Override
    public IPerformanceItem<GroupSource> copy() {
        return new BBTrendItem(this);
    }
}

