/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import com.intel.stl.ui.performance.observer.PCErrObserver;
import com.intel.stl.ui.performance.observer.VFPCErrObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.PortCounterFieldProvider;
import com.intel.stl.ui.performance.provider.VFPortCounterFieldProvider;

public class PCErrItem
extends PortCounterFieldItem {
    public PCErrItem() {
        this(100);
    }

    public PCErrItem(int maxDataPoints) {
        super(STLConstants.K0879_PC_ERR.getValue(), STLConstants.K0879_PC_ERR.getValue(), STLConstants.K0879_PC_ERR.getValue(), maxDataPoints);
    }

    public PCErrItem(PCErrItem item) {
        super(item);
    }

    @Override
    protected void copyPreparation(AbstractPerformanceItem<PortCounterSourceName> item) {
        PortCounterFieldProvider provider = new PortCounterFieldProvider();
        PCErrObserver errObserver = new PCErrObserver(this);
        this.registerDataProvider(DataProviderName.PORT, provider, errObserver);
        VFPortCounterFieldProvider vfProvider = new VFPortCounterFieldProvider();
        VFPCErrObserver errVfObserver = new VFPCErrObserver(this);
        this.registerDataProvider(DataProviderName.VF_PORT, vfProvider, errVfObserver);
    }

    @Override
    protected void copyDataObserver(AbstractPerformanceItem<PortCounterSourceName> item) {
        IDataObserver<?> curObserver;
        String field = null;
        if (item.getSources() != null) {
            field = ((PortCounterSourceName[])item.getSources())[0].getFieldName();
        }
        if ((curObserver = item.getCurrentObserver()) != null) {
            DataType type = curObserver.getType();
            for (IDataObserver observer : this.observers.values()) {
                observer.setType(type);
                if (field == null) continue;
                if (observer instanceof PCErrObserver) {
                    ((PCErrObserver)observer).setFieldName(field);
                    continue;
                }
                ((VFPCErrObserver)observer).setFieldName(field);
            }
        }
    }

    @Override
    public IPerformanceItem<PortCounterSourceName> copy() {
        return new PCErrItem(this);
    }

    public synchronized void setFieldName(String name) {
        for (PortCounterSourceName sn : (PortCounterSourceName[])this.sourceNames) {
            sn.setFieldName(name);
        }
        for (IDataObserver observer : this.observers.values()) {
            if (!(observer instanceof IFieldObserver)) continue;
            ((IFieldObserver)((Object)observer)).setFieldName(name);
        }
        HistoryType currentType = this.getHistoryType();
        if (currentType != null && currentType != HistoryType.CURRENT) {
            this.setHistoryType(currentType, true);
        }
    }

    public void setSources(PortCounterSourceName[] sourceNames) {
        super.setSources((ISource[])sourceNames);
        if (this.sameSources(sourceNames)) {
            this.onRefresh(null);
            return;
        }
        this.setFieldName(sourceNames[0].getFieldName());
    }
}

