/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.api.performance.FocusPortsRspBean;
import com.intel.stl.api.performance.VFFocusPortsRspBean;
import com.intel.stl.api.subnet.Selection;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.FocusFlagViz;
import com.intel.stl.ui.model.PortEntry;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.observer.TopNDataObserver;
import com.intel.stl.ui.performance.observer.VFTopNDataObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.FocusPortProvider;
import com.intel.stl.ui.performance.provider.VFFocusPortProvider;
import java.util.List;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public abstract class TopNItem
extends AbstractPerformanceItem<GroupSource> {
    protected DefaultCategoryDataset dataset;
    private Selection selection;
    private int range;
    private final Object copyCritical = new Object();

    public TopNItem(String shortName, String fullName, Selection selection, int range) {
        this(shortName, fullName, 100, selection, range);
    }

    public TopNItem(String shortName, String fullName, int maxDataPoints, Selection selection, int range) {
        super(UILabels.STL10210_TOPN.getDescription(range), shortName, fullName, maxDataPoints);
        this.selection = selection;
        this.range = range;
        this.initDataProvider();
        this.initDataset();
    }

    public TopNItem(TopNItem item) {
        super(item);
    }

    @Override
    protected void copyPreparation(AbstractPerformanceItem<GroupSource> item) {
        TopNItem topNItem = (TopNItem)item;
        this.selection = topNItem.selection;
        this.range = topNItem.range;
        super.copyPreparation(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDataset(AbstractPerformanceItem<GroupSource> item) {
        try {
            TopNItem ti = (TopNItem)item;
            Object object = ti.copyCritical;
            synchronized (object) {
                this.dataset = (DefaultCategoryDataset)ti.dataset.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public Selection getSelection() {
        return this.selection;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    protected void initDataProvider() {
        FocusPortProvider provider = new FocusPortProvider(this.getSelection(), this.getRange());
        TopNDataObserver observer = new TopNDataObserver(this);
        this.registerDataProvider(DataProviderName.PORT_GROUP, provider, observer);
        VFFocusPortProvider vfProvider = new VFFocusPortProvider(this.getSelection(), this.getRange());
        VFTopNDataObserver vfObserver = new VFTopNDataObserver(this);
        this.registerDataProvider(DataProviderName.VIRTUAL_FABRIC, vfProvider, vfObserver);
    }

    protected void initDataset() {
        this.dataset = this.createTopNDataset();
    }

    protected DefaultCategoryDataset createTopNDataset() {
        return new DefaultCategoryDataset();
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    protected boolean isJumpable() {
        return true;
    }

    public void updateTopN(final List<FocusPortsRspBean> portList) {
        if (this.dataset == null || portList == null || portList.isEmpty()) {
            return;
        }
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TopNItem.this.copyCritical;
                synchronized (object) {
                    TopNItem.this.dataset.setNotify(false);
                    TopNItem.this.dataset.clear();
                    for (FocusPortsRspBean port : portList) {
                        PortEntry pe = new PortEntry(port.getNodeDesc(), port.getNodeLid(), port.getPortNumber());
                        pe.setObject((Object)FocusFlagViz.getFocusFlagViz(port.getLocalFlags()));
                        TopNItem.this.dataset.addValue(TopNItem.this.getValue(port), (Comparable)((Object)STLConstants.K0113_PORT_VALUE.getValue()), (Comparable)pe);
                        TopNItem.this.dataset.addValue(TopNItem.this.getNeighborValue(port), (Comparable)((Object)STLConstants.K0114_NBR_VALUE.getValue()), (Comparable)pe);
                    }
                    TopNItem.this.dataset.setNotify(true);
                }
            }
        });
    }

    protected Number getValue(FocusPortsRspBean port) {
        return port.getValue();
    }

    protected Number getNeighborValue(FocusPortsRspBean port) {
        return port.getValue();
    }

    public void updateVFTopN(final List<VFFocusPortsRspBean> portList) {
        if (this.dataset == null || portList == null || portList.isEmpty()) {
            return;
        }
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TopNItem.this.copyCritical;
                synchronized (object) {
                    TopNItem.this.dataset.setNotify(false);
                    TopNItem.this.dataset.clear();
                    for (VFFocusPortsRspBean port : portList) {
                        PortEntry pe = new PortEntry(port.getNodeDesc(), port.getNodeLid(), port.getPortNumber());
                        pe.setObject((Object)FocusFlagViz.getFocusFlagViz(port.getLocalFlags()));
                        TopNItem.this.dataset.addValue((double)port.getValue(), (Comparable)((Object)STLConstants.K0113_PORT_VALUE.getValue()), (Comparable)pe);
                        TopNItem.this.dataset.addValue((double)port.getNeighborValue(), (Comparable)((Object)STLConstants.K0114_NBR_VALUE.getValue()), (Comparable)pe);
                    }
                    TopNItem.this.dataset.setNotify(true);
                }
            }
        });
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TopNItem.this.copyCritical;
                synchronized (object) {
                    if (TopNItem.this.dataset != null) {
                        TopNItem.this.dataset.clear();
                    }
                }
            }
        });
    }
}

