/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.ui.monitor.DeltaConverter;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.item.PortCountersItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.Date;

public abstract class CounterRateObserver
extends AbstractDataObserver<PortCountersBean, PortCountersItem> {
    private final DeltaConverter converter;

    public CounterRateObserver(PortCountersItem controller) {
        super(controller);
        this.converter = new DeltaConverter(controller.getName());
    }

    @Override
    public void processData(PortCountersBean bean) {
        if (bean == null) {
            return;
        }
        PortSourceName sourceName = new PortSourceName(bean.getNodeLid(), bean.getPortNumber());
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        DeltaConverter.Delta delta = this.converter.addValue(this.getValue(bean), time);
        if (delta != null) {
            ((PortCountersItem)this.controller).updateTrend(delta.getRate(), delta.getTime(), interval, sourceName);
        }
    }

    protected abstract long getValue(PortCountersBean var1);

    @Override
    public void reset() {
        this.converter.clear();
    }
}

