/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.ErrBucketBean;
import com.intel.stl.api.performance.ErrStatBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.item.ErrHistogramItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;

public abstract class ErrorHistogramDataObserver
extends AbstractDataObserver<GroupInfoBean[], ErrHistogramItem> {
    public ErrorHistogramDataObserver(ErrHistogramItem controller) {
        this(controller, DataType.ALL);
    }

    public ErrorHistogramDataObserver(ErrHistogramItem controller, DataType type) {
        super(controller, type);
    }

    @Override
    public void processData(GroupInfoBean[] data) {
        if (data != null && data.length > 0) {
            this.processData(data[0]);
        }
    }

    @Override
    public void processData(GroupInfoBean data) {
        if (data == null) {
            return;
        }
        ErrStatBean[] errors = this.getErrStatBeans(data, this.type);
        int[] counts = null;
        for (ErrStatBean error : errors) {
            ErrBucketBean[] buckets = error.getPorts();
            if (counts == null) {
                counts = new int[buckets.length];
            }
            for (int i = 0; i < buckets.length; ++i) {
                int n = i;
                counts[n] = (int)((long)counts[n] + this.getValue(buckets[i]));
            }
        }
        ((ErrHistogramItem)this.controller).updateHistogram(counts);
    }

    protected abstract long getValue(ErrBucketBean var1);
}

