/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.IPortCountersProcessor;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PCPacketObserver
extends AbstractDataObserver<PortCountersBean, PortCounterFieldItem>
implements IFieldObserver {
    private final Map<String, IPortCountersProcessor> processorMap = new HashMap<String, IPortCountersProcessor>();
    private String field;

    public PCPacketObserver(PortCounterFieldItem controller) {
        super(controller);
        this.initProcessorMap();
    }

    private void initProcessorMap() {
        this.processorMap.put(STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvPkts();
            }
        });
        this.processorMap.put(STLConstants.K0834_RX_MULTICAST_PACKETS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortMulticastRcvPkts();
            }
        });
        this.processorMap.put(STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitPkts();
            }
        });
        this.processorMap.put(STLConstants.K0833_TX_MULTICAST_PACKETS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortMulticastXmitPkts();
            }
        });
    }

    @Override
    public synchronized void processData(PortCountersBean bean) {
        IPortCountersProcessor processor;
        if (bean == null) {
            return;
        }
        PortCounterSourceName sourceName = new PortCounterSourceName(bean.getNodeLid(), bean.getPortNumber(), this.field);
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        if (this.field != null && (processor = this.processorMap.get(this.field)) != null) {
            ((PortCounterFieldItem)this.controller).updateTrend((double)processor.getValue(bean), time, interval, sourceName);
        }
    }

    @Override
    public synchronized void setFieldName(String name) {
        this.field = name;
    }
}

