/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.item.HistogramItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.List;

public class VFBWHistogramDataObserver
extends AbstractDataObserver<VFInfoBean[], HistogramItem> {
    public VFBWHistogramDataObserver(HistogramItem controller) {
        this(controller, DataType.ALL);
    }

    public VFBWHistogramDataObserver(HistogramItem controller, DataType type) {
        super(controller, type);
    }

    @Override
    public void processData(VFInfoBean[] data) {
        if (data != null && data.length > 0) {
            this.processData(data[0]);
        }
    }

    @Override
    public void processData(VFInfoBean data) {
        if (data == null) {
            return;
        }
        UtilStatsBean[] utils = this.getUtilStatsBeans(data, this.type);
        int[] counts = null;
        for (UtilStatsBean util : utils) {
            List<Integer> buckets = util.getBwBuckets();
            if (counts == null) {
                counts = new int[buckets.size()];
            }
            for (int i = 0; i < buckets.size(); ++i) {
                int n = i;
                counts[n] = counts[n] + buckets.get(i);
            }
        }
        ((HistogramItem)this.controller).updateHistogram(counts, 1.0);
    }
}

