/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.IVFPortCountersProcessor;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class VFPCErrObserver
extends AbstractDataObserver<VFPortCountersBean, PortCounterFieldItem>
implements IFieldObserver {
    private final Map<String, IVFPortCountersProcessor> processorMap = new HashMap<String, IVFPortCountersProcessor>();
    private String field;

    public VFPCErrObserver(PortCounterFieldItem controller) {
        super(controller);
        this.initProcessorMap();
    }

    private void initProcessorMap() {
        this.processorMap.put(STLConstants.K0837_RX_FECN.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvFECN();
            }
        });
        this.processorMap.put(STLConstants.K0838_RX_BECN.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvBECN();
            }
        });
        this.processorMap.put(STLConstants.K0842_RX_BUBBLE.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFRcvBubble();
            }
        });
        this.processorMap.put(STLConstants.K0714_TRAN_DISCARDS.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitDiscards();
            }
        });
        this.processorMap.put(STLConstants.K0836_TX_WAIT.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitWait();
            }
        });
        this.processorMap.put(STLConstants.K0839_TX_TIME_CONG.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitTimeCong();
            }
        });
        this.processorMap.put(STLConstants.K0840_TX_WASTED_BW.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitWastedBW();
            }
        });
        this.processorMap.put(STLConstants.K0841_TX_WAIT_DATA.getValue(), new IVFPortCountersProcessor(){

            @Override
            public long getValue(VFPortCountersBean bean) {
                return bean.getPortVFXmitWaitData();
            }
        });
    }

    @Override
    public synchronized void processData(VFPortCountersBean bean) {
        if (bean == null) {
            return;
        }
        PortCounterSourceName sourceName = new PortCounterSourceName(bean.getNodeLid(), bean.getPortNumber(), this.field);
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        IVFPortCountersProcessor processor = this.processorMap.get(this.field);
        if (processor != null) {
            ((PortCounterFieldItem)this.controller).updateTrend((double)processor.getValue(bean), time, interval, sourceName);
        }
    }

    @Override
    public synchronized void setFieldName(String name) {
        this.field = name;
    }
}

