/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.provider.IDataProvider;
import com.intel.stl.ui.performance.provider.ISourceObserver;
import com.intel.stl.ui.publisher.TaskScheduler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractDataProvider<E, S extends ISource>
implements IDataProvider<E, S> {
    private static final boolean DEBUG = false;
    protected TaskScheduler scheduler;
    protected List<IDataObserver<E>> observers = new CopyOnWriteArrayList<IDataObserver<E>>();
    protected List<ISourceObserver<S>> sourceObservers = new CopyOnWriteArrayList<ISourceObserver<S>>();
    protected HistoryType historyType;
    protected boolean forcedUpdate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContext(Context context, IProgressObserver progressObserver, S[] sourceNames) {
        if (context == null) {
            this.clear();
            return;
        }
        boolean sameSources = this.sameSources((ISource[])sourceNames);
        if (!this.hasScheduler(context)) {
            this.clear();
            this.scheduler = context.getTaskScheduler();
        } else {
            if (sameSources) {
                this.onRefresh(null);
                return;
            }
            this.clear();
        }
        this.fireSourcesToAdd((ISource[])sourceNames);
        try {
            this.setSources((ISource[])sourceNames);
        }
        finally {
            this.fireSourcesAdded((ISource[])sourceNames);
        }
    }

    protected abstract S[] getSourceNames();

    protected abstract boolean sameSources(S[] var1);

    protected abstract void setSources(S[] var1);

    protected boolean hasScheduler(Context context) {
        return this.scheduler != null && context.getTaskScheduler() == this.scheduler;
    }

    @Override
    public void addObserver(IDataObserver<E> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IDataObserver<E> observer) {
        this.observers.remove(observer);
    }

    @Override
    public void addSourceObserver(ISourceObserver<S> observer) {
        this.sourceObservers.add(observer);
    }

    @Override
    public void removeSourceObserver(ISourceObserver<S> observer) {
        this.sourceObservers.remove(observer);
    }

    protected void fireNewData(E data) {
        for (IDataObserver<E> observer : this.observers) {
            observer.processData(data);
        }
    }

    protected void fireSourcesToRemove(S[] names) {
        for (ISourceObserver<S> observer : this.sourceObservers) {
            observer.sourcesToRemove((ISource[])names);
        }
    }

    protected void fireSourcesToAdd(S[] names) {
        for (ISourceObserver<S> observer : this.sourceObservers) {
            observer.sourcesToAdd((ISource[])names);
        }
    }

    protected void fireSourcesRemoved(S[] names) {
        for (ISourceObserver<S> observer : this.sourceObservers) {
            observer.sourcesRemoved((ISource[])names);
        }
    }

    protected void fireSourcesAdded(S[] names) {
        for (ISourceObserver<S> observer : this.sourceObservers) {
            observer.sourcesAdded((ISource[])names);
        }
    }

    @Override
    public void setHistoryType(HistoryType type, boolean forcedUpdate) {
        this.historyType = type;
        this.forcedUpdate = forcedUpdate;
    }

    @Override
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ISource[] oldSources = this.getSourceNames();
        if (oldSources != null && oldSources.length > 0) {
            this.fireSourcesToRemove(oldSources);
        }
        try {
            this.clearSources();
        }
        finally {
            if (oldSources != null && oldSources.length > 0) {
                this.fireSourcesRemoved(oldSources);
            }
        }
    }

    protected abstract void clearSources();
}

