/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.provider.AbstractDataProvider;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;

public abstract class CombinedDataProvider<E, S extends ISource>
extends AbstractDataProvider<E[], S> {
    protected S[] sourceNames;
    protected Object sourceCritical = new Object();
    protected List<Task<E>> tasks;
    protected Future<Void> historyTask;
    private ICallback<E[]> callback;

    @Override
    protected S[] getSourceNames() {
        return this.sourceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sameSources(S[] names) {
        HashSet<S> newSet = new HashSet<S>();
        if (names != null && names.length > 0) {
            newSet.addAll(Arrays.asList(names));
        }
        Object object = this.sourceCritical;
        synchronized (object) {
            HashSet<S> oldSet = new HashSet<S>();
            if (this.sourceNames != null) {
                oldSet.addAll(Arrays.asList(this.sourceNames));
            }
            return newSet.equals(oldSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSources(S[] names) {
        Object object = this.sourceCritical;
        synchronized (object) {
            this.sourceNames = names;
            if (names != null && names.length > 0) {
                for (IDataObserver observer : this.observers) {
                    observer.reset();
                }
                if (this.historyType != null && this.historyType != HistoryType.CURRENT) {
                    this.historyTask = this.initHistory((ISource[])names, this.getCallback());
                }
                this.tasks = this.registerTasks((ISource[])names, this.getCallback());
                this.onRefresh(null);
            }
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.submitToBackground(new Runnable(){

            @Override
            public void run() {
                ISource[] sources = CombinedDataProvider.this.getSourceNames();
                if (sources.length > 0) {
                    Object[] result = CombinedDataProvider.this.refresh(sources);
                    if (CombinedDataProvider.this.sameSources(sources)) {
                        CombinedDataProvider.this.getCallback().onDone(result);
                    }
                }
            }
        });
    }

    protected ICallback<E[]> getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackAdapter<E[]>(){

                @Override
                public synchronized void onDone(E[] result) {
                    if (result != null) {
                        CombinedDataProvider.this.fireNewData(result);
                    }
                }
            };
        }
        return this.callback;
    }

    protected abstract E[] refresh(S[] var1);

    protected abstract List<Task<E>> registerTasks(S[] var1, ICallback<E[]> var2);

    protected abstract void deregisterTasks(List<Task<E>> var1, ICallback<E[]> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSources() {
        if (this.scheduler != null) {
            if (this.tasks != null) {
                this.deregisterTasks(this.tasks, this.callback);
            }
            if (this.historyTask != null) {
                this.historyTask.cancel(true);
            }
        }
        Object object = this.sourceCritical;
        synchronized (object) {
            this.sourceNames = null;
        }
    }

    protected abstract Future<Void> initHistory(S[] var1, ICallback<E[]> var2);

    @Override
    public void setHistoryType(HistoryType type, boolean forcedUpdate) {
        ISource[] sources;
        super.setHistoryType(type, forcedUpdate);
        for (IDataObserver observer : this.observers) {
            observer.reset();
        }
        if (this.historyTask != null && !this.historyTask.isDone()) {
            this.historyTask.cancel(true);
        }
        if ((sources = this.getSourceNames()) != null && this.scheduler != null && this.historyType != HistoryType.CURRENT) {
            this.historyTask = this.initHistory(sources, this.getCallback());
        }
    }
}

