/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.provider.SimpleDataProvider;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.util.Collections;
import java.util.concurrent.Future;

public class PortCountersProvider
extends SimpleDataProvider<PortCountersBean, PortSourceName> {
    @Override
    protected PortCountersBean refresh(PortSourceName sourceName) {
        return this.scheduler.getPerformanceApi().getPortCounters(sourceName.getLid(), sourceName.getPortNum());
    }

    @Override
    protected Task<PortCountersBean> registerTask(PortSourceName sourceName, ICallback<PortCountersBean> callback) {
        PortCounterSubscriber subscriber = (PortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        return subscriber.registerPortCounters(sourceName.getLid(), sourceName.getPortNum(), callback);
    }

    @Override
    protected void deregisterTask(Task<PortCountersBean> task, ICallback<PortCountersBean> callback) {
        PortCounterSubscriber subscriber = (PortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        subscriber.deregisterPortCounters(task, callback);
    }

    @Override
    protected Future<Void> initHistory(PortSourceName sourceName, ICallback<PortCountersBean[]> callback) {
        PortCounterSubscriber subscriber = (PortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        return subscriber.initPortCountersHistory(sourceName.getLid(), Collections.singletonList(sourceName.getPortNum()), this.historyType, callback);
    }
}

