/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.provider.AbstractDataProvider;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import java.util.concurrent.Future;

public abstract class SimpleDataProvider<E, S extends ISource>
extends AbstractDataProvider<E, S> {
    protected S sourceName;
    protected Task<E> task;
    protected Future<Void> historyTask;
    private ICallback<E> callback;
    private ICallback<E[]> batchedCallback;

    @Override
    protected S[] getSourceNames() {
        return this.sourceName == null ? null : new ISource[]{this.sourceName};
    }

    @Override
    protected boolean sameSources(S[] names) {
        Object name;
        Object object = name = names == null || names.length == 0 ? null : (Object)names[0];
        if (name != null) {
            return name.equals(this.sourceName);
        }
        if (this.sourceName != null) {
            return this.sourceName.equals(name);
        }
        return true;
    }

    @Override
    protected void setSources(S[] names) {
        this.sourceName = names == null || names.length == 0 ? null : names[0];
        Object v0 = this.sourceName;
        if (this.sourceName != null) {
            for (IDataObserver observer : this.observers) {
                observer.reset();
            }
            if (this.historyType != null && this.historyType != HistoryType.CURRENT) {
                this.historyTask = this.initHistory(this.sourceName, this.getBatchedCallback());
            }
            this.task = this.registerTask(this.sourceName, this.getCallback());
            this.onRefresh(null);
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.submitToBackground(new Runnable(){

            @Override
            public void run() {
                Object source = SimpleDataProvider.this.sourceName;
                if (source != null) {
                    Object result = SimpleDataProvider.this.refresh(source);
                    if (source.equals(SimpleDataProvider.this.sourceName)) {
                        SimpleDataProvider.this.getCallback().onDone(result);
                    }
                }
            }
        });
    }

    protected ICallback<E> getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackAdapter<E>(){

                @Override
                public synchronized void onDone(E result) {
                    if (result != null) {
                        SimpleDataProvider.this.fireNewData(result);
                    }
                }
            };
        }
        return this.callback;
    }

    protected abstract E refresh(S var1);

    protected abstract Task<E> registerTask(S var1, ICallback<E> var2);

    protected abstract void deregisterTask(Task<E> var1, ICallback<E> var2);

    @Override
    public void clearSources() {
        if (this.scheduler != null) {
            if (this.task != null) {
                this.deregisterTask(this.task, this.callback);
            }
            if (this.historyTask != null) {
                this.historyTask.cancel(true);
            }
        }
        this.sourceName = null;
    }

    protected ICallback<E[]> getBatchedCallback() {
        if (this.batchedCallback == null) {
            this.batchedCallback = new CallbackAdapter<E[]>(){

                @Override
                public synchronized void onDone(E[] result) {
                    if (result != null) {
                        for (Object element : result) {
                            SimpleDataProvider.this.fireNewData(element);
                        }
                    }
                }
            };
        }
        return this.batchedCallback;
    }

    protected abstract Future<Void> initHistory(S var1, ICallback<E[]> var2);

    @Override
    public void setHistoryType(HistoryType type, boolean forcedUpdate) {
        if (this.historyType == type && !forcedUpdate) {
            return;
        }
        super.setHistoryType(type, forcedUpdate);
        for (IDataObserver observer : this.observers) {
            observer.reset();
        }
        if (this.historyTask != null && !this.historyTask.isDone()) {
            this.historyTask.cancel(true);
        }
        if (this.sourceName != null && this.scheduler != null && this.historyType != HistoryType.CURRENT) {
            this.historyTask = this.initHistory(this.sourceName, this.getBatchedCallback());
        }
    }
}

