/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedCallback<E> {
    private static final Logger log = LoggerFactory.getLogger(BatchedCallback.class);
    private final Class<E> klass;
    private final int size;
    private final ICallback<E[]> finalCallback;
    private final ICallback<E>[] callbacks;
    private E[] temp;
    private int count;
    private E[] results;
    private final int[] ids;
    private int targetId;
    private int maxId;
    private final Set<Throwable> processedErrors;

    public BatchedCallback(int size, ICallback<E[]> callback, Class<E> klass) {
        this.size = size;
        this.finalCallback = callback;
        this.klass = klass;
        this.callbacks = new ICallback[size];
        for (int i = 0; i < size; ++i) {
            this.callbacks[i] = new IndexedCallback(i);
        }
        this.processedErrors = new HashSet<Throwable>();
        this.temp = (Object[])Array.newInstance(klass, size);
        this.ids = new int[size];
        this.maxId = 1;
        this.targetId = 1;
    }

    public ICallback<E> getCallback(int index) {
        return this.callbacks[index];
    }

    protected synchronized void addResult(int index, E result) {
        int n = index;
        this.ids[n] = this.ids[n] + 1;
        if (this.ids[index] > this.targetId) {
            if (this.maxId < this.ids[index]) {
                this.maxId = this.ids[index];
            }
            log.warn(this.klass.getSimpleName() + " Result " + index + " (id=" + this.ids[index] + " targetId=" + this.targetId + " maxId=" + this.maxId + ") already exist! You may have too small refresh rate.");
        } else if (this.ids[index] == this.targetId) {
            this.temp[index] = result;
            ++this.count;
            this.finalCallback.onProgress((double)this.count / (double)this.size);
            if (this.count == this.size) {
                this.results = (Object[])Array.newInstance(this.klass, this.size);
                System.arraycopy(this.temp, 0, this.results, 0, this.size);
                this.temp = (Object[])Array.newInstance(this.klass, this.size);
                this.count = 0;
                for (int i = 0; i < this.size; ++i) {
                    this.ids[i] = this.ids[i] - this.maxId;
                }
                this.maxId = 1;
                this.targetId = 1;
                this.processedErrors.clear();
                this.finalCallback.onDone(this.results);
            }
        }
    }

    protected void clear() {
        this.processedErrors.clear();
        this.maxId = 1;
        this.targetId = 1;
        for (int i = 0; i < this.size; ++i) {
            this.temp[i] = null;
            this.ids[i] = 0;
        }
    }

    protected class IndexedCallback
    extends CallbackAdapter<E> {
        private final int index;

        public IndexedCallback(int index) {
            this.index = index;
        }

        @Override
        public void onDone(E result) {
            BatchedCallback.this.addResult(this.index, result);
        }

        @Override
        public void onError(Throwable ... errors) {
            HashSet<Throwable> newErrors = new HashSet<Throwable>();
            for (Throwable error : errors) {
                if (!BatchedCallback.this.processedErrors.contains(error)) {
                    newErrors.add(error);
                    continue;
                }
                BatchedCallback.this.processedErrors.add(error);
            }
            BatchedCallback.this.finalCallback.onError(newErrors.toArray(new Throwable[0]));
        }

        @Override
        public void reset() {
            BatchedCallback.this.clear();
        }

        public boolean belongToCallback(ICallback<E[]> callback) {
            return BatchedCallback.this.finalCallback == callback;
        }
    }
}

