/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.FMException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.failure.BaseFailureEvaluator;
import com.intel.stl.api.failure.BaseTaskFailure;
import com.intel.stl.api.failure.FailureManager;
import com.intel.stl.api.failure.FatalException;
import com.intel.stl.api.failure.IFailureEvaluator;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.api.failure.ITaskFailure;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.PerformanceRequestCancelledException;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.IRefreshRateListener;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.EventSubscriber;
import com.intel.stl.ui.publisher.subscriber.FocusPortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.GroupInfoSubscriber;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.ImageInfoSubscriber;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import com.intel.stl.ui.publisher.subscriber.VFFocusPortSubscriber;
import com.intel.stl.ui.publisher.subscriber.VFInfoSubscriber;
import com.intel.stl.ui.publisher.subscriber.VFPortCounterSubscriber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduler
implements IRegisterTask {
    private static Logger log = LoggerFactory.getLogger(TaskScheduler.class);
    private static final long SHUTDOWN_TIME = 2000L;
    private static final int POOL_SIZE = 2;
    private static final String TSB_THREAD_PREFIX = "tsbthread-";
    private static final String TSS_THREAD_PREFIX = "tssthread-";
    private final String name;
    private final Context context;
    private final IPerformanceApi perfApi;
    private ScheduledExecutorService scheduledService;
    private final ExecutorService backgroundService;
    private final IFailureManagement failureMgr;
    private final BaseFailureEvaluator failureEvaluator;
    private int refreshRate;
    private boolean shutdownInProgress = false;
    private final List<IRefreshRateListener> refreshRateChangeListeners = new ArrayList<IRefreshRateListener>();
    private final HashMap<SubscriberType, Subscriber<?>> subscriberPool = new HashMap();

    public TaskScheduler(Context context, int refreshRate) {
        this(context, 2, refreshRate);
    }

    public TaskScheduler(Context context, int poolSize, int refreshRate) {
        this.context = context;
        this.perfApi = context.getPerformanceApi();
        this.name = context.getSubnetDescription().getName();
        this.refreshRate = refreshRate;
        ServiceThreadFactory tssFactory = new ServiceThreadFactory(TSS_THREAD_PREFIX);
        this.scheduledService = Executors.newScheduledThreadPool(poolSize, tssFactory);
        ServiceThreadFactory tsbFactory = new ServiceThreadFactory(TSB_THREAD_PREFIX);
        this.backgroundService = Executors.newFixedThreadPool(poolSize * 2, tsbFactory);
        this.failureEvaluator = new BaseFailureEvaluator();
        this.failureEvaluator.setRecoverableErrors(RuntimeException.class, TimeoutException.class);
        this.failureEvaluator.setUnrecoverableErrors(IOException.class);
        this.failureMgr = FailureManager.getManager();
        this.subscriberPool.put(SubscriberType.PORT_COUNTER, new PortCounterSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.VF_PORT_COUNTER, new VFPortCounterSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.GROUP_INFO, new GroupInfoSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.IMAGE_INFO, new ImageInfoSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.VF_INFO, new VFInfoSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.FOCUS_PORTS, new FocusPortCounterSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.VF_FOCUS_PORTS, new VFFocusPortSubscriber(this, this.perfApi));
        this.subscriberPool.put(SubscriberType.EVENT, new EventSubscriber((IRegisterTask)this, context.getEvtCal()));
        log.info("Refresh Rate = " + refreshRate);
    }

    public IPerformanceApi getPerformanceApi() {
        return this.perfApi;
    }

    @Override
    public Subscriber<?> getSubscriber(SubscriberType subscriberType) {
        Subscriber<?> res = this.subscriberPool.get((Object)subscriberType);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find Subscriber '" + (Object)((Object)subscriberType) + "'");
    }

    @Override
    public int getRefreshRate() {
        return this.refreshRate;
    }

    @Override
    public void updateRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        log.info("Refresh Rate changed to: " + refreshRate);
        ScheduledExecutorService oldScheduledService = this.scheduledService;
        this.scheduledService = Executors.newScheduledThreadPool(2);
        for (Subscriber<?> subscriber : this.subscriberPool.values()) {
            subscriber.rescheduleTasks();
        }
        for (IRefreshRateListener listener : this.refreshRateChangeListeners) {
            listener.onRefreshRateChange(this.refreshRate);
        }
        try {
            this.shutdownServiceNow(oldScheduledService);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Future<?> submitToBackground(Runnable task) {
        Future<?> future;
        block2: {
            future = null;
            try {
                future = this.backgroundService.submit(task);
            }
            catch (RejectedExecutionException ree) {
                if (this.shutdownInProgress) break block2;
                throw ree;
            }
        }
        return future;
    }

    @Override
    public <E> Future<E> submitToBackground(Callable<E> task) {
        Future<E> future;
        block2: {
            future = null;
            try {
                future = this.backgroundService.submit(task);
            }
            catch (RejectedExecutionException ree) {
                if (this.shutdownInProgress) break block2;
                throw ree;
            }
        }
        return future;
    }

    @Override
    public <E> Task<E> scheduleTask(List<Task<E>> tasks, Task<E> task, ICallback<E> callback, Callable<E> caller) {
        return this.registerTask(tasks, task, callback, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> Task<E> registerTask(List<Task<E>> tasks, Task<E> task, ICallback<E> callback, final Callable<E> caller) {
        if (tasks == null) {
            return null;
        }
        List<Task<Task<E>>> list = tasks;
        synchronized (list) {
            int index = tasks.indexOf(task);
            if (index >= 0) {
                task = tasks.get(index);
                task.addCallback(callback);
                log.debug("Register Task " + task);
                log.debug("Add callback to already running task " + task);
            } else {
                task.addCallback(callback);
                task.setCaller(caller);
                final Task<E> taskFinal = task;
                log.debug("Schedule task " + task + " with rate " + this.refreshRate + " sec.");
                ScheduledFuture<?> future = this.scheduledService.scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object result = caller.call();
                            taskFinal.onDone(result);
                        }
                        catch (PerformanceRequestCancelledException e) {
                            log.info(e.getMessage());
                            try {
                                taskFinal.onError(e);
                            }
                            finally {
                                TaskScheduler.this.handleFailure(taskFinal, e);
                            }
                        }
                        catch (Exception e) {
                            log.error("Scheduled task had an error: {}", (Object)StringUtils.getErrorMessage(e), (Object)e);
                            try {
                                taskFinal.onError(e);
                            }
                            finally {
                                TaskScheduler.this.handleFailure(taskFinal, e);
                            }
                        }
                    }
                }, 0L, this.refreshRate, TimeUnit.SECONDS);
                task.setFuture(future);
                tasks.add(task);
            }
            return task;
        }
    }

    @Override
    public <E> void removeTask(List<Task<E>> tasks, Task<E> task, ICallback<E> callback) {
        this.deregisterTask(tasks, task, callback);
    }

    @Override
    public <E> void removeTask(List<Task<E>> taskList, List<Task<E>> tasks, ICallback<E[]> callbacks) {
        this.deregisterTask(taskList, tasks, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> void deregisterTask(List<Task<E>> tasks, Task<E> target, ICallback<E> callback) {
        if (tasks == null) {
            return;
        }
        List<Task<E>> list = tasks;
        synchronized (list) {
            log.debug("Deregister Task " + target);
            int index = tasks.indexOf(target);
            if (index >= 0) {
                Task<E> realTask = tasks.get(index);
                realTask.removeCallback(callback);
                if (realTask.isEmpty()) {
                    log.debug("Stop Task " + target);
                    try {
                        realTask.getFuture().cancel(true);
                    }
                    finally {
                        tasks.remove(index);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> void deregisterTask(List<Task<E>> tasks, List<Task<E>> targets, ICallback<E[]> callback) {
        if (tasks == null) {
            return;
        }
        List<Task<E>> list = tasks;
        synchronized (list) {
            for (int i = targets.size() - 1; i >= 0; --i) {
                Task<E> target = targets.get(i);
                log.debug("Deregister Task " + target);
                int index = tasks.indexOf(target);
                if (index < 0) continue;
                Task<E> realTask = tasks.get(index);
                realTask.removeSubCallbacks(callback);
                if (!realTask.isEmpty()) continue;
                log.debug("Stop Task " + target);
                try {
                    realTask.getFuture().cancel(true);
                    continue;
                }
                finally {
                    tasks.remove(index);
                }
            }
        }
    }

    protected <E> void handleFailure(final Task<E> task, final Exception e) {
        Throwable tmp;
        Throwable error = e;
        if (e instanceof FMException && (tmp = e.getCause()) != null) {
            error = tmp;
        }
        BaseTaskFailure<Void> taskFailure = new BaseTaskFailure<Void>(task, (IFailureEvaluator)this.failureEvaluator){

            @Override
            public Callable<Void> getTask() {
                return null;
            }

            @Override
            public void onFatal() {
                log.error("Fatal Failure - Stop task! " + task);
                FatalException fe = new FatalException(e);
                task.onError(fe);
                Util.showErrorMessage(TaskScheduler.this.context.getOwner(), UILabels.STL40013_FATAL_FAILURE.getDescription(task.getDescription()));
                throw fe;
            }
        };
        this.failureMgr.submit((ITaskFailure<Void>)taskFailure, error);
    }

    public void clear() {
        for (Subscriber<?> subscriber : this.subscriberPool.values()) {
            subscriber.cancelTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        this.shutdownInProgress = true;
        try {
            this.clear();
        }
        finally {
            try {
                this.failureMgr.cleanup();
            }
            finally {
                try {
                    this.shutdownService(this.scheduledService);
                }
                finally {
                    this.shutdownService(this.backgroundService);
                }
            }
        }
        log.info("Shutdown " + this.getClass().getName() + " for subnet '" + this.name + "'");
    }

    public void suspendServiceDuringFailover() throws InterruptedException {
        this.shutdownService(this.scheduledService);
    }

    private void shutdownService(ExecutorService service) throws InterruptedException {
        service.shutdown();
        if (!service.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
            log.warn("Executor did not terminate in the specified time.");
            List<Runnable> droppedTasks = service.shutdownNow();
            log.warn("Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
        }
    }

    private void shutdownServiceNow(ExecutorService service) throws InterruptedException {
        service.shutdownNow();
        if (!service.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
            log.warn("Executor did not terminate in the specified time.");
            List<Runnable> droppedTasks = service.shutdownNow();
            log.warn("Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
        }
    }

    public void addListener(IRefreshRateListener listener) {
        this.refreshRateChangeListeners.add(listener);
    }

    public void removeListener(IRefreshRateListener listener) {
        this.refreshRateChangeListeners.remove(listener);
    }

    private class ServiceThreadFactory
    implements ThreadFactory {
        private final String prefix;
        private final AtomicInteger threadCount = new AtomicInteger(1);

        public ServiceThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = this.prefix + this.threadCount.getAndIncrement();
            return new Thread(r, threadName);
        }
    }
}

