/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.publisher.BatchedCallback;
import com.intel.stl.ui.publisher.HistoryQueryTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortCounterSubscriber
extends Subscriber<PortCountersBean> {
    private static Logger log = LoggerFactory.getLogger(PortCounterSubscriber.class);
    private static final boolean DUMP_DATA = false;

    public PortCounterSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<PortCountersBean> registerPortCounters(final int lid, final short portNum, ICallback<PortCountersBean> callback) {
        Task task = new Task(163, lid + ":" + portNum, UILabels.STL40010_PORTCOUNTERS_TASK.getDescription(lid, portNum));
        Callable<PortCountersBean> caller = new Callable<PortCountersBean>(){

            @Override
            public PortCountersBean call() throws Exception {
                PortCountersBean portCounters = PortCounterSubscriber.this.perfApi.getPortCounters(lid, portNum);
                return portCounters;
            }
        };
        try {
            Task<PortCountersBean> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterPortCounters(Task<PortCountersBean> task, ICallback<PortCountersBean> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Task<PortCountersBean>> registerPortCountersArray(int[] lids, short[] portNums, ICallback<PortCountersBean[]> callbacks) {
        ArrayList<Task<PortCountersBean>> tasks = new ArrayList<Task<PortCountersBean>>();
        int size = lids.length;
        BatchedCallback<PortCountersBean> bCallback = new BatchedCallback<PortCountersBean>(size, callbacks, PortCountersBean.class);
        for (int i = 0; i < size; ++i) {
            Task<PortCountersBean> task = this.registerPortCounters(lids[i], portNums[i], bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public synchronized void deregisterPortCountersArray(List<Task<PortCountersBean>> tasks, ICallback<PortCountersBean[]> callbacks) {
        try {
            this.taskScheduler.removeTask(this.taskList, tasks, callbacks);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Task<PortCountersBean>> registerPortCounters(int lid, List<Short> portNumList, ICallback<PortCountersBean[]> callback) {
        ArrayList<Task<PortCountersBean>> tasks = new ArrayList<Task<PortCountersBean>>();
        BatchedCallback<PortCountersBean> bCallback = new BatchedCallback<PortCountersBean>(portNumList.size(), callback, PortCountersBean.class);
        log.info("portNumList.size() = " + portNumList.size());
        for (int i = 0; i < portNumList.size(); ++i) {
            Task<PortCountersBean> task = this.registerPortCounters(lid, portNumList.get(i), bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public Future<Void> initPortCountersHistory(final int lid, final List<Short> portNumList, HistoryType type, ICallback<PortCountersBean[]> callback) {
        PMConfigBean conf = this.perfApi.getPMConfig();
        int sweepInterval = conf.getSweepInterval();
        HistoryQueryTask<PortCountersBean> historyQueryTask = new HistoryQueryTask<PortCountersBean>(this.perfApi, sweepInterval, this.taskScheduler.getRefreshRate(), type, callback){

            protected PortCountersBean[] queryHistory(long[] imageIDs, int offset) {
                PortCountersBean[] res = new PortCountersBean[portNumList.size()];
                for (int i = 0; i < portNumList.size(); ++i) {
                    PortCountersBean portCounters = PortCounterSubscriber.this.perfApi.getPortCountersHistory(lid, (Short)portNumList.get(i), imageIDs[i], offset);
                    if (portCounters == null) {
                        return null;
                    }
                    res[i] = portCounters;
                }
                return res;
            }

            @Override
            protected ImageIdBean[] queryImageId() {
                ImageIdBean[] imageIdBeans = new ImageIdBean[portNumList.size()];
                for (int i = 0; i < portNumList.size(); ++i) {
                    ImageIdBean imageIdBean;
                    PortCountersBean portCountersBean = PortCounterSubscriber.this.perfApi.getPortCountersHistory(lid, (Short)portNumList.get(i), 0L, -2);
                    imageIdBeans[i] = imageIdBean = portCountersBean.getImageId();
                }
                return imageIdBeans;
            }
        };
        return this.submitHistoryQueryTask(historyQueryTask);
    }
}

