/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.VFFocusPortsRspBean;
import com.intel.stl.api.subnet.Selection;
import com.intel.stl.ui.publisher.FocusPortsTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFFocusPortSubscriber
extends Subscriber<List<VFFocusPortsRspBean>> {
    private static Logger log = LoggerFactory.getLogger(VFFocusPortSubscriber.class);

    public VFFocusPortSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<List<VFFocusPortsRspBean>> registerVFFocusPorts(final String name, final Selection selection, final int range, ICallback<List<VFFocusPortsRspBean>> callback) {
        FocusPortsTask task = new FocusPortsTask(name, selection, range, true);
        Callable<List<VFFocusPortsRspBean>> caller = new Callable<List<VFFocusPortsRspBean>>(){

            @Override
            public List<VFFocusPortsRspBean> call() throws Exception {
                List<VFFocusPortsRspBean> ports = VFFocusPortSubscriber.this.perfApi.getVFFocusPorts(name, selection, range);
                return ports;
            }
        };
        try {
            Task<List<VFFocusPortsRspBean>> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterVFFocusPorts(Task<List<VFFocusPortsRspBean>> task, ICallback<List<VFFocusPortsRspBean>> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

