/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher.subscriber;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.publisher.BatchedCallback;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.HistoryQueryTask;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.IRegisterTask;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFPortCounterSubscriber
extends Subscriber<VFPortCountersBean> {
    private static Logger log = LoggerFactory.getLogger(PortCounterSubscriber.class);

    public VFPortCounterSubscriber(IRegisterTask taskScheduler, IPerformanceApi perfApi) {
        super(taskScheduler, perfApi);
    }

    public synchronized Task<VFPortCountersBean> registerVFPortCounters(final String vfName, final int lid, final short portNum, ICallback<VFPortCountersBean> callback) {
        Task task = new Task(176, vfName + ":" + lid + ":" + portNum, UILabels.STL40011_VFPORTCOUNTERS_TASK.getDescription(lid, portNum));
        Callable<VFPortCountersBean> caller = new Callable<VFPortCountersBean>(){

            @Override
            public VFPortCountersBean call() throws Exception {
                VFPortCountersBean portCounters = VFPortCounterSubscriber.this.perfApi.getVFPortCounters(vfName, lid, portNum);
                return portCounters;
            }
        };
        try {
            Task<VFPortCountersBean> submittedTask = this.taskScheduler.scheduleTask(this.taskList, task, callback, caller);
            return submittedTask;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void deregisterVFPortCounters(Task<VFPortCountersBean> task, ICallback<VFPortCountersBean> callback) {
        try {
            this.taskScheduler.removeTask(this.taskList, task, callback);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Task<VFPortCountersBean>> registerVFPortCounters(String vfName, int[] lids, short[] portNums, ICallback<VFPortCountersBean[]> callback) {
        ArrayList<Task<VFPortCountersBean>> tasks = new ArrayList<Task<VFPortCountersBean>>();
        int size = lids.length;
        BatchedCallback<VFPortCountersBean> bCallback = new BatchedCallback<VFPortCountersBean>(size, callback, VFPortCountersBean.class);
        for (int i = 0; i < size; ++i) {
            Task<VFPortCountersBean> task = this.registerVFPortCounters(vfName, lids[i], portNums[i], bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public synchronized List<Task<VFPortCountersBean>> registerVFPortCounters(String vfName, int lid, List<Short> portNumList, ICallback<VFPortCountersBean[]> callback) {
        ArrayList<Task<VFPortCountersBean>> tasks = new ArrayList<Task<VFPortCountersBean>>();
        BatchedCallback<VFPortCountersBean> bCallback = new BatchedCallback<VFPortCountersBean>(portNumList.size(), callback, VFPortCountersBean.class);
        for (int i = 0; i < portNumList.size(); ++i) {
            Task<VFPortCountersBean> task = this.registerVFPortCounters(vfName, lid, portNumList.get(i), bCallback.getCallback(i));
            tasks.add(task);
        }
        return tasks;
    }

    public synchronized void deregisterVFPortCounters(List<Task<VFPortCountersBean>> tasks, ICallback<VFPortCountersBean[]> callbacks) {
        try {
            this.taskScheduler.removeTask(this.taskList, tasks, callbacks);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> initVFPortCountersHistory(final String vfName, final int lid, final short portNum, HistoryType type, ICallback<VFPortCountersBean> callback) {
        PMConfigBean conf = this.perfApi.getPMConfig();
        int sweepInterval = conf.getSweepInterval();
        HistoryQueryTask<VFPortCountersBean> historyQueryTask = new HistoryQueryTask<VFPortCountersBean>(this.perfApi, sweepInterval, this.taskScheduler.getRefreshRate(), type, CallbackAdapter.asArrayCallbak(callback)){

            protected VFPortCountersBean[] queryHistory(long[] imageIDs, int offset) {
                VFPortCountersBean portCounters = VFPortCounterSubscriber.this.perfApi.getVFPortCountersHistory(vfName, lid, portNum, imageIDs[0], offset);
                return new VFPortCountersBean[]{portCounters};
            }

            @Override
            protected ImageIdBean[] queryImageId() {
                VFPortCountersBean portCountersBean = VFPortCounterSubscriber.this.perfApi.getVFPortCountersHistory(vfName, lid, portNum, 0L, -2);
                ImageIdBean imageIdBean = portCountersBean.getImageId();
                return new ImageIdBean[]{imageIdBean};
            }
        };
        return this.submitHistoryQueryTask(historyQueryTask);
    }

    public Future<Void> initVFPortCountersHistory(final String vfName, final int lid, final List<Short> portNumList, HistoryType type, ICallback<VFPortCountersBean[]> callback) {
        PMConfigBean conf = this.perfApi.getPMConfig();
        int sweepInterval = conf.getSweepInterval();
        HistoryQueryTask<VFPortCountersBean> historyQueryTask = new HistoryQueryTask<VFPortCountersBean>(this.perfApi, sweepInterval, this.taskScheduler.getRefreshRate(), type, callback){

            protected VFPortCountersBean[] queryHistory(long[] imageIDs, int offset) {
                VFPortCountersBean[] res = new VFPortCountersBean[portNumList.size()];
                for (int i = 0; i < portNumList.size(); ++i) {
                    VFPortCountersBean portCounters = VFPortCounterSubscriber.this.perfApi.getVFPortCountersHistory(vfName, lid, (Short)portNumList.get(i), imageIDs[i], offset);
                    if (portCounters == null) {
                        return null;
                    }
                    res[i] = portCounters;
                }
                return res;
            }

            @Override
            protected ImageIdBean[] queryImageId() {
                ImageIdBean[] imageIdBeans = new ImageIdBean[portNumList.size()];
                for (int i = 0; i < portNumList.size(); ++i) {
                    ImageIdBean imageIdBean;
                    VFPortCountersBean portCountersBean = VFPortCounterSubscriber.this.perfApi.getVFPortCountersHistory(vfName, lid, (Short)portNumList.get(i), 0L, -2);
                    imageIdBeans[i] = imageIdBean = portCountersBean.getImageId();
                }
                return imageIdBeans;
            }
        };
        return this.submitHistoryQueryTask(historyQueryTask);
    }
}

