/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl.event;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.EventTypeViz;
import com.intel.stl.ui.wizards.impl.IMultinetWizardListener;
import com.intel.stl.ui.wizards.impl.IMultinetWizardTask;
import com.intel.stl.ui.wizards.impl.IWizardListener;
import com.intel.stl.ui.wizards.impl.InteractionType;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import com.intel.stl.ui.wizards.impl.event.IEventControl;
import com.intel.stl.ui.wizards.model.IModelChangeListener;
import com.intel.stl.ui.wizards.model.IWizardModel;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.event.EventRulesTableModel;
import com.intel.stl.ui.wizards.model.event.EventsModel;
import com.intel.stl.ui.wizards.view.event.EventWizardView;
import java.util.ArrayList;
import java.util.List;

public class EventWizardController
implements IMultinetWizardTask,
IEventControl,
IModelChangeListener<IWizardModel> {
    private final String eventFieldDelimiter = ",";
    private final EventWizardView view;
    private final EventRulesTableModel eventRulesModel;
    private EventsModel eventsModel;
    private boolean connectable;
    private IWizardListener wizardController;
    private IMultinetWizardListener multinetWizardController;
    private boolean done;
    private UserSettings userSettings;
    private boolean firstPass = true;

    public EventWizardController(EventWizardView view) {
        this.view = view;
        this.view.setDirty(false);
        this.view.setWizardListener(this);
        this.view.setEventControlListener(this);
        this.eventRulesModel = view.getModel();
    }

    public EventWizardController(EventWizardView view, EventsModel eventsModel) {
        this(view);
        this.eventsModel = eventsModel;
        view.setWizardListener(this);
    }

    protected void createEventTable() {
        for (EventType type : EventType.values()) {
            EventRule rule = new EventRule();
            rule.setCommandId(type.getId());
            rule.setEventType(type);
            rule.setEventActions(new ArrayList<EventRuleAction>());
        }
    }

    @Override
    public String getName() {
        return STLConstants.K0406_EVENTS.getValue();
    }

    @Override
    public EventWizardView getView() {
        return this.view;
    }

    @Override
    public void init() {
        this.userSettings = this.multinetWizardController.getUserSettings();
        List<EventRule> userEventRules = this.userSettings.getEventRules();
        List<EventRule> defaultSettings = this.createDefaultTable();
        if (this.eventRulesModel.getEventRules().size() <= 0) {
            this.eventRulesModel.updateTable(defaultSettings);
            this.eventsModel.setEventsRulesModel(this.eventRulesModel);
        }
        if (this.multinetWizardController.isNewWizard() || this.multinetWizardController.isFirstRun() && this.firstPass) {
            this.updateUserSettings(defaultSettings);
        } else if (userEventRules != null && !this.multinetWizardController.isFirstRun()) {
            this.updateModel(userEventRules);
        }
        this.firstPass = false;
        this.view.setDirty(false);
        this.done = false;
    }

    public List<EventRule> createDefaultTable() {
        ArrayList<EventRule> eventRules = new ArrayList<EventRule>();
        for (EventType eventType : EventType.values()) {
            EventRule rule = new EventRule();
            rule.setEventName(eventType.name());
            rule.setEventType(eventType);
            rule.setEventSeverity(eventType.getDefaultSeverity());
            ArrayList<EventRuleAction> eventActionList = new ArrayList<EventRuleAction>();
            rule.setEventActions(eventActionList);
            eventRules.add(rule);
        }
        return eventRules;
    }

    protected void updateModel(List<EventRule> eventRules) {
        List<EventRule> modelRulesList = this.eventRulesModel.getEventRules();
        if (eventRules != null) {
            for (int i = 0; i < eventRules.size(); ++i) {
                if (modelRulesList.size() <= 0) continue;
                EventRule modelRule = modelRulesList.get(i);
                EventRule eventRule = eventRules.get(i);
                modelRule.setEventType(eventRule.getEventType());
                modelRule.setEventSeverity(eventRule.getEventSeverity());
                List<EventRuleAction> actions = eventRule.getEventActions();
                List<EventRuleAction> modelActions = modelRule.getEventActions();
                modelActions.clear();
                for (int j = 0; j < actions.size(); ++j) {
                    modelActions.add(EventRuleAction.valueOf(actions.get(j).name()));
                }
            }
        }
        this.eventRulesModel.updateTable(this.eventRulesModel.getEventRules());
        this.eventsModel.setEventsRulesModel(this.eventRulesModel);
    }

    protected void updateUserSettings(List<EventRule> eventRules) {
        ArrayList<EventRule> userEventRules = new ArrayList<EventRule>();
        for (EventRule rule : eventRules) {
            ArrayList<EventRuleAction> userActionList = new ArrayList<EventRuleAction>();
            for (int i = 0; i < rule.getEventActions().size(); ++i) {
                userActionList.add(rule.getEventActions().get(i));
            }
            EventRule newRule = new EventRule(rule.getEventType(), rule.getEventSeverity(), userActionList);
            newRule.setEventName(rule.getEventType().name());
            userEventRules.add(newRule);
        }
        this.userSettings.setEventRules(userEventRules);
    }

    public EventRulesTableModel updateEventRulesTableModel(List<EventRule> eventRules) {
        if (eventRules != null) {
            List<EventRule> modelRulesList = eventRules;
            this.eventRulesModel.updateTable(modelRulesList);
        }
        return this.eventRulesModel;
    }

    @Override
    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean validateUserEntry() throws WizardValidationException {
        this.updateModel();
        return true;
    }

    @Override
    public void onPrevious() {
    }

    protected String eventRuleToString(EventRule eventRule) {
        String str = null;
        EventTypeViz eventTypeViz = EventTypeViz.getEventTypeVizFor(eventRule.getEventType());
        if (eventTypeViz != null) {
            str = eventTypeViz.getName() + "," + "," + eventRule.getEventSeverity().name() + ",";
        }
        List<EventRuleAction> actions = eventRule.getEventActions();
        int numActions = actions.size();
        for (int i = 0; i < numActions; ++i) {
            str = str + actions.get(i).name();
            if (i >= numActions - 1) continue;
            str = str + ",";
        }
        return str;
    }

    @Override
    public void onReset() {
        this.userSettings = this.multinetWizardController.retrieveUserSettings();
        this.updateModel(this.userSettings.getEventRules());
        this.view.setDirty(false);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void selectStep(String taskName) {
        this.multinetWizardController.selectStep(taskName);
    }

    @Override
    public boolean isDirty() {
        return this.view.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.view.setDirty(dirty);
        this.multinetWizardController.setDirty(dirty);
    }

    @Override
    public void doInteractiveAction(InteractionType action, Object ... data) {
        switch (action) {
            case CHANGE_WIZARDS: {
                if (data == null) {
                    return;
                }
                String taskName = (String)data[0];
                if (taskName == null) break;
                this.onReset();
                this.view.closeStatusPanel();
                this.selectStep(taskName);
                break;
            }
            case SAVE_LOGGING: {
                break;
            }
        }
    }

    @Override
    public void updateModel() {
        this.eventsModel.setEventsRulesModel(this.eventRulesModel);
    }

    @Override
    public void promoteModel(MultinetWizardModel topModel) {
        topModel.setEventsModel(this.eventsModel);
    }

    @Override
    public void onModelChange(IWizardModel m) {
        MultinetWizardModel model = (MultinetWizardModel)m;
        this.eventsModel = model.getEventsModel();
        this.view.updateView(model);
    }

    @Override
    public void setWizardController(IMultinetWizardListener controller) {
        this.multinetWizardController = controller;
    }

    @Override
    public void setWizardController(IWizardListener controller) {
        this.wizardController = controller;
    }

    @Override
    public void clear() {
        this.eventRulesModel.clear();
        this.eventsModel.setEventsRulesModel(this.eventRulesModel);
    }

    @Override
    public void updateTable(EventRulesTableModel model) {
        this.eventRulesModel.updateTable(model.getEventRules());
    }

    @Override
    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    @Override
    public boolean isEditValid() {
        return this.view.isEditValid();
    }
}

