/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.preferences;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.DocumentDirtyListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.Validator;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ExFormattedTextField;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.preferences.PreferencesInputValidator;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.preferences.PreferencesModel;
import com.intel.stl.ui.wizards.view.AbstractTaskView;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.IWizardView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import com.intel.stl.ui.wizards.view.preferences.IPreferencesView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesWizardView
extends AbstractTaskView
implements IPreferencesView {
    private static final long serialVersionUID = 6356778995911484484L;
    private final int MIN_REFRESH_RATE = 1;
    private final int MAX_REFRESH_RATE = 1800;
    private static Logger log = LoggerFactory.getLogger(PreferencesWizardView.class);
    private Integer[] defaultRefreshRates;
    private JComboBox<Integer> cboxRefreshRate;
    private ExFormattedTextField txtFldRefreshRate;
    private JComboBox<String> cboxRefreshRateUnits;
    private SafeNumberField<Integer> txtFldTimingWindow;
    private SafeNumberField<Integer> txtFldNumWorstNodes;
    private DocumentListener isDirtyListener;
    private DocumentListener setDirtyListener;
    private IWizardView wizardViewListener = null;
    private IMultinetWizardView multinetWizardViewListener = null;
    private PreferencesModel preferencesModel;
    private boolean dirty;
    private JLabel emailLbl;
    private JTextArea emailListArea;
    private JButton emailTestBtn;
    private JScrollPane scrollPane;

    public PreferencesWizardView(IWizardView wizardViewListener) {
        super("");
        this.wizardViewListener = wizardViewListener;
        try {
            this.createDocumentListener();
            this.addDocumentListeners();
            this.dirty = false;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public PreferencesWizardView(IMultinetWizardView wizardViewListener, PreferencesModel preferencesModel) {
        super("");
        this.multinetWizardViewListener = wizardViewListener;
        this.preferencesModel = preferencesModel;
        try {
            this.createDocumentListener();
            this.addDocumentListeners();
            this.dirty = false;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void addDocumentListeners() {
        if (this.cboxRefreshRate != null) {
            DocumentListener[] docListeners;
            JTextComponent tcRefreshRate = (JTextComponent)this.cboxRefreshRate.getEditor().getEditorComponent();
            for (DocumentListener docListener : docListeners = new DocumentListener[]{this.isDirtyListener, this.setDirtyListener}) {
                tcRefreshRate.getDocument().addDocumentListener(docListener);
                this.txtFldTimingWindow.getDocument().addDocumentListener(docListener);
                this.txtFldNumWorstNodes.getDocument().addDocumentListener(docListener);
                this.emailListArea.getDocument().addDocumentListener(docListener);
            }
        } else {
            log.error(STLConstants.K3044_REFRESH_FIELD_NULL.getValue());
        }
    }

    @Override
    protected JComponent getOptionComponent() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        propertiesPanel.setBackground(MultinetWizardView.WIZARD_COLOR);
        propertiesPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 10, 5, 10);
        gc.fill = 2;
        gc.weighty = 1.0;
        SafeNumberField.SafeNumberFormatter<Integer> formatter = new SafeNumberField.SafeNumberFormatter<Integer>((NumberFormat)new DecimalFormat("###"), Integer.valueOf(1), true, Integer.valueOf(1800), true){
            private static final long serialVersionUID = -2427404150726283307L;

            @Override
            protected String createOutOfRangeTooltip(Integer min, boolean inclusiveMin, Integer max, boolean inclusiveMax, Format format) {
                StringBuffer sb = new StringBuffer("<html>");
                sb.append(super.createOutOfRangeTooltip(min, inclusiveMin, max, inclusiveMax, format) + "<br>");
                sb.append(UILabels.STL81025_SWEEP_INTERVAL_VALIDATION.getDescription() + "</html>");
                return sb.toString();
            }
        };
        formatter.setValidCharacters("0123456789");
        this.txtFldRefreshRate = new ExFormattedTextField(formatter);
        formatter.setParent(this.txtFldRefreshRate);
        this.cboxRefreshRate = ComponentFactory.createComboBox(this.getDefaultRefreshRates(), this.txtFldRefreshRate, this.setDirtyListener, this.isDirtyListener);
        this.cboxRefreshRate.setName(WidgetName.SW_P_REFRESH_RATE.name());
        this.cboxRefreshRate.setEditable(true);
        this.cboxRefreshRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreferencesWizardView.this.setDirty();
            }
        });
        JLabel lblRefreshRate = ComponentFactory.getH5Label(STLConstants.K3007_REFRESH_RATE.getValue(), 1);
        lblRefreshRate.setHorizontalAlignment(4);
        this.cboxRefreshRateUnits = ComponentFactory.createComboBox(new String[]{STLConstants.K0012_SECONDS.getValue(), STLConstants.K0011_MINUTES.getValue()}, this.setDirtyListener, this.isDirtyListener);
        this.cboxRefreshRateUnits.setName(WidgetName.SW_P_REFRESH_RATE_UNIT.name());
        this.cboxRefreshRateUnits.setEditable(false);
        this.cboxRefreshRateUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreferencesWizardView.this.setDirty();
            }
        });
        this.txtFldTimingWindow = ComponentFactory.createNumericTextField(PreferencesInputValidator.getInstance().getMaxTimingLimit(), this.isDirtyListener, this.setDirtyListener);
        this.txtFldTimingWindow.setName(WidgetName.SW_P_TIME_WINDOW.name());
        JLabel lblTimeWindow = ComponentFactory.getH5Label(STLConstants.K3008_TIME_WINDOW.getValue(), 1);
        lblTimeWindow.setHorizontalAlignment(4);
        JLabel lblSeconds = ComponentFactory.getH5Label(STLConstants.K0012_SECONDS.getValue(), 1);
        this.txtFldNumWorstNodes = new SafeNumberField<Integer>(new DecimalFormat("###"), PreferencesInputValidator.getInstance().getMinNumWorstNode(), true, PreferencesInputValidator.getInstance().getMaxNumWorstNode(), true);
        this.txtFldNumWorstNodes.setName(WidgetName.SW_P_NUM_WORST_NODES.name());
        JLabel lblNumWorstNodes = ComponentFactory.getH5Label(STLConstants.K3009_NUM_WORST_NODES.getValue(), 1);
        lblNumWorstNodes.setHorizontalAlignment(4);
        JLabel lblNodes = ComponentFactory.getH5Label(STLConstants.K1024_NODE_RESOURCE.getValue(), 1);
        gc.gridwidth = 1;
        propertiesPanel.add((Component)lblRefreshRate, gc);
        gc.weightx = 1.0;
        propertiesPanel.add(this.cboxRefreshRate, gc);
        gc.weightx = 0.0;
        propertiesPanel.add(this.cboxRefreshRateUnits, gc);
        gc.gridy = 1;
        propertiesPanel.add((Component)lblTimeWindow, gc);
        gc.weightx = 1.0;
        propertiesPanel.add(this.txtFldTimingWindow, gc);
        gc.weightx = 0.0;
        propertiesPanel.add((Component)lblSeconds, gc);
        gc.gridy = 2;
        propertiesPanel.add((Component)lblNumWorstNodes, gc);
        gc.weightx = 1.0;
        propertiesPanel.add(this.txtFldNumWorstNodes, gc);
        gc.weightx = 0.0;
        propertiesPanel.add((Component)lblNodes, gc);
        mainPanel.setOpaque(true);
        mainPanel.setBackground(UIConstants.INTEL_WHITE);
        gc.insets = new Insets(10, 5, 10, 5);
        mainPanel.add(propertiesPanel);
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(this.createEmailSettingsPanel());
        return mainPanel;
    }

    private JPanel createEmailSettingsPanel() {
        this.emailLbl = ComponentFactory.getH5Label(STLConstants.K5007_WIZARD_EMAIL_PREFERENCES_LIST.getValue(), 1);
        this.emailLbl.setName(WidgetName.SW_P_EMAIL_TEST_NOTES.name());
        this.emailListArea = new JTextArea();
        this.emailListArea.setName(WidgetName.SW_P_EMAILS.name());
        this.emailListArea.setText("");
        this.emailListArea.setOpaque(true);
        this.emailListArea.setRows(3);
        this.emailListArea.setFont(UIConstants.H5_FONT.deriveFont(0));
        this.emailListArea.setWrapStyleWord(true);
        this.emailListArea.setLineWrap(true);
        this.emailListArea.getDocument().putProperty("emailList", this.emailListArea);
        Util.makeUndoable(this.emailListArea);
        this.scrollPane = new JScrollPane(this.emailListArea);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
        this.emailTestBtn = ComponentFactory.getImageButton(UIImages.PLAY.getImageIcon());
        this.emailTestBtn.setName(WidgetName.SW_P_TEST_EMAILS.name());
        this.emailTestBtn.setToolTipText(STLConstants.K5008_WIZARD_EMAIL_TEST_BTN_TOOLTIP.getValue());
        this.emailTestBtn.setDisabledIcon(UIImages.PLAY_GRAY.getImageIcon());
        this.emailTestBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWizardView.this.sendTestEmail();
            }
        });
        JLabel emailTestLbl = ComponentFactory.getH5Label(STLConstants.K5009_WIZARD_EMAIL_TEST_LABEL_TEXT.getValue(), 1);
        emailTestLbl.setHorizontalAlignment(4);
        JPanel emailSettingsPanel = new JPanel();
        emailSettingsPanel.setOpaque(true);
        emailSettingsPanel.setBackground(UIConstants.INTEL_WHITE);
        emailSettingsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        emailSettingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 3, 0, 0);
        gbc.weightx = 1.0;
        emailSettingsPanel.add((Component)this.emailLbl, gbc);
        gbc.weightx = 0.0;
        emailSettingsPanel.add((Component)emailTestLbl, gbc);
        gbc.insets = new Insets(0, 3, 0, 10);
        emailSettingsPanel.add((Component)this.emailTestBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        emailSettingsPanel.add((Component)this.scrollPane, gbc);
        return emailSettingsPanel;
    }

    protected Integer[] getDefaultRefreshRates() {
        if (this.defaultRefreshRates == null) {
            this.defaultRefreshRates = new Integer[]{10, 20, 30};
        }
        return this.defaultRefreshRates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTestEmail() {
        this.showTesting(true);
        try {
            String recipients = this.emailListArea.getText();
            this.multinetWizardViewListener.onEmailTest(recipients);
        }
        finally {
            this.showTesting(false);
        }
    }

    protected void showTesting(boolean isTesting) {
        if (isTesting) {
            this.emailLbl.setText(STLConstants.K5017_SENDING_EMAIL.getValue());
            this.emailTestBtn.setEnabled(false);
        } else {
            this.emailLbl.setText(STLConstants.K5018_EMAIL_SENT_OUT.getValue());
            this.emailTestBtn.setEnabled(true);
        }
    }

    @Override
    public void setWizardListener(IWizardTask listener) {
        super.setWizardListener(listener);
    }

    protected void addCBoxItem(Integer item, JComboBox<Integer> cbox) {
        for (int i = 0; i < cbox.getItemCount(); ++i) {
            Integer history = cbox.getItemAt(i);
            if (!item.equals(history)) continue;
            return;
        }
        cbox.addItem(item);
    }

    protected void createDocumentListener() {
        if (this.isDirtyListener == null) {
            this.isDirtyListener = new DocumentDirtyListener(){

                @Override
                public void setDirty(DocumentEvent e) {
                    PreferencesWizardView.this.dirty = true;
                }
            };
        }
        if (this.setDirtyListener == null) {
            this.setDirtyListener = new DocumentDirtyListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    super.insertUpdate(e);
                    PreferencesWizardView.this.checkEmailLabel(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    super.removeUpdate(e);
                    PreferencesWizardView.this.checkEmailLabel(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    super.changedUpdate(e);
                    PreferencesWizardView.this.checkEmailLabel(e);
                }

                @Override
                public void setDirty(DocumentEvent e) {
                    PreferencesWizardView.this.doOnEdit(e);
                }
            };
        }
    }

    private void doOnEdit(DocumentEvent e) {
        Object emailListComp = e.getDocument().getProperty("emailList");
        if (emailListComp != null && emailListComp.equals(this.emailListArea)) {
            if (this.isEmailListValid()) {
                this.setDirty();
            }
        } else {
            this.setDirty();
        }
    }

    private void checkEmailLabel(DocumentEvent e) {
        Object emailListComp = e.getDocument().getProperty("emailList");
        if (emailListComp == null || emailListComp != this.emailListArea) {
            return;
        }
        if (this.emailLbl.getText() != STLConstants.K5007_WIZARD_EMAIL_PREFERENCES_LIST.getValue()) {
            this.emailLbl.setText(STLConstants.K5007_WIZARD_EMAIL_PREFERENCES_LIST.getValue());
        }
    }

    protected void setDirty() {
        this.dirty = true;
        JTextComponent txtCompRefreshRate = (JTextComponent)this.cboxRefreshRate.getEditor().getEditorComponent();
        if (txtCompRefreshRate.getText().length() > 0 && this.txtFldTimingWindow.getText().length() > 0 && this.txtFldNumWorstNodes.getText().length() > 0) {
            this.multinetWizardViewListener.enableNext(true);
            this.multinetWizardViewListener.enableApply(true);
            this.multinetWizardViewListener.enableReset(true);
        } else {
            this.multinetWizardViewListener.enableNext(false);
            this.multinetWizardViewListener.enableApply(false);
            this.multinetWizardViewListener.enableReset(true);
        }
    }

    private boolean isEmailListValid() {
        boolean valid = false;
        if (this.isVisible()) {
            String emailListStr = this.emailListArea.getText().trim();
            if (emailListStr.isEmpty()) {
                this.scrollPane.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
                valid = true;
                return valid;
            }
            String[] emails = emailListStr.split(";");
            for (int i = 0; i < emails.length; ++i) {
                boolean vaildEmail = this.multinetWizardViewListener.isEmailValid(emails[i].trim());
                if (vaildEmail) {
                    this.scrollPane.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
                    this.multinetWizardViewListener.enableApply(true);
                    this.emailTestBtn.setEnabled(true);
                    valid = true;
                    continue;
                }
                this.scrollPane.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_DARK_RED));
                this.multinetWizardViewListener.enableApply(false);
                this.emailTestBtn.setEnabled(false);
                valid = false;
            }
        }
        return valid;
    }

    public void clearPanel() {
        this.cboxRefreshRate.setSelectedIndex(0);
        this.cboxRefreshRateUnits.setSelectedIndex(0);
        this.txtFldTimingWindow.setText("");
        this.txtFldNumWorstNodes.setText("");
    }

    @Override
    public void resetPanel() {
        Properties preferences = this.preferencesModel.getPreferences();
        if (preferences != null) {
            for (Integer value : this.getDefaultRefreshRates()) {
                this.addCBoxItem(value, this.cboxRefreshRate);
            }
            String unitStr = preferences.getProperty("RefreshRateUnits");
            TimeUnit unit = TimeUnit.valueOf(unitStr.toUpperCase());
            unitStr = PreferencesInputValidator.getTimeUnitString(unit);
            this.cboxRefreshRateUnits.setSelectedItem(unitStr);
            String storeValue = preferences.getProperty("RefreshRate");
            int refreshRate = 5;
            if (storeValue != null) {
                try {
                    refreshRate = Integer.parseInt(storeValue);
                }
                catch (NumberFormatException nfe) {
                    log.error("Invalid refresh rate '" + storeValue + "' from DB.", (Throwable)nfe);
                    nfe.printStackTrace();
                }
            }
            if (Validator.integerInRange(refreshRate, 1, 1800)) {
                this.addCBoxItem(refreshRate, this.cboxRefreshRate);
                this.cboxRefreshRate.setSelectedItem(refreshRate);
            }
            this.txtFldTimingWindow.setText(preferences.getProperty("TimingWindow"));
            this.txtFldNumWorstNodes.setText(preferences.getProperty("NumWorstNodes"));
            this.emailListArea.setText(preferences.getProperty("mailRecipients"));
            this.emailTestBtn.setEnabled(preferences.getProperty("mailRecipients").length() > 0);
            this.closeStatusPanel();
            this.dirty = false;
        }
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.multinetWizardViewListener.enableApply(dirty);
        this.multinetWizardViewListener.enableReset(dirty);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setSubnet(SubnetDescription subnet) {
    }

    @Override
    public String getRefreshRate() {
        return this.cboxRefreshRate.getSelectedItem().toString();
    }

    @Override
    public String getRefreshRateUnits() {
        String unitStr = this.cboxRefreshRateUnits.getSelectedItem().toString();
        return unitStr;
    }

    @Override
    public String getTimeWindowInSeconds() {
        return this.txtFldTimingWindow.getText();
    }

    @Override
    public String getNumWorstNodes() {
        return this.txtFldNumWorstNodes.getText();
    }

    @Override
    public void updateView(final MultinetWizardModel model) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PreferencesWizardView.this.preferencesModel = model.getPreferencesModel();
                try {
                    Integer refreshRate = Integer.valueOf(PreferencesWizardView.this.preferencesModel.getRefreshRate());
                    PreferencesWizardView.this.addCBoxItem(refreshRate, PreferencesWizardView.this.cboxRefreshRate);
                    PreferencesWizardView.this.cboxRefreshRate.setSelectedItem(refreshRate);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    PreferencesWizardView.this.cboxRefreshRate.setSelectedIndex(0);
                }
                PreferencesWizardView.this.cboxRefreshRateUnits.setSelectedItem(PreferencesWizardView.this.preferencesModel.getRefreshRateUnits());
                PreferencesWizardView.this.txtFldTimingWindow.setText(PreferencesWizardView.this.preferencesModel.getTimingWindowInSeconds());
                PreferencesWizardView.this.txtFldNumWorstNodes.setText(PreferencesWizardView.this.preferencesModel.getNumWorstNodes());
                PreferencesWizardView.this.emailListArea.setText(PreferencesWizardView.this.preferencesModel.getMailRecipients());
                PreferencesWizardView.this.dirty = false;
            }
        });
    }

    public boolean isEditValid() {
        return this.txtFldTimingWindow.isEditValid() && this.txtFldNumWorstNodes.isEditValid() && this.txtFldRefreshRate.isEditValid();
    }

    @Override
    public String getEmailList() {
        return this.emailListArea.getText().trim();
    }
}

