/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.subnet;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.DocumentDirtyListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.JScrollablePanel;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.subnet.ISubnetControl;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.subnet.SubnetModel;
import com.intel.stl.ui.wizards.view.AbstractTaskView;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.IWizardView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import com.intel.stl.ui.wizards.view.subnet.HostAdderPanel;
import com.intel.stl.ui.wizards.view.subnet.HostInfoPanel;
import com.intel.stl.ui.wizards.view.subnet.IHostInfoListener;
import com.intel.stl.ui.wizards.view.subnet.ISubnetView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetWizardView
extends AbstractTaskView
implements ISubnetView,
IHostInfoListener {
    private static final long serialVersionUID = -4237965084816535532L;
    private static Logger log = LoggerFactory.getLogger(SubnetWizardView.class);
    private JPanel pnlHostContainer;
    private final List<HostInfoPanel> hostPanelList = new ArrayList<HostInfoPanel>();
    private JCheckBox chkboxAutoConnect;
    private boolean dirty;
    private ISubnetControl subnetControlListener;
    private IWizardTask subnetWizardControlListener;
    private DocumentListener isDirtyListener;
    private DocumentListener setDirtyListener;
    private IWizardView wizardViewListener = null;
    private IMultinetWizardView multinetWizardViewListener = null;
    private final IHostInfoListener hostInfoListener = this;
    private final JFileChooser chooser;

    public SubnetWizardView(IWizardView wizardViewListener) {
        super("");
        this.wizardViewListener = wizardViewListener;
        this.chooser = new JFileChooser();
        this.dirty = false;
    }

    public SubnetWizardView(IMultinetWizardView wizardViewListener) {
        super("");
        this.multinetWizardViewListener = wizardViewListener;
        this.chooser = new JFileChooser();
        this.dirty = false;
        this.createDocumentListener();
    }

    @Override
    protected JComponent getOptionComponent() {
        JLabel lblConnectionType = ComponentFactory.getH5Label(STLConstants.K3034_CONNECTION_TYPE.getValue(), 1);
        this.chkboxAutoConnect = ComponentFactory.getIntelCheckBox(STLConstants.K0604_AUTO_CONNECT.getValue());
        this.chkboxAutoConnect.setText(STLConstants.K0604_AUTO_CONNECT.getValue());
        this.chkboxAutoConnect.setFont(UIConstants.H5_FONT.deriveFont(0));
        this.chkboxAutoConnect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SubnetWizardView.this.setDirty();
            }
        });
        JPanel optionPane = new JPanel(new BorderLayout());
        optionPane.setOpaque(true);
        optionPane.setBackground(MultinetWizardView.WIZARD_COLOR);
        this.pnlHostContainer = new JScrollablePanel();
        this.pnlHostContainer.setLayout((LayoutManager)new VerticalLayout(10));
        this.pnlHostContainer.setBackground(MultinetWizardView.WIZARD_COLOR);
        this.pnlHostContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlHostContainer.add(HostAdderPanel.getInstance(this));
        JScrollPane scrpnHostInfo = new JScrollPane(this.pnlHostContainer);
        scrpnHostInfo.getViewport().setBackground(MultinetWizardView.WIZARD_COLOR);
        scrpnHostInfo.setVerticalScrollBarPolicy(20);
        scrpnHostInfo.getViewport().setViewSize(new Dimension(100, 100));
        scrpnHostInfo.setBorder(null);
        optionPane.add((Component)scrpnHostInfo, "Center");
        JPanel pnlConnectionType = new JPanel(new FlowLayout(0));
        pnlConnectionType.setBackground(MultinetWizardView.WIZARD_COLOR);
        pnlConnectionType.add(lblConnectionType);
        pnlConnectionType.add(this.chkboxAutoConnect);
        JPanel pnlConnection = new JPanel();
        pnlConnection.setLayout(new BoxLayout(pnlConnection, 1));
        pnlConnection.add(pnlConnectionType);
        optionPane.add((Component)pnlConnection, "South");
        return optionPane;
    }

    protected JPanel getTitlePanel() {
        JPanel pnlTitle = new JPanel();
        pnlTitle.setBackground(MultinetWizardView.WIZARD_COLOR);
        pnlTitle.setLayout(new BoxLayout(pnlTitle, 0));
        pnlTitle.add(Box.createHorizontalStrut(45));
        pnlTitle.add(ComponentFactory.getH5Label(STLConstants.K3037_FE_CONNECTION.getValue(), 1));
        pnlTitle.add(Box.createHorizontalStrut(98));
        pnlTitle.add(ComponentFactory.getH5Label(STLConstants.K3038_SECURITY_INFO.getValue(), 1));
        pnlTitle.add(Box.createHorizontalStrut(74));
        pnlTitle.add(ComponentFactory.getH5Label(STLConstants.K3033_CONNECTION_TEST.getValue(), 1));
        return pnlTitle;
    }

    public void stopConnectionTest() {
        for (HostInfoPanel pnl : this.hostPanelList) {
            pnl.stopConnectionTest();
        }
    }

    public void setConnectionStatus(String subnetName, String status) {
        boolean found = false;
        HostInfoPanel hostInfoPanel = null;
        Iterator<HostInfoPanel> it = this.hostPanelList.iterator();
        while (!found && it.hasNext()) {
            hostInfoPanel = it.next();
            found = hostInfoPanel.getHostName().equals(subnetName);
        }
        if (found) {
            hostInfoPanel.setConnectionStatus(status);
        }
    }

    protected void createDocumentListener() {
        this.isDirtyListener = new DocumentDirtyListener(){

            @Override
            public void setDirty(DocumentEvent e) {
                SubnetWizardView.this.dirty = true;
            }
        };
        this.setDirtyListener = new DocumentDirtyListener(){

            @Override
            public void setDirty(DocumentEvent e) {
                SubnetWizardView.this.setDirtyFlag();
            }
        };
    }

    private void setDirtyFlag() {
        this.setDirty();
    }

    @Override
    public DocumentListener[] getDocumentListeners() {
        return new DocumentListener[]{this.isDirtyListener, this.setDirtyListener};
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void enableNext(boolean enable) {
    }

    public boolean isAutoConnected() {
        return this.chkboxAutoConnect.isSelected();
    }

    @Override
    public void setSubnet(SubnetDescription subnet) {
    }

    @Override
    public void setDirty() {
        boolean secureRequirement;
        this.dirty = true;
        int hostNameCount = 0;
        int portNumCount = 0;
        int secureCount = 0;
        int keyStoreCount = 0;
        int trustStoreCount = 0;
        int hostPanelCount = this.hostPanelList.size();
        for (HostInfoPanel pnl : this.hostPanelList) {
            if (pnl.isHostNamePopulated()) {
                ++hostNameCount;
            }
            if (pnl.isPortNumPopulated()) {
                ++portNumCount;
            }
            if (!pnl.isSecureConnection()) continue;
            ++secureCount;
            if (pnl.isKeyStorePopulated()) {
                ++keyStoreCount;
            }
            if (!pnl.isTrustStorePopulated()) continue;
            ++trustStoreCount;
        }
        boolean basicRequirement = hostNameCount == hostPanelCount && portNumCount == hostPanelCount;
        boolean bl = secureRequirement = keyStoreCount == secureCount && trustStoreCount == secureCount;
        if (this.multinetWizardViewListener.getSubnetName().length() > 0 && hostPanelCount > 0 && basicRequirement && secureRequirement) {
            this.multinetWizardViewListener.enableNext(true);
            this.multinetWizardViewListener.enableApply(true);
            this.multinetWizardViewListener.enableReset(true);
        } else {
            this.multinetWizardViewListener.enableNext(false);
            this.multinetWizardViewListener.enableApply(false);
            this.multinetWizardViewListener.enableReset(true);
        }
    }

    public void clearPanel() {
        this.pnlHostContainer.removeAll();
        this.dirty = false;
    }

    @Override
    public void resetPanel() {
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.multinetWizardViewListener.enableApply(dirty);
        this.multinetWizardViewListener.enableReset(dirty);
    }

    @Override
    public void updateView(final MultinetWizardModel model) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SubnetModel subnetModel = model.getSubnetModel();
                SubnetDescription subnet = subnetModel.getSubnet();
                if (subnet != null) {
                    SubnetWizardView.this.update(subnetModel);
                }
                SubnetWizardView.this.dirty = false;
            }
        });
    }

    @Override
    public void update(SubnetModel subnetModel) {
        HostInfo host = null;
        SubnetDescription subnet = subnetModel.getSubnet();
        try {
            host = subnet.getCurrentFE();
        }
        catch (IllegalArgumentException e) {
            Util.showError(this, e);
        }
        this.hostPanelList.clear();
        for (HostInfo hostInfo : subnet.getFEList()) {
            HostInfoPanel pnlHostInfo = new HostInfoPanel(this, this.chooser);
            pnlHostInfo.setCurrentMaster(hostInfo.equals(host));
            pnlHostInfo.setHostName(hostInfo.getHost());
            pnlHostInfo.setPortNum(String.valueOf(hostInfo.getPort()));
            pnlHostInfo.setKeyStoreFile(hostInfo.getCertsDescription().getKeyStoreFile());
            pnlHostInfo.setTrustFileFile(hostInfo.getCertsDescription().getTrustStoreFile());
            pnlHostInfo.setSecureConnection(hostInfo.isSecureConnect());
            this.hostPanelList.add(pnlHostInfo);
        }
        this.refresh();
        this.chkboxAutoConnect.setSelected(subnet.isAutoConnect());
        this.dirty = false;
    }

    @Override
    public void showMessage(String message, int messageType) {
        this.showMessage(message, null, messageType, null);
    }

    @Override
    public void setControlListener(ISubnetControl listener) {
        this.subnetControlListener = listener;
    }

    @Override
    public void setWizardListener(IWizardTask listener) {
        super.setWizardListener(listener);
        this.subnetWizardControlListener = listener;
    }

    protected void refresh() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SubnetWizardView.this.pnlHostContainer.removeAll();
                boolean isFirst = true;
                for (HostInfoPanel pnl : SubnetWizardView.this.hostPanelList) {
                    SubnetWizardView.this.pnlHostContainer.add(pnl);
                    if (pnl.getHostName().equals("")) {
                        pnl.setFocus();
                    }
                    if (!isFirst) continue;
                    pnl.enableRemove(false);
                    isFirst = false;
                }
                SubnetWizardView.this.pnlHostContainer.add(HostAdderPanel.getInstance(SubnetWizardView.this.hostInfoListener));
                ((JScrollPane)SubnetWizardView.this.pnlHostContainer.getParent().getParent()).scrollRectToVisible(SubnetWizardView.this.pnlHostContainer.getBounds());
                SubnetWizardView.this.pnlHostContainer.scrollRectToVisible(new Rectangle(0, (int)SubnetWizardView.this.pnlHostContainer.getPreferredSize().getHeight(), 10, 10));
                SubnetWizardView.this.setDirty();
                SubnetWizardView.this.repaint();
                SubnetWizardView.this.revalidate();
            }
        });
    }

    @Override
    public void addHost() {
        this.hostPanelList.add(new HostInfoPanel(this, this.chooser));
        this.refresh();
        this.multinetWizardViewListener.enableRun(false);
        this.dirty = true;
    }

    @Override
    public void removeHost(HostInfoPanel pnlHostInfo) {
        boolean found = false;
        Iterator<HostInfoPanel> it = this.hostPanelList.iterator();
        while (!found && it.hasNext()) {
            HostInfoPanel pnl = it.next();
            if (!pnl.equals(pnlHostInfo)) continue;
            this.hostPanelList.remove(pnl);
            found = true;
        }
        this.refresh();
    }

    public List<HostInfoPanel> getHostPanelList() {
        return this.hostPanelList;
    }

    @Override
    public boolean hasDuplicateHosts() {
        HashSet<HostInfoPanel> hostPanelSet = new HashSet<HostInfoPanel>();
        for (HostInfoPanel pnl : this.hostPanelList) {
            if (hostPanelSet.add(pnl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void runConnectionTest(HostInfoPanel hostInfoPanel) {
        HostInfo hostInfo;
        if (hostInfoPanel.isSecureConnection()) {
            CertsDescription certsDescription = new CertsDescription(hostInfoPanel.getKeyStoreFile(), hostInfoPanel.getTrustStoreFile());
            hostInfo = new HostInfo(hostInfoPanel.getHostName(), Integer.valueOf(hostInfoPanel.getPortNum()), certsDescription);
        } else {
            hostInfo = new HostInfo(hostInfoPanel.getHostName(), Integer.valueOf(hostInfoPanel.getPortNum()));
        }
        this.subnetControlListener.connectActionPerformed(hostInfo);
    }

    @Override
    public void showErrorMessage(String errorMessage) {
        Util.showErrorMessage(this, errorMessage);
    }

    @Override
    public int showFileChooser() {
        return this.chooser.showOpenDialog(this.getParent().getParent().getParent().getParent());
    }

    public boolean isEditValid() {
        for (HostInfoPanel hip : this.hostPanelList) {
            if (hip.isEditValid()) continue;
            return false;
        }
        return true;
    }
}

