/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.handler.mxEdgeHandler;
import com.mxgraph.swing.handler.mxElbowEdgeHandler;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.handler.mxPanningHandler;
import com.mxgraph.swing.handler.mxSelectionCellsHandler;
import com.mxgraph.swing.handler.mxVertexHandler;
import com.mxgraph.swing.util.mxCellOverlay;
import com.mxgraph.swing.util.mxICellOverlay;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxTemporaryCellStates;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;

public class mxGraphComponent
extends JScrollPane
implements Printable {
    private static final long serialVersionUID = -30203858391633447L;
    public static final int GRID_STYLE_DOT = 0;
    public static final int GRID_STYLE_CROSS = 1;
    public static final int GRID_STYLE_LINE = 2;
    public static final int GRID_STYLE_DASHED = 3;
    public static final int ZOOM_POLICY_NONE = 0;
    public static final int ZOOM_POLICY_PAGE = 1;
    public static final int ZOOM_POLICY_WIDTH = 2;
    public static ImageIcon DEFAULT_EXPANDED_ICON = null;
    public static ImageIcon DEFAULT_COLLAPSED_ICON = null;
    public static ImageIcon DEFAULT_WARNING_ICON = null;
    public static final double DEFAULT_PAGESCALE = 1.4;
    protected mxGraph graph;
    protected mxGraphControl graphControl;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxICellEditor cellEditor;
    protected mxConnectionHandler connectionHandler;
    protected mxPanningHandler panningHandler;
    protected mxSelectionCellsHandler selectionCellsHandler;
    protected mxGraphHandler graphHandler;
    protected float previewAlpha = 0.5f;
    protected ImageIcon backgroundImage;
    protected PageFormat pageFormat = new PageFormat();
    protected mxInteractiveCanvas canvas;
    protected BufferedImage tripleBuffer;
    protected Graphics2D tripleBufferGraphics;
    protected double pageScale = 1.4;
    protected boolean pageVisible = false;
    protected boolean preferPageSize = false;
    protected boolean pageBreaksVisible = true;
    protected Color pageBreakColor = Color.darkGray;
    protected int horizontalPageCount = 1;
    protected int verticalPageCount = 1;
    protected boolean centerPage = true;
    protected Color pageBackgroundColor = new Color(144, 153, 174);
    protected Color pageShadowColor = new Color(110, 120, 140);
    protected Color pageBorderColor = Color.black;
    protected boolean gridVisible = false;
    protected Color gridColor = new Color(192, 192, 192);
    protected boolean autoScroll = true;
    protected boolean autoExtend = true;
    protected boolean dragEnabled = true;
    protected boolean importEnabled = true;
    protected boolean exportEnabled = true;
    protected boolean foldingEnabled = true;
    protected int tolerance = 4;
    protected boolean swimlaneSelectionEnabled = true;
    protected boolean transparentSwimlaneContent = true;
    protected int gridStyle = 0;
    protected ImageIcon expandedIcon = DEFAULT_EXPANDED_ICON;
    protected ImageIcon collapsedIcon = DEFAULT_COLLAPSED_ICON;
    protected ImageIcon warningIcon = DEFAULT_WARNING_ICON;
    protected boolean antiAlias = true;
    protected boolean textAntiAlias = true;
    protected boolean escapeEnabled = true;
    protected boolean invokesStopCellEditing = true;
    protected boolean enterStopsCellEditing = false;
    protected int zoomPolicy = 1;
    private transient boolean zooming = false;
    protected double zoomFactor = 1.2;
    protected boolean keepSelectionVisibleOnZoom = false;
    protected boolean centerZoom = true;
    protected boolean tripleBuffered = false;
    public boolean showDirtyRectangle = false;
    protected Hashtable<Object, Component[]> components = new Hashtable();
    protected Hashtable<Object, mxICellOverlay[]> overlays = new Hashtable();
    private transient boolean centerOnResize = true;
    protected mxEventSource.mxIEventListener updateHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxGraphComponent.this.updateComponents();
            mxGraphComponent.this.graphControl.updatePreferredSize();
        }
    };
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            Rectangle rectangle;
            mxRectangle mxRectangle2 = (mxRectangle)mxEventObject2.getProperty("region");
            Rectangle rectangle2 = rectangle = mxRectangle2 != null ? mxRectangle2.getRectangle() : null;
            if (rectangle != null) {
                rectangle.grow(1, 1);
            }
            mxGraphComponent.this.repaintTripleBuffer(rectangle);
            mxGraphComponent.this.graphControl.repaint(rectangle != null ? rectangle : mxGraphComponent.this.getViewport().getViewRect());
            JPanel jPanel = (JPanel)mxGraphComponent.this.getClientProperty("dirty");
            if (mxGraphComponent.this.showDirtyRectangle) {
                if (jPanel == null) {
                    jPanel = new JPanel();
                    jPanel.setOpaque(false);
                    jPanel.setBorder(BorderFactory.createLineBorder(Color.RED));
                    mxGraphComponent.this.putClientProperty("dirty", jPanel);
                    mxGraphComponent.this.graphControl.add(jPanel);
                }
                if (mxRectangle2 != null) {
                    jPanel.setBounds(mxRectangle2.getRectangle());
                }
                jPanel.setVisible(mxRectangle2 != null);
            } else if (jPanel != null && jPanel.getParent() != null) {
                jPanel.getParent().remove(jPanel);
                mxGraphComponent.this.putClientProperty("dirty", null);
                mxGraphComponent.this.repaint();
            }
        }
    };
    protected PropertyChangeListener viewChangeHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("view")) {
                mxGraphView mxGraphView2 = (mxGraphView)propertyChangeEvent.getOldValue();
                mxGraphView mxGraphView3 = (mxGraphView)propertyChangeEvent.getNewValue();
                if (mxGraphView2 != null) {
                    mxGraphView2.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (mxGraphView3 != null) {
                    mxGraphView3.addListener("scale", mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener("translate", mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener("scaleAndTranslate", mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener("up", mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener("down", mxGraphComponent.this.updateHandler);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                mxGraphModel mxGraphModel2 = (mxGraphModel)propertyChangeEvent.getOldValue();
                mxGraphModel mxGraphModel3 = (mxGraphModel)propertyChangeEvent.getNewValue();
                if (mxGraphModel2 != null) {
                    mxGraphModel2.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (mxGraphModel3 != null) {
                    mxGraphModel3.addListener("change", mxGraphComponent.this.updateHandler);
                }
            }
        }
    };
    protected mxEventSource.mxIEventListener scaleHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (!mxGraphComponent.this.zooming) {
                mxGraphComponent.this.zoomPolicy = 0;
            }
        }
    };

    public mxGraphComponent(mxGraph mxGraph2) {
        this.setCellEditor(this.createCellEditor());
        this.canvas = this.createCanvas();
        this.graphControl = this.createGraphControl();
        this.installFocusHandler();
        this.installKeyHandler();
        this.installResizeHandler();
        this.setGraph(mxGraph2);
        this.setViewportView(this.graphControl);
        this.createHandlers();
        this.installDoubleClickHandler();
    }

    protected void installFocusHandler() {
        this.graphControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!mxGraphComponent.this.hasFocus()) {
                    mxGraphComponent.this.requestFocus();
                }
            }
        });
    }

    protected void installKeyHandler() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && mxGraphComponent.this.isEscapeEnabled()) {
                    mxGraphComponent.this.escape(keyEvent);
                }
            }
        });
    }

    protected void installResizeHandler() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                mxGraphComponent.this.zoomAndCenter();
            }
        });
    }

    protected void installDoubleClickHandler() {
        this.graphControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mxGraphComponent.this.isEnabled()) {
                    if (!mouseEvent.isConsumed() && mxGraphComponent.this.isEditEvent(mouseEvent)) {
                        Object object = mxGraphComponent.this.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
                        if (object != null && mxGraphComponent.this.getGraph().isCellEditable(object)) {
                            mxGraphComponent.this.startEditingAtCell(object, mouseEvent);
                        }
                    } else {
                        mxGraphComponent.this.stopEditing(!mxGraphComponent.this.invokesStopCellEditing);
                    }
                }
            }
        });
    }

    protected mxICellEditor createCellEditor() {
        return new mxCellEditor(this);
    }

    public void setGraph(mxGraph mxGraph2) {
        mxGraph mxGraph3 = this.graph;
        if (this.graph != null) {
            this.graph.removeListener(this.repaintHandler);
            this.graph.getModel().removeListener(this.updateHandler);
            this.graph.getView().removeListener(this.updateHandler);
            this.graph.removePropertyChangeListener(this.viewChangeHandler);
            this.graph.getView().removeListener(this.scaleHandler);
        }
        this.graph = mxGraph2;
        this.graph.addListener("repaint", this.repaintHandler);
        this.graph.getModel().addListener("change", this.updateHandler);
        mxGraphView mxGraphView2 = this.graph.getView();
        mxGraphView2.addListener("scale", this.updateHandler);
        mxGraphView2.addListener("translate", this.updateHandler);
        mxGraphView2.addListener("scaleAndTranslate", this.updateHandler);
        mxGraphView2.addListener("up", this.updateHandler);
        mxGraphView2.addListener("down", this.updateHandler);
        this.graph.addPropertyChangeListener(this.viewChangeHandler);
        this.graph.getView().addListener("scale", this.scaleHandler);
        this.graph.getView().addListener("scaleAndTranslate", this.scaleHandler);
        this.updateHandler.invoke(this.graph.getView(), null);
        this.firePropertyChange("graph", mxGraph3, this.graph);
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    protected mxGraphControl createGraphControl() {
        return new mxGraphControl();
    }

    public mxGraphControl getGraphControl() {
        return this.graphControl;
    }

    protected void createHandlers() {
        this.setTransferHandler(this.createTransferHandler());
        this.panningHandler = this.createPanningHandler();
        this.selectionCellsHandler = this.createSelectionCellsHandler();
        this.connectionHandler = this.createConnectionHandler();
        this.graphHandler = this.createGraphHandler();
    }

    protected TransferHandler createTransferHandler() {
        return new mxGraphTransferHandler();
    }

    protected mxSelectionCellsHandler createSelectionCellsHandler() {
        return new mxSelectionCellsHandler(this);
    }

    protected mxGraphHandler createGraphHandler() {
        return new mxGraphHandler(this);
    }

    public mxSelectionCellsHandler getSelectionCellsHandler() {
        return this.selectionCellsHandler;
    }

    public mxGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    protected mxConnectionHandler createConnectionHandler() {
        return new mxConnectionHandler(this);
    }

    public mxConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected mxPanningHandler createPanningHandler() {
        return new mxPanningHandler(this);
    }

    public mxPanningHandler getPanningHandler() {
        return this.panningHandler;
    }

    public boolean isEditing() {
        return this.getCellEditor().getEditingCell() != null;
    }

    public mxICellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(mxICellEditor mxICellEditor2) {
        mxICellEditor mxICellEditor3 = this.cellEditor;
        this.cellEditor = mxICellEditor2;
        this.firePropertyChange("cellEditor", mxICellEditor3, this.cellEditor);
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int n) {
        int n2 = this.tolerance;
        this.tolerance = n;
        this.firePropertyChange("tolerance", n2, this.tolerance);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        PageFormat pageFormat2 = this.pageFormat;
        this.pageFormat = pageFormat;
        this.firePropertyChange("pageFormat", pageFormat2, this.pageFormat);
    }

    public double getPageScale() {
        return this.pageScale;
    }

    public void setPageScale(double d) {
        double d2 = this.pageScale;
        this.pageScale = d;
        this.firePropertyChange("pageScale", d2, this.pageScale);
    }

    public mxRectangle getLayoutAreaSize() {
        if (this.pageVisible) {
            Dimension dimension = this.getPreferredSizeForPage();
            return new mxRectangle(new Rectangle(dimension));
        }
        return new mxRectangle(new Rectangle(this.graphControl.getSize()));
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this.backgroundImage;
        this.backgroundImage = imageIcon;
        this.firePropertyChange("backgroundImage", imageIcon2, this.backgroundImage);
    }

    public boolean isPageVisible() {
        return this.pageVisible;
    }

    public void setPageVisible(boolean bl) {
        boolean bl2 = this.pageVisible;
        this.pageVisible = bl;
        this.firePropertyChange("pageVisible", bl2, this.pageVisible);
    }

    public boolean isPreferPageSize() {
        return this.preferPageSize;
    }

    public void setPreferPageSize(boolean bl) {
        boolean bl2 = this.preferPageSize;
        this.preferPageSize = bl;
        this.firePropertyChange("preferPageSize", bl2, this.preferPageSize);
    }

    public boolean isPageBreaksVisible() {
        return this.pageBreaksVisible;
    }

    public void setPageBreaksVisible(boolean bl) {
        boolean bl2 = this.pageBreaksVisible;
        this.pageBreaksVisible = bl;
        this.firePropertyChange("pageBreaksVisible", bl2, this.pageBreaksVisible);
    }

    public Color getPageBreakColor() {
        return this.pageBreakColor;
    }

    public void setPageBreakColor(Color color) {
        this.pageBreakColor = color;
    }

    public void setHorizontalPageCount(int n) {
        int n2 = this.horizontalPageCount;
        this.horizontalPageCount = n;
        this.firePropertyChange("horizontalPageCount", n2, this.horizontalPageCount);
    }

    public int getHorizontalPageCount() {
        return this.horizontalPageCount;
    }

    public void setVerticalPageCount(int n) {
        int n2 = this.verticalPageCount;
        this.verticalPageCount = n;
        this.firePropertyChange("verticalPageCount", n2, this.verticalPageCount);
    }

    public int getVerticalPageCount() {
        return this.verticalPageCount;
    }

    public boolean isCenterPage() {
        return this.centerPage;
    }

    public void setCenterPage(boolean bl) {
        boolean bl2 = this.centerPage;
        this.centerPage = bl;
        this.firePropertyChange("centerPage", bl2, this.centerPage);
    }

    public Color getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public void setPageBackgroundColor(Color color) {
        Color color2 = this.pageBackgroundColor;
        this.pageBackgroundColor = color;
        this.firePropertyChange("pageBackgroundColor", color2, this.pageBackgroundColor);
    }

    public Color getPageShadowColor() {
        return this.pageShadowColor;
    }

    public void setPageShadowColor(Color color) {
        Color color2 = this.pageShadowColor;
        this.pageShadowColor = color;
        this.firePropertyChange("pageShadowColor", color2, this.pageShadowColor);
    }

    public Color getPageBorderColor() {
        return this.pageBorderColor;
    }

    public void setPageBorderColor(Color color) {
        Color color2 = this.pageBorderColor;
        this.pageBorderColor = color;
        this.firePropertyChange("pageBorderColor", color2, this.pageBorderColor);
    }

    public boolean isKeepSelectionVisibleOnZoom() {
        return this.keepSelectionVisibleOnZoom;
    }

    public void setKeepSelectionVisibleOnZoom(boolean bl) {
        boolean bl2 = this.keepSelectionVisibleOnZoom;
        this.keepSelectionVisibleOnZoom = bl;
        this.firePropertyChange("keepSelectionVisibleOnZoom", bl2, this.keepSelectionVisibleOnZoom);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        double d2 = this.zoomFactor;
        this.zoomFactor = d;
        this.firePropertyChange("zoomFactor", d2, this.zoomFactor);
    }

    public boolean isCenterZoom() {
        return this.centerZoom;
    }

    public void setCenterZoom(boolean bl) {
        boolean bl2 = this.centerZoom;
        this.centerZoom = bl;
        this.firePropertyChange("centerZoom", bl2, this.centerZoom);
    }

    public void setZoomPolicy(int n) {
        int n2 = this.zoomPolicy;
        this.zoomPolicy = n;
        if (this.zoomPolicy != 0) {
            this.zoom(this.zoomPolicy == 1, true);
        }
        this.firePropertyChange("zoomPolicy", n2, this.zoomPolicy);
    }

    public int getZoomPolicy() {
        return this.zoomPolicy;
    }

    public void escape(KeyEvent keyEvent) {
        if (this.selectionCellsHandler != null) {
            this.selectionCellsHandler.reset();
        }
        if (this.connectionHandler != null) {
            this.connectionHandler.reset();
        }
        if (this.graphHandler != null) {
            this.graphHandler.reset();
        }
        if (this.cellEditor != null) {
            this.cellEditor.stopEditing(true);
        }
    }

    public Object[] importCells(Object[] objectArray, double d, double d2, Object object, Point point) {
        return this.graph.moveCells(objectArray, d, d2, true, object, point);
    }

    public void refresh() {
        this.graph.refresh();
        this.selectionCellsHandler.refresh();
    }

    public mxPoint getPointForEvent(MouseEvent mouseEvent) {
        return this.getPointForEvent(mouseEvent, true);
    }

    public mxPoint getPointForEvent(MouseEvent mouseEvent, boolean bl) {
        double d = this.graph.getView().getScale();
        mxPoint mxPoint2 = this.graph.getView().getTranslate();
        double d2 = bl ? (double)(this.graph.getGridSize() / 2) : 0.0;
        double d3 = this.graph.snap((double)mouseEvent.getX() / d - mxPoint2.getX() - d2);
        double d4 = this.graph.snap((double)mouseEvent.getY() / d - mxPoint2.getY() - d2);
        return new mxPoint(d3, d4);
    }

    public void startEditing() {
        this.startEditingAtCell(null);
    }

    public void startEditingAtCell(Object object) {
        this.startEditingAtCell(object, null);
    }

    public void startEditingAtCell(Object object, EventObject eventObject) {
        if (object == null && (object = this.graph.getSelectionCell()) != null && !this.graph.isCellEditable(object)) {
            object = null;
        }
        if (object != null) {
            this.eventSource.fireEvent(new mxEventObject("startEditing", "cell", object, "event", eventObject));
            this.cellEditor.startEditing(object, eventObject);
        }
    }

    public String getEditingValue(Object object, EventObject eventObject) {
        return this.graph.convertValueToString(object);
    }

    public void stopEditing(boolean bl) {
        this.cellEditor.stopEditing(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object labelChanged(Object object, Object object2, EventObject eventObject) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxIGraphModel2.beginUpdate();
        try {
            this.graph.cellLabelChanged(object, object2, this.graph.isAutoSizeCell(object));
            this.eventSource.fireEvent(new mxEventObject("labelChanged", "cell", object, "value", object2, "event", eventObject));
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
        return object;
    }

    protected Dimension getPreferredSizeForPage() {
        return new Dimension((int)Math.round(this.pageFormat.getWidth() * this.pageScale * (double)this.horizontalPageCount), (int)Math.round(this.pageFormat.getHeight() * this.pageScale * (double)this.verticalPageCount));
    }

    public int getVerticalPageBorder() {
        return (int)Math.round(this.pageFormat.getWidth() * this.pageScale);
    }

    public int getHorizontalPageBorder() {
        return (int)Math.round(0.5 * this.pageFormat.getHeight() * this.pageScale);
    }

    protected Dimension getScaledPreferredSizeForGraph() {
        mxRectangle mxRectangle2 = this.graph.getGraphBounds();
        int n = this.graph.getBorder();
        return new Dimension((int)Math.round(mxRectangle2.getX() + mxRectangle2.getWidth()) + n + 1, (int)Math.round(mxRectangle2.getY() + mxRectangle2.getHeight()) + n + 1);
    }

    protected mxPoint getPageTranslate(double d) {
        Dimension dimension = this.getPreferredSizeForPage();
        Dimension dimension2 = new Dimension(dimension);
        if (!this.preferPageSize) {
            dimension2.width += 2 * this.getHorizontalPageBorder();
            dimension2.height += 2 * this.getVerticalPageBorder();
        }
        double d2 = Math.max((double)dimension2.width, (double)(this.getViewport().getWidth() - 8) / d);
        double d3 = Math.max((double)dimension2.height, (double)(this.getViewport().getHeight() - 8) / d);
        double d4 = Math.max(0.0, (d2 - (double)dimension.width) / 2.0);
        double d5 = Math.max(0.0, (d3 - (double)dimension.height) / 2.0);
        return new mxPoint(d4, d5);
    }

    public void zoomAndCenter() {
        if (this.zoomPolicy != 0) {
            this.zoom(this.zoomPolicy == 1, this.centerOnResize || this.zoomPolicy == 1);
            this.centerOnResize = false;
        } else if (this.pageVisible && this.centerPage) {
            mxPoint mxPoint2 = this.getPageTranslate(this.graph.getView().getScale());
            this.graph.getView().setTranslate(mxPoint2);
        } else {
            this.getGraphControl().updatePreferredSize();
        }
    }

    public void zoomIn() {
        this.zoom(this.zoomFactor);
    }

    public void zoomOut() {
        this.zoom(1.0 / this.zoomFactor);
    }

    public void zoom(double d) {
        mxGraphView mxGraphView2 = this.graph.getView();
        double d2 = (double)((int)(mxGraphView2.getScale() * 100.0 * d)) / 100.0;
        if (d2 != mxGraphView2.getScale() && d2 > 0.04) {
            mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(d2) : new mxPoint();
            this.graph.getView().scaleAndTranslate(d2, mxPoint2.getX(), mxPoint2.getY());
            if (this.keepSelectionVisibleOnZoom && !this.graph.isSelectionEmpty()) {
                this.getGraphControl().scrollRectToVisible(mxGraphView2.getBoundingBox(this.graph.getSelectionCells()).getRectangle());
            } else {
                this.maintainScrollBar(true, d, this.centerZoom);
                this.maintainScrollBar(false, d, this.centerZoom);
            }
        }
    }

    public void zoomTo(final double d, final boolean bl) {
        mxGraphView mxGraphView2 = this.graph.getView();
        final double d2 = mxGraphView2.getScale();
        mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(d) : new mxPoint();
        this.graph.getView().scaleAndTranslate(d, mxPoint2.getX(), mxPoint2.getY());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mxGraphComponent.this.maintainScrollBar(true, d / d2, bl);
                mxGraphComponent.this.maintainScrollBar(false, d / d2, bl);
            }
        });
    }

    public void zoomActual() {
        mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(1.0) : new mxPoint();
        this.graph.getView().scaleAndTranslate(1.0, mxPoint2.getX(), mxPoint2.getY());
        if (this.isPageVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollBar jScrollBar;
                    Dimension dimension = mxGraphComponent.this.getPreferredSizeForPage();
                    if ((double)mxGraphComponent.this.getViewport().getWidth() > dimension.getWidth()) {
                        mxGraphComponent.this.scrollToCenter(true);
                    } else {
                        jScrollBar = mxGraphComponent.this.getHorizontalScrollBar();
                        if (jScrollBar != null) {
                            jScrollBar.setValue(jScrollBar.getMaximum() / 3 - 4);
                        }
                    }
                    if ((double)mxGraphComponent.this.getViewport().getHeight() > dimension.getHeight()) {
                        mxGraphComponent.this.scrollToCenter(false);
                    } else {
                        jScrollBar = mxGraphComponent.this.getVerticalScrollBar();
                        if (jScrollBar != null) {
                            jScrollBar.setValue(jScrollBar.getMaximum() / 4 - 4);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(final boolean bl, final boolean bl2) {
        if (this.pageVisible && !this.zooming) {
            this.zooming = true;
            try {
                int n = this.getPageShadowColor() != null ? 8 : 0;
                double d = this.getViewport().getWidth() - n;
                double d2 = this.getViewport().getHeight() - n;
                Dimension dimension = this.getPreferredSizeForPage();
                double d3 = dimension.width;
                double d4 = dimension.height;
                double d5 = d / d3;
                double d6 = bl ? d2 / d4 : d5;
                double d7 = (double)((int)(Math.min(d5, d6) * 20.0)) / 20.0;
                if (d7 > 0.0) {
                    mxGraphView mxGraphView2 = this.graph.getView();
                    double d8 = mxGraphView2.getScale();
                    mxPoint mxPoint2 = this.centerPage ? this.getPageTranslate(d7) : new mxPoint();
                    mxGraphView2.scaleAndTranslate(d7, mxPoint2.getX(), mxPoint2.getY());
                    final double d9 = d7 / d8;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bl2) {
                                if (bl) {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.scrollToCenter(false);
                                } else {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.maintainScrollBar(false, d9, false);
                                }
                            } else if (d9 != 1.0) {
                                mxGraphComponent.this.maintainScrollBar(true, d9, false);
                                mxGraphComponent.this.maintainScrollBar(false, d9, false);
                            }
                        }
                    });
                }
            }
            finally {
                this.zooming = false;
            }
        }
    }

    protected void maintainScrollBar(boolean bl, double d, boolean bl2) {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = jScrollBar = bl ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (jScrollBar != null) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = (int)Math.round((double)boundedRangeModel.getValue() * d) + (int)Math.round(bl2 ? (double)boundedRangeModel.getExtent() * (d - 1.0) / 2.0 : 0.0);
            boundedRangeModel.setValue(n);
        }
    }

    public void scrollToCenter(boolean bl) {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = jScrollBar = bl ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (jScrollBar != null) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = boundedRangeModel.getMaximum() / 2 - boundedRangeModel.getExtent() / 2;
            boundedRangeModel.setValue(n);
        }
    }

    public void scrollCellToVisible(Object object) {
        this.scrollCellToVisible(object, false);
    }

    public void scrollCellToVisible(Object object, boolean bl) {
        mxCellState mxCellState2 = this.graph.getView().getState(object);
        if (mxCellState2 != null) {
            mxRectangle mxRectangle2 = mxCellState2;
            if (bl) {
                mxRectangle2 = (mxRectangle)mxRectangle2.clone();
                mxRectangle2.setX(mxRectangle2.getCenterX() - (double)(this.getWidth() / 2));
                mxRectangle2.setWidth(this.getWidth());
                mxRectangle2.setY(mxRectangle2.getCenterY() - (double)(this.getHeight() / 2));
                mxRectangle2.setHeight(this.getHeight());
            }
            this.getGraphControl().scrollRectToVisible(mxRectangle2.getRectangle());
        }
    }

    public Object getCellAt(int n, int n2) {
        return this.getCellAt(n, n2, true);
    }

    public Object getCellAt(int n, int n2, boolean bl) {
        return this.getCellAt(n, n2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellAt(int n, int n2, boolean bl, Object object) {
        if (object == null) {
            object = this.graph.getDefaultParent();
        }
        if (object != null) {
            mxPoint mxPoint2 = this.canvas.getTranslate();
            double d = this.canvas.getScale();
            try {
                this.canvas.setScale(this.graph.getView().getScale());
                this.canvas.setTranslate(0.0, 0.0);
                mxIGraphModel mxIGraphModel2 = this.graph.getModel();
                mxGraphView mxGraphView2 = this.graph.getView();
                Rectangle rectangle = new Rectangle(n, n2, 1, 1);
                int n3 = mxIGraphModel2.getChildCount(object);
                for (int i = n3 - 1; i >= 0; --i) {
                    Object object2;
                    Object object3 = mxIGraphModel2.getChildAt(object, i);
                    Object object4 = this.getCellAt(n, n2, bl, object3);
                    if (object4 != null) {
                        object2 = object4;
                        return object2;
                    }
                    if (!this.graph.isCellVisible(object3) || (object2 = mxGraphView2.getState(object3)) == null || !this.canvas.intersects(this, rectangle, (mxCellState)object2) || this.graph.isSwimlane(object3) && !bl && (!this.transparentSwimlaneContent || this.canvas.hitSwimlaneContent(this, (mxCellState)object2, n, n2))) continue;
                    Object object5 = object3;
                    return object5;
                }
            }
            finally {
                this.canvas.setScale(d);
                this.canvas.setTranslate((int)mxPoint2.getX(), (int)mxPoint2.getY());
            }
        }
        return null;
    }

    public void setSwimlaneSelectionEnabled(boolean bl) {
        boolean bl2 = this.swimlaneSelectionEnabled;
        this.swimlaneSelectionEnabled = bl;
        this.firePropertyChange("swimlaneSelectionEnabled", bl2, this.swimlaneSelectionEnabled);
    }

    public boolean isSwimlaneSelectionEnabled() {
        return this.swimlaneSelectionEnabled;
    }

    public Object[] selectRegion(Rectangle rectangle, MouseEvent mouseEvent) {
        Object[] objectArray = this.getCells(rectangle);
        if (objectArray.length > 0) {
            this.selectCellsForEvent(objectArray, mouseEvent);
        } else if (!this.graph.isSelectionEmpty() && !mouseEvent.isConsumed()) {
            this.graph.clearSelection();
        }
        return objectArray;
    }

    public Object[] getCells(Rectangle rectangle) {
        return this.getCells(rectangle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCells(Rectangle rectangle, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (rectangle.width > 0 || rectangle.height > 0) {
            if (object == null) {
                object = this.graph.getDefaultParent();
            }
            if (object != null) {
                mxPoint mxPoint2 = this.canvas.getTranslate();
                double d = this.canvas.getScale();
                try {
                    this.canvas.setScale(this.graph.getView().getScale());
                    this.canvas.setTranslate(0.0, 0.0);
                    mxIGraphModel mxIGraphModel2 = this.graph.getModel();
                    mxGraphView mxGraphView2 = this.graph.getView();
                    int n = mxIGraphModel2.getChildCount(object);
                    for (int i = 0; i < n; ++i) {
                        Object object2 = mxIGraphModel2.getChildAt(object, i);
                        mxCellState mxCellState2 = mxGraphView2.getState(object2);
                        if (!this.graph.isCellVisible(object2) || mxCellState2 == null) continue;
                        if (this.canvas.contains(this, rectangle, mxCellState2)) {
                            arrayList.add(object2);
                            continue;
                        }
                        arrayList.addAll(Arrays.asList(this.getCells(rectangle, object2)));
                    }
                }
                finally {
                    this.canvas.setScale(d);
                    this.canvas.setTranslate(mxPoint2.getX(), mxPoint2.getY());
                }
            }
        }
        return arrayList.toArray();
    }

    public void selectCellsForEvent(Object[] objectArray, MouseEvent mouseEvent) {
        if (this.isToggleEvent(mouseEvent)) {
            this.graph.addSelectionCells(objectArray);
        } else {
            this.graph.setSelectionCells(objectArray);
        }
    }

    public void selectCellForEvent(Object object, MouseEvent mouseEvent) {
        boolean bl = this.graph.isCellSelected(object);
        if (this.isToggleEvent(mouseEvent)) {
            if (bl) {
                this.graph.removeSelectionCell(object);
            } else {
                this.graph.addSelectionCell(object);
            }
        } else if (!bl || this.graph.getSelectionCount() != 1) {
            this.graph.setSelectionCell(object);
        }
    }

    public boolean isSignificant(double d, double d2) {
        return Math.abs(d) > (double)this.tolerance || Math.abs(d2) > (double)this.tolerance;
    }

    public ImageIcon getFoldingIcon(mxCellState mxCellState2) {
        boolean bl;
        Object object;
        if (mxCellState2 != null && this.isFoldingEnabled() && !this.getGraph().getModel().isEdge(mxCellState2.getCell()) && this.graph.isCellFoldable(object, !(bl = this.graph.isCellCollapsed(object = mxCellState2.getCell())))) {
            return bl ? this.collapsedIcon : this.expandedIcon;
        }
        return null;
    }

    public Rectangle getFoldingIconBounds(mxCellState mxCellState2, ImageIcon imageIcon) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        boolean bl = mxIGraphModel2.isEdge(mxCellState2.getCell());
        double d = this.getGraph().getView().getScale();
        int n = (int)Math.round(mxCellState2.getX() + 4.0 * d);
        int n2 = (int)Math.round(mxCellState2.getY() + 4.0 * d);
        int n3 = (int)Math.max(8.0, (double)imageIcon.getIconWidth() * d);
        int n4 = (int)Math.max(8.0, (double)imageIcon.getIconHeight() * d);
        if (bl) {
            mxPoint mxPoint2 = this.graph.getView().getPoint(mxCellState2);
            n = (int)mxPoint2.getX() - n3 / 2;
            n2 = (int)mxPoint2.getY() - n4 / 2;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean hitFoldingIcon(Object object, int n, int n2) {
        if (object != null) {
            ImageIcon imageIcon;
            mxCellState mxCellState2;
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            boolean bl = mxIGraphModel2.isEdge(object);
            if (this.foldingEnabled && (mxIGraphModel2.isVertex(object) || bl) && (mxCellState2 = this.graph.getView().getState(object)) != null && (imageIcon = this.getFoldingIcon(mxCellState2)) != null) {
                return this.getFoldingIconBounds(mxCellState2, imageIcon).contains(n, n2);
            }
        }
        return false;
    }

    public void setToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this.graphControl);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.graphControl);
        }
    }

    public boolean isConnectable() {
        return this.connectionHandler.isEnabled();
    }

    public void setConnectable(boolean bl) {
        this.connectionHandler.setEnabled(bl);
    }

    public boolean isPanning() {
        return this.panningHandler.isEnabled();
    }

    public void setPanning(boolean bl) {
        this.panningHandler.setEnabled(bl);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean bl) {
        this.autoScroll = bl;
    }

    public boolean isAutoExtend() {
        return this.autoExtend;
    }

    public void setAutoExtend(boolean bl) {
        this.autoExtend = bl;
    }

    public boolean isEscapeEnabled() {
        return this.escapeEnabled;
    }

    public void setEscapeEnabled(boolean bl) {
        boolean bl2 = this.escapeEnabled;
        this.escapeEnabled = bl;
        this.firePropertyChange("escapeEnabled", bl2, this.escapeEnabled);
    }

    public boolean isInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange("invokesStopCellEditing", bl2, this.invokesStopCellEditing);
    }

    public boolean isEnterStopsCellEditing() {
        return this.enterStopsCellEditing;
    }

    public void setEnterStopsCellEditing(boolean bl) {
        boolean bl2 = this.enterStopsCellEditing;
        this.enterStopsCellEditing = bl;
        this.firePropertyChange("enterStopsCellEditing", bl2, this.enterStopsCellEditing);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        boolean bl2 = this.dragEnabled;
        this.dragEnabled = bl;
        this.firePropertyChange("dragEnabled", bl2, this.dragEnabled);
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        boolean bl2 = this.gridVisible;
        this.gridVisible = bl;
        this.firePropertyChange("gridVisible", bl2, this.gridVisible);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        boolean bl2 = this.antiAlias;
        this.antiAlias = bl;
        this.firePropertyChange("antiAlias", bl2, this.antiAlias);
    }

    public boolean isTextAntiAlias() {
        return this.antiAlias;
    }

    public void setTextAntiAlias(boolean bl) {
        boolean bl2 = this.textAntiAlias;
        this.textAntiAlias = bl;
        this.firePropertyChange("textAntiAlias", bl2, this.textAntiAlias);
    }

    public float getPreviewAlpha() {
        return this.previewAlpha;
    }

    public void setPreviewAlpha(float f) {
        float f2 = this.previewAlpha;
        this.previewAlpha = f;
        this.firePropertyChange("previewAlpha", f2, this.previewAlpha);
    }

    public boolean isTripleBuffered() {
        return this.tripleBuffered;
    }

    public boolean isForceTripleBuffered() {
        return false;
    }

    public void setTripleBuffered(boolean bl) {
        boolean bl2 = this.tripleBuffered;
        this.tripleBuffered = bl;
        this.firePropertyChange("tripleBuffered", bl2, this.tripleBuffered);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, this.gridColor);
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(int n) {
        int n2 = this.gridStyle;
        this.gridStyle = n;
        this.firePropertyChange("gridStyle", n2, this.gridStyle);
    }

    public boolean isImportEnabled() {
        return this.importEnabled;
    }

    public void setImportEnabled(boolean bl) {
        boolean bl2 = this.importEnabled;
        this.importEnabled = bl;
        this.firePropertyChange("importEnabled", bl2, this.importEnabled);
    }

    public Object[] getImportableCells(Object[] objectArray) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraphComponent.this.canImportCell(object);
            }
        });
    }

    public boolean canImportCell(Object object) {
        return this.isImportEnabled();
    }

    public boolean isExportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(boolean bl) {
        boolean bl2 = this.exportEnabled;
        this.exportEnabled = bl;
        this.firePropertyChange("exportEnabled", bl2, this.exportEnabled);
    }

    public Object[] getExportableCells(Object[] objectArray) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraphComponent.this.canExportCell(object);
            }
        });
    }

    public boolean canExportCell(Object object) {
        return this.isExportEnabled();
    }

    public boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    public void setFoldingEnabled(boolean bl) {
        boolean bl2 = this.foldingEnabled;
        this.foldingEnabled = bl;
        this.firePropertyChange("foldingEnabled", bl2, this.foldingEnabled);
    }

    public boolean isEditEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.getClickCount() == 2 : false;
    }

    public boolean isCloneEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isControlDown() : false;
    }

    public boolean isToggleEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? (mxUtils.IS_MAC ? SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isMetaDown() || SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isControlDown() : mouseEvent.isControlDown()) : false;
    }

    public boolean isGridEnabledEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? !mouseEvent.isAltDown() : false;
    }

    public boolean isPanningEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isShiftDown() && mouseEvent.isControlDown() : false;
    }

    public boolean isConstrainedEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isShiftDown() : false;
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isAltDown() : false;
    }

    public mxPoint snapScaledPoint(mxPoint mxPoint2) {
        return this.snapScaledPoint(mxPoint2, 0.0, 0.0);
    }

    public mxPoint snapScaledPoint(mxPoint mxPoint2, double d, double d2) {
        if (mxPoint2 != null) {
            double d3 = this.graph.getView().getScale();
            mxPoint mxPoint3 = this.graph.getView().getTranslate();
            mxPoint2.setX((this.graph.snap(mxPoint2.getX() / d3 - mxPoint3.getX() + d / d3) + mxPoint3.getX()) * d3 - d);
            mxPoint2.setY((this.graph.snap(mxPoint2.getY() / d3 - mxPoint3.getY() + d2 / d3) + mxPoint3.getY()) * d3 - d2);
        }
        return mxPoint2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = 1;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        mxGraphView mxGraphView2 = this.graph.getView();
        boolean bl = mxGraphView2.isEventsEnabled();
        mxPoint mxPoint2 = mxGraphView2.getTranslate();
        mxGraphView2.setEventsEnabled(false);
        mxTemporaryCellStates mxTemporaryCellStates2 = new mxTemporaryCellStates(mxGraphView2, 1.0 / this.pageScale);
        try {
            mxGraphView2.setTranslate(new mxPoint(0.0, 0.0));
            mxInteractiveCanvas mxInteractiveCanvas2 = this.createCanvas();
            mxInteractiveCanvas2.setGraphics((Graphics2D)graphics);
            mxInteractiveCanvas2.setScale(1.0 / this.pageScale);
            mxGraphView2.revalidate();
            mxRectangle mxRectangle2 = this.graph.getGraphBounds();
            Dimension dimension = new Dimension((int)Math.ceil(mxRectangle2.getX() + mxRectangle2.getWidth()) + 1, (int)Math.ceil(mxRectangle2.getY() + mxRectangle2.getHeight()) + 1);
            int n3 = (int)pageFormat.getImageableWidth();
            int n4 = (int)pageFormat.getImageableHeight();
            int n5 = (int)Math.max(Math.ceil((double)(dimension.width - 5) / (double)n3), 1.0);
            int n6 = (int)Math.max(Math.ceil((double)(dimension.height - 5) / (double)n4), 1.0);
            if (n < n5 * n6) {
                int n7 = (int)((double)(n % n5) * pageFormat.getImageableWidth());
                int n8 = (int)(Math.floor(n / n5) * pageFormat.getImageableHeight());
                graphics.translate(-n7 + (int)pageFormat.getImageableX(), -n8 + (int)pageFormat.getImageableY());
                graphics.setClip(n7, n8, (int)((double)n7 + pageFormat.getWidth()), (int)((double)n8 + pageFormat.getHeight()));
                this.graph.drawGraph(mxInteractiveCanvas2);
                n2 = 0;
            }
        }
        finally {
            mxGraphView2.setTranslate(mxPoint2);
            mxTemporaryCellStates2.destroy();
            mxGraphView2.setEventsEnabled(bl);
            repaintManager.setDoubleBufferingEnabled(true);
        }
        return n2;
    }

    public mxInteractiveCanvas getCanvas() {
        return this.canvas;
    }

    public BufferedImage getTripleBuffer() {
        return this.tripleBuffer;
    }

    public mxInteractiveCanvas createCanvas() {
        return new mxInteractiveCanvas();
    }

    public mxCellHandler createHandler(mxCellState mxCellState2) {
        if (this.graph.getModel().isVertex(mxCellState2.getCell())) {
            return new mxVertexHandler(this, mxCellState2);
        }
        if (this.graph.getModel().isEdge(mxCellState2.getCell())) {
            mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction2 = this.graph.getView().getEdgeStyle(mxCellState2, null, null, null);
            if (this.graph.isLoop(mxCellState2) || mxEdgeStyleFunction2 == mxEdgeStyle.ElbowConnector || mxEdgeStyleFunction2 == mxEdgeStyle.SideToSide || mxEdgeStyleFunction2 == mxEdgeStyle.TopToBottom) {
                return new mxElbowEdgeHandler(this, mxCellState2);
            }
            return new mxEdgeHandler(this, mxCellState2);
        }
        return new mxCellHandler(this, mxCellState2);
    }

    public Component[] createComponents(mxCellState mxCellState2) {
        return null;
    }

    public void insertComponent(mxCellState mxCellState2, Component component) {
        this.getGraphControl().add(component, 0);
    }

    public void removeComponent(Component component, Object object) {
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
    }

    public void updateComponent(mxCellState mxCellState2, Component component) {
        int n = (int)mxCellState2.getX();
        int n2 = (int)mxCellState2.getY();
        int n3 = (int)mxCellState2.getWidth();
        int n4 = (int)mxCellState2.getHeight();
        Dimension dimension = component.getMinimumSize();
        if (dimension.width > n3) {
            n -= (dimension.width - n3) / 2;
            n3 = dimension.width;
        }
        if (dimension.height > n4) {
            n2 -= (dimension.height - n4) / 2;
            n4 = dimension.height;
        }
        component.setBounds(n, n2, n3, n4);
    }

    public void updateComponents() {
        Object object = this.graph.getModel().getRoot();
        Hashtable<Object, Component[]> hashtable = this.updateComponents(object);
        this.removeAllComponents(this.components);
        this.components = hashtable;
        if (!this.overlays.isEmpty()) {
            Hashtable<Object, mxICellOverlay[]> hashtable2 = this.updateCellOverlays(object);
            this.removeAllOverlays(this.overlays);
            this.overlays = hashtable2;
        }
    }

    public void removeAllComponents(Hashtable<Object, Component[]> hashtable) {
        for (Map.Entry<Object, Component[]> entry : hashtable.entrySet()) {
            Component[] componentArray = entry.getValue();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeComponent(componentArray[i], entry.getKey());
            }
        }
    }

    public void removeAllOverlays(Hashtable<Object, mxICellOverlay[]> hashtable) {
        for (Map.Entry<Object, mxICellOverlay[]> entry : hashtable.entrySet()) {
            mxICellOverlay[] mxICellOverlayArray = entry.getValue();
            for (int i = 0; i < mxICellOverlayArray.length; ++i) {
                this.removeCellOverlayComponent(mxICellOverlayArray[i], entry.getKey());
            }
        }
    }

    public Hashtable<Object, Component[]> updateComponents(Object object) {
        int n;
        Hashtable<Object, Component[]> hashtable = new Hashtable<Object, Component[]>();
        Component[] componentArray = this.components.remove(object);
        mxCellState mxCellState2 = this.getGraph().getView().getState(object);
        if (mxCellState2 != null) {
            if (componentArray == null && (componentArray = this.createComponents(mxCellState2)) != null) {
                for (n = 0; n < componentArray.length; ++n) {
                    this.insertComponent(mxCellState2, componentArray[n]);
                }
            }
            if (componentArray != null) {
                hashtable.put(object, componentArray);
                for (n = 0; n < componentArray.length; ++n) {
                    this.updateComponent(mxCellState2, componentArray[n]);
                }
            }
        } else if (componentArray != null) {
            this.components.put(object, componentArray);
        }
        n = this.getGraph().getModel().getChildCount(object);
        for (int i = 0; i < n; ++i) {
            hashtable.putAll(this.updateComponents(this.getGraph().getModel().getChildAt(object, i)));
        }
        return hashtable;
    }

    public String validateGraph() {
        return this.validateGraph(this.graph.getModel().getRoot(), new Hashtable<Object, Object>());
    }

    public String validateGraph(Object object, Hashtable<Object, Object> hashtable) {
        Object object2;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxGraphView mxGraphView2 = this.graph.getView();
        boolean bl = true;
        int n = mxIGraphModel2.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            String string;
            object2 = mxIGraphModel2.getChildAt(object, i);
            Hashtable<Object, Object> hashtable2 = hashtable;
            if (this.graph.isValidRoot(object2)) {
                hashtable2 = new Hashtable();
            }
            if ((string = this.validateGraph(object2, hashtable2)) != null) {
                String string2 = string.replaceAll("\n", "<br>");
                int n2 = string2.length();
                this.setCellWarning(object2, string2.substring(0, Math.max(0, n2 - 4)));
            } else {
                this.setCellWarning(object2, null);
            }
            bl = bl && string == null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.graph.isCellCollapsed(object) && !bl) {
            stringBuffer.append(mxResources.get("containsValidationErrors", "Contains Validation Errors") + "\n");
        }
        if (mxIGraphModel2.isEdge(object)) {
            object2 = this.graph.getEdgeValidationError(object, mxIGraphModel2.getTerminal(object, true), mxIGraphModel2.getTerminal(object, false));
            if (object2 != null) {
                stringBuffer.append((String)object2);
            }
        } else {
            object2 = this.graph.getCellValidationError(object);
            if (object2 != null) {
                stringBuffer.append((String)object2);
            }
        }
        object2 = this.graph.validateCell(object, hashtable);
        if (object2 != null) {
            stringBuffer.append((String)object2);
        }
        if (mxIGraphModel2.getParent(object) == null) {
            mxGraphView2.validate();
        }
        return stringBuffer.length() > 0 || !bl ? stringBuffer.toString() : null;
    }

    public mxICellOverlay addCellOverlay(Object object, mxICellOverlay mxICellOverlay2) {
        Object object2;
        mxICellOverlay[] mxICellOverlayArray = this.getCellOverlays(object);
        if (mxICellOverlayArray == null) {
            mxICellOverlayArray = new mxICellOverlay[]{mxICellOverlay2};
        } else {
            object2 = new mxICellOverlay[mxICellOverlayArray.length + 1];
            System.arraycopy(mxICellOverlayArray, 0, object2, 0, mxICellOverlayArray.length);
            object2[mxICellOverlayArray.length] = mxICellOverlay2;
            mxICellOverlayArray = object2;
        }
        this.overlays.put(object, mxICellOverlayArray);
        object2 = this.graph.getView().getState(object);
        if (object2 != null) {
            this.updateCellOverlayComponent((mxCellState)object2, mxICellOverlay2);
        }
        this.eventSource.fireEvent(new mxEventObject("addOverlay", "cell", object, "overlay", mxICellOverlay2));
        return mxICellOverlay2;
    }

    public mxICellOverlay[] getCellOverlays(Object object) {
        return this.overlays.get(object);
    }

    public mxICellOverlay removeCellOverlay(Object object, mxICellOverlay mxICellOverlay2) {
        if (mxICellOverlay2 == null) {
            this.removeCellOverlays(object);
        } else {
            mxICellOverlay[] mxICellOverlayArray = this.getCellOverlays(object);
            if (mxICellOverlayArray != null) {
                ArrayList<mxICellOverlay> arrayList = new ArrayList<mxICellOverlay>(Arrays.asList(mxICellOverlayArray));
                if (arrayList.remove(mxICellOverlay2)) {
                    this.removeCellOverlayComponent(mxICellOverlay2, object);
                }
                mxICellOverlayArray = arrayList.toArray(new mxICellOverlay[arrayList.size()]);
                this.overlays.put(object, mxICellOverlayArray);
            }
        }
        return mxICellOverlay2;
    }

    public mxICellOverlay[] removeCellOverlays(Object object) {
        mxICellOverlay[] mxICellOverlayArray = this.overlays.remove(object);
        if (mxICellOverlayArray != null) {
            for (int i = 0; i < mxICellOverlayArray.length; ++i) {
                this.removeCellOverlayComponent(mxICellOverlayArray[i], object);
            }
        }
        return mxICellOverlayArray;
    }

    protected void removeCellOverlayComponent(mxICellOverlay mxICellOverlay2, Object object) {
        Component component;
        if (mxICellOverlay2 instanceof Component && (component = (Component)((Object)mxICellOverlay2)).getParent() != null) {
            component.setVisible(false);
            component.getParent().remove(component);
            this.eventSource.fireEvent(new mxEventObject("removeOverlay", "cell", object, "overlay", mxICellOverlay2));
        }
    }

    protected void updateCellOverlayComponent(mxCellState mxCellState2, mxICellOverlay mxICellOverlay2) {
        if (mxICellOverlay2 instanceof Component) {
            mxRectangle mxRectangle2;
            Component component = (Component)((Object)mxICellOverlay2);
            if (component.getParent() == null) {
                this.getGraphControl().add(component, 0);
            }
            if ((mxRectangle2 = mxICellOverlay2.getBounds(mxCellState2)) != null) {
                component.setBounds(mxRectangle2.getRectangle());
                component.setVisible(true);
            } else {
                component.setVisible(false);
            }
        }
    }

    public void clearCellOverlays() {
        this.clearCellOverlays(null);
    }

    public void clearCellOverlays(Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        if (object == null) {
            object = mxIGraphModel2.getRoot();
        }
        this.removeCellOverlays(object);
        int n = mxIGraphModel2.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = mxIGraphModel2.getChildAt(object, i);
            this.clearCellOverlays(object2);
        }
    }

    public mxICellOverlay setCellWarning(Object object, String string) {
        return this.setCellWarning(object, string, null, false);
    }

    public mxICellOverlay setCellWarning(Object object, String string, ImageIcon imageIcon) {
        return this.setCellWarning(object, string, imageIcon, false);
    }

    public mxICellOverlay setCellWarning(final Object object, String string, ImageIcon imageIcon, boolean bl) {
        if (string != null && string.length() > 0) {
            imageIcon = imageIcon != null ? imageIcon : this.warningIcon;
            mxCellOverlay mxCellOverlay2 = new mxCellOverlay(imageIcon, string);
            if (bl) {
                mxCellOverlay2.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (mxGraphComponent.this.getGraph().isEnabled()) {
                            mxGraphComponent.this.getGraph().setSelectionCell(object);
                        }
                    }
                });
                mxCellOverlay2.setCursor(new Cursor(12));
            }
            return this.addCellOverlay(object, mxCellOverlay2);
        }
        this.removeCellOverlays(object);
        return null;
    }

    public Hashtable<Object, mxICellOverlay[]> updateCellOverlays(Object object) {
        int n;
        Hashtable<Object, mxICellOverlay[]> hashtable = new Hashtable<Object, mxICellOverlay[]>();
        mxICellOverlay[] mxICellOverlayArray = this.overlays.remove(object);
        mxCellState mxCellState2 = this.getGraph().getView().getState(object);
        if (mxICellOverlayArray != null) {
            if (mxCellState2 != null) {
                for (n = 0; n < mxICellOverlayArray.length; ++n) {
                    this.updateCellOverlayComponent(mxCellState2, mxICellOverlayArray[n]);
                }
            } else {
                for (n = 0; n < mxICellOverlayArray.length; ++n) {
                    this.removeCellOverlayComponent(mxICellOverlayArray[n], object);
                }
            }
            hashtable.put(object, mxICellOverlayArray);
        }
        n = this.getGraph().getModel().getChildCount(object);
        for (int i = 0; i < n; ++i) {
            hashtable.putAll(this.updateCellOverlays(this.getGraph().getModel().getChildAt(object, i)));
        }
        return hashtable;
    }

    protected void paintBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.paintBackgroundPage(graphics);
        if (this.isPageVisible()) {
            graphics.clipRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 1, rectangle2.height - 1);
        }
        this.paintBackgroundImage(graphics);
        this.paintGrid(graphics);
        graphics.setClip(rectangle);
    }

    protected Rectangle paintBackgroundPage(Graphics graphics) {
        Object object;
        Object object2;
        mxPoint mxPoint2 = this.graph.getView().getTranslate();
        double d = this.graph.getView().getScale();
        int n = (int)Math.round(mxPoint2.getX() * d) - 1;
        int n2 = (int)Math.round(mxPoint2.getY() * d) - 1;
        Dimension dimension = this.getPreferredSizeForPage();
        int n3 = (int)Math.round((double)dimension.width * d) + 2;
        int n4 = (int)Math.round((double)dimension.height * d) + 2;
        if (this.isPageVisible()) {
            object2 = this.getPageBackgroundColor();
            if (object2 != null) {
                graphics.setColor((Color)object2);
                mxUtils.fillClippedRect(graphics, 0, 0, this.getGraphControl().getWidth(), this.getGraphControl().getHeight());
            }
            if ((object2 = this.getPageShadowColor()) != null) {
                graphics.setColor((Color)object2);
                mxUtils.fillClippedRect(graphics, n + n3, n2 + 6, 6, n4 - 6);
                mxUtils.fillClippedRect(graphics, n + 8, n2 + n4, n3 - 2, 6);
            }
            object = this.getBackground();
            if (this.getViewport().isOpaque()) {
                object = this.getViewport().getBackground();
            }
            graphics.setColor((Color)object);
            mxUtils.fillClippedRect(graphics, n + 1, n2 + 1, n3, n4);
            object2 = this.getPageBorderColor();
            if (object2 != null) {
                graphics.setColor((Color)object2);
                graphics.drawRect(n, n2, n3, n4);
            }
        }
        if (this.isPageBreaksVisible() && (this.horizontalPageCount > 1 || this.verticalPageCount > 1)) {
            int n5;
            int n6;
            object2 = (Graphics2D)graphics;
            object = ((Graphics2D)object2).getStroke();
            ((Graphics2D)object2).setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            ((Graphics)object2).setColor(this.pageBreakColor);
            for (n6 = 1; n6 <= this.horizontalPageCount - 1; ++n6) {
                n5 = n6 * n3 / this.horizontalPageCount;
                ((Graphics)object2).drawLine(n + n5, n2 + 1, n + n5, n2 + n4);
            }
            for (n6 = 1; n6 <= this.verticalPageCount - 1; ++n6) {
                n5 = n6 * n4 / this.verticalPageCount;
                ((Graphics)object2).drawLine(n + 1, n2 + n5, n + n3, n2 + n5);
            }
            ((Graphics2D)object2).setStroke((Stroke)object);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected void paintBackgroundImage(Graphics graphics) {
        if (this.backgroundImage != null) {
            mxPoint mxPoint2 = this.graph.getView().getTranslate();
            double d = this.graph.getView().getScale();
            graphics.drawImage(this.backgroundImage.getImage(), (int)(mxPoint2.getX() * d), (int)(mxPoint2.getY() * d), (int)((double)this.backgroundImage.getIconWidth() * d), (int)((double)this.backgroundImage.getIconHeight() * d), this);
        }
    }

    protected void paintGrid(Graphics graphics) {
        if (this.isGridVisible()) {
            int n;
            graphics.setColor(this.getGridColor());
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = this.getGraphControl().getBounds();
            }
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = d + rectangle.getWidth();
            double d4 = d2 + rectangle.getHeight();
            int n2 = this.getGridStyle();
            int n3 = n = this.graph.getGridSize();
            if (n2 == 1 || n2 == 0) {
                n3 /= 2;
            }
            mxPoint mxPoint2 = this.graph.getView().getTranslate();
            double d5 = this.graph.getView().getScale();
            double d6 = mxPoint2.getX() * d5;
            double d7 = mxPoint2.getY() * d5;
            double d8 = (double)n * d5;
            if (d8 < (double)n3) {
                int n4 = (int)Math.round(Math.ceil((double)n3 / d8) / 2.0) * 2;
                d8 = (double)n4 * d8;
            }
            double d9 = Math.floor((d - d6) / d8) * d8 + d6;
            double d10 = Math.ceil(d3 / d8) * d8;
            double d11 = Math.floor((d2 - d7) / d8) * d8 + d7;
            double d12 = Math.ceil(d4 / d8) * d8;
            switch (n2) {
                case 1: {
                    int n5 = d8 > 16.0 ? 2 : 1;
                    for (double d13 = d9; d13 <= d10; d13 += d8) {
                        for (double d14 = d11; d14 <= d12; d14 += d8) {
                            d13 = (double)Math.round((d13 - d6) / d8) * d8 + d6;
                            d14 = (double)Math.round((d14 - d7) / d8) * d8 + d7;
                            int n6 = (int)Math.round(d13);
                            int n7 = (int)Math.round(d14);
                            graphics.drawLine(n6 - n5, n7, n6 + n5, n7);
                            graphics.drawLine(n6, n7 - n5, n6, n7 + n5);
                        }
                    }
                    break;
                }
                case 2: {
                    int n8;
                    double d15;
                    int n9 = (int)Math.round(d9);
                    int n10 = (int)Math.round(d10 += (double)((int)Math.ceil(d8)));
                    int n11 = (int)Math.round(d11);
                    int n12 = (int)Math.round(d12 += (double)((int)Math.ceil(d8)));
                    for (d15 = d9; d15 <= d10; d15 += d8) {
                        d15 = (double)Math.round((d15 - d6) / d8) * d8 + d6;
                        n8 = (int)Math.round(d15);
                        graphics.drawLine(n8, n11, n8, n12);
                    }
                    for (d15 = d11; d15 <= d12; d15 += d8) {
                        d15 = (double)Math.round((d15 - d7) / d8) * d8 + d7;
                        n8 = (int)Math.round(d15);
                        graphics.drawLine(n9, n8, n10, n8);
                    }
                    break;
                }
                case 3: {
                    int n13;
                    double d16;
                    double d17;
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Stroke stroke = graphics2D.getStroke();
                    int n14 = (int)Math.round(d9);
                    int n15 = (int)Math.round(d10 += (double)((int)Math.ceil(d8)));
                    int n16 = (int)Math.round(d11);
                    int n17 = (int)Math.round(d12 += (double)((int)Math.ceil(d8)));
                    Stroke[] strokeArray = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, n16) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n16) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n16) % 4)};
                    for (d17 = d9; d17 <= d10; d17 += d8) {
                        graphics2D.setStroke(strokeArray[(int)(d17 / d8) % strokeArray.length]);
                        d16 = (double)Math.round((d17 - d6) / d8) * d8 + d6;
                        n13 = (int)Math.round(d16);
                        graphics.drawLine(n13, n16, n13, n17);
                    }
                    strokeArray = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, n14) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n14) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n14) % 4)};
                    for (d17 = d11; d17 <= d12; d17 += d8) {
                        graphics2D.setStroke(strokeArray[(int)(d17 / d8) % strokeArray.length]);
                        d16 = (double)Math.round((d17 - d7) / d8) * d8 + d7;
                        n13 = (int)Math.round(d16);
                        graphics.drawLine(n14, n13, n15, n13);
                    }
                    graphics2D.setStroke(stroke);
                    break;
                }
                default: {
                    for (double d18 = d9; d18 <= d10; d18 += d8) {
                        for (double d19 = d11; d19 <= d12; d19 += d8) {
                            d18 = (double)Math.round((d18 - d6) / d8) * d8 + d6;
                            d19 = (double)Math.round((d19 - d7) / d8) * d8 + d7;
                            int n18 = (int)Math.round(d18);
                            int n19 = (int)Math.round(d19);
                            graphics.drawLine(n18, n19, n18, n19);
                        }
                    }
                }
            }
        }
    }

    public void redraw(mxCellState mxCellState2) {
        if (mxCellState2 != null) {
            Rectangle rectangle = mxCellState2.getBoundingBox().getRectangle();
            this.repaintTripleBuffer(new Rectangle(rectangle));
            rectangle = SwingUtilities.convertRectangle(this.graphControl, rectangle, this);
            this.repaint(rectangle);
        }
    }

    public void checkTripleBuffer() {
        mxRectangle mxRectangle2 = this.graph.getGraphBounds();
        int n = (int)Math.ceil(mxRectangle2.getX() + mxRectangle2.getWidth() + 2.0);
        int n2 = (int)Math.ceil(mxRectangle2.getY() + mxRectangle2.getHeight() + 2.0);
        if (this.tripleBuffer != null && (this.tripleBuffer.getWidth() != n || this.tripleBuffer.getHeight() != n2)) {
            this.destroyTripleBuffer();
        }
        if (this.tripleBuffer == null) {
            this.createTripleBuffer(n, n2);
        }
    }

    protected void createTripleBuffer(int n, int n2) {
        try {
            this.tripleBuffer = mxUtils.createBufferedImage(n, n2, null);
            this.tripleBufferGraphics = this.tripleBuffer.createGraphics();
            mxUtils.setAntiAlias(this.tripleBufferGraphics, this.antiAlias, this.textAntiAlias);
            this.repaintTripleBuffer(null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void destroyTripleBuffer() {
        if (this.tripleBuffer != null) {
            this.tripleBuffer = null;
            this.tripleBufferGraphics.dispose();
            this.tripleBufferGraphics = null;
        }
    }

    public void repaintTripleBuffer(Rectangle rectangle) {
        if (this.tripleBuffered && this.tripleBufferGraphics != null) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.tripleBuffer.getWidth(), this.tripleBuffer.getHeight());
            }
            mxUtils.clearRect(this.tripleBufferGraphics, rectangle, null);
            this.tripleBufferGraphics.setClip(rectangle);
            this.graphControl.drawGraph(this.tripleBufferGraphics, true);
            this.tripleBufferGraphics.setClip(null);
        }
    }

    public boolean isEventsEnabled() {
        return this.eventSource.isEventsEnabled();
    }

    public void setEventsEnabled(boolean bl) {
        this.eventSource.setEventsEnabled(bl);
    }

    public void addListener(String string, mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.addListener(string, mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.removeListener(mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2, String string) {
        this.eventSource.removeListener(mxIEventListener2, string);
    }

    static {
        DEFAULT_EXPANDED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/expanded.gif"));
        DEFAULT_COLLAPSED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/collapsed.gif"));
        DEFAULT_WARNING_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/warning.gif"));
    }

    public static class mxMouseRedirector
    implements MouseListener,
    MouseMotionListener {
        protected mxGraphComponent graphComponent;

        public mxMouseRedirector(mxGraphComponent mxGraphComponent2) {
            this.graphComponent = mxGraphComponent2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.graphComponent.getGraphControl().dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.graphComponent.getGraphControl()));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }
    }

    public class mxGraphControl
    extends JComponent {
        private static final long serialVersionUID = -8916603170766739124L;
        protected Point translate = new Point(0, 0);

        public mxGraphControl() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mxGraphControl.this.translate.x != 0 || mxGraphControl.this.translate.y != 0) {
                        mxGraphControl.this.translate = new Point(0, 0);
                        mxGraphControl.this.repaint();
                    }
                }
            });
        }

        public Point getTranslate() {
            return this.translate;
        }

        public void setTranslate(Point point) {
            this.translate = point;
        }

        public mxGraphComponent getGraphContainer() {
            return mxGraphComponent.this;
        }

        public void scrollRectToVisible(Rectangle rectangle, boolean bl) {
            super.scrollRectToVisible(rectangle);
            if (bl) {
                this.extendComponent(rectangle);
            }
        }

        protected void extendComponent(Rectangle rectangle) {
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.y + rectangle.height;
            Dimension dimension = new Dimension(this.getPreferredSize());
            Dimension dimension2 = mxGraphComponent.this.getScaledPreferredSizeForGraph();
            mxRectangle mxRectangle2 = mxGraphComponent.this.graph.getMinimumGraphSize();
            double d = mxGraphComponent.this.graph.getView().getScale();
            boolean bl = false;
            if (rectangle.x < 0) {
                this.translate.x = Math.max(this.translate.x, Math.max(0, -rectangle.x));
                dimension.width = dimension2.width;
                if (mxRectangle2 != null) {
                    dimension.width = (int)Math.max((long)dimension.width, Math.round(mxRectangle2.getWidth() * d));
                }
                dimension.width += this.translate.x;
                bl = true;
            } else if (n > this.getWidth()) {
                dimension.width = Math.max(n, this.getWidth());
                bl = true;
            }
            if (rectangle.y < 0) {
                this.translate.y = Math.max(this.translate.y, Math.max(0, -rectangle.y));
                dimension.height = dimension2.height;
                if (mxRectangle2 != null) {
                    dimension.height = (int)Math.max((long)dimension.height, Math.round(mxRectangle2.getHeight() * d));
                }
                dimension.height += this.translate.y;
                bl = true;
            } else if (n2 > this.getHeight()) {
                dimension.height = Math.max(n2, this.getHeight());
                bl = true;
            }
            if (bl) {
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.revalidate();
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Object object;
            String string = mxGraphComponent.this.getSelectionCellsHandler().getToolTipText(mouseEvent);
            if (string == null && (object = mxGraphComponent.this.getCellAt(mouseEvent.getX(), mouseEvent.getY())) != null) {
                string = mxGraphComponent.this.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY()) ? mxResources.get("collapse-expand") : mxGraphComponent.this.graph.getToolTipForCell(object);
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return super.getToolTipText(mouseEvent);
        }

        public void updatePreferredSize() {
            Cloneable cloneable;
            double d = mxGraphComponent.this.graph.getView().getScale();
            Dimension dimension = null;
            if (mxGraphComponent.this.preferPageSize || mxGraphComponent.this.pageVisible) {
                cloneable = mxGraphComponent.this.getPreferredSizeForPage();
                if (!mxGraphComponent.this.preferPageSize) {
                    ((Dimension)cloneable).width += 2 * mxGraphComponent.this.getHorizontalPageBorder();
                    ((Dimension)cloneable).height += 2 * mxGraphComponent.this.getVerticalPageBorder();
                }
                dimension = new Dimension((int)((double)((Dimension)cloneable).width * d), (int)((double)((Dimension)cloneable).height * d));
            } else {
                dimension = mxGraphComponent.this.getScaledPreferredSizeForGraph();
            }
            cloneable = mxGraphComponent.this.graph.getMinimumGraphSize();
            if (cloneable != null) {
                dimension.width = (int)Math.max((long)dimension.width, Math.round(((mxRectangle)cloneable).getWidth() * d));
                dimension.height = (int)Math.max((long)dimension.height, Math.round(((mxRectangle)cloneable).getHeight() * d));
            }
            if (!this.getPreferredSize().equals(dimension)) {
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.revalidate();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(this.translate.x, this.translate.y);
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("beforePaint", "g", graphics));
            super.paint(graphics);
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("afterPaint", "g", graphics));
            graphics.translate(-this.translate.x, -this.translate.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            mxGraphComponent.this.paintBackground(graphics);
            if (mxGraphComponent.this.tripleBuffered) {
                mxGraphComponent.this.checkTripleBuffer();
            } else if (mxGraphComponent.this.tripleBuffer != null) {
                mxGraphComponent.this.destroyTripleBuffer();
            }
            if (mxGraphComponent.this.tripleBuffer != null) {
                mxUtils.drawImageClip(graphics, mxGraphComponent.this.tripleBuffer, this);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                try {
                    mxUtils.setAntiAlias(graphics2D, mxGraphComponent.this.antiAlias, mxGraphComponent.this.textAntiAlias);
                    this.drawGraph(graphics2D, true);
                }
                finally {
                    graphics2D.setRenderingHints(renderingHints);
                }
            }
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("paint", "g", graphics));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawGraph(Graphics2D graphics2D, boolean bl) {
            Graphics2D graphics2D2 = mxGraphComponent.this.canvas.getGraphics();
            boolean bl2 = mxGraphComponent.this.canvas.isDrawLabels();
            mxPoint mxPoint2 = mxGraphComponent.this.canvas.getTranslate();
            double d = mxGraphComponent.this.canvas.getScale();
            try {
                mxGraphComponent.this.canvas.setScale(mxGraphComponent.this.graph.getView().getScale());
                mxGraphComponent.this.canvas.setDrawLabels(bl);
                mxGraphComponent.this.canvas.setTranslate(0.0, 0.0);
                mxGraphComponent.this.canvas.setGraphics(graphics2D);
                this.drawFromRootCell();
            }
            finally {
                mxGraphComponent.this.canvas.setScale(d);
                mxGraphComponent.this.canvas.setTranslate(mxPoint2.getX(), mxPoint2.getY());
                mxGraphComponent.this.canvas.setDrawLabels(bl2);
                mxGraphComponent.this.canvas.setGraphics(graphics2D2);
            }
        }

        protected void drawFromRootCell() {
            this.drawCell(mxGraphComponent.this.canvas, mxGraphComponent.this.graph.getModel().getRoot());
        }

        protected boolean hitClip(mxGraphics2DCanvas mxGraphics2DCanvas2, mxCellState mxCellState2) {
            Rectangle rectangle = this.getExtendedCellBounds(mxCellState2);
            return rectangle == null || mxGraphics2DCanvas2.getGraphics().hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        protected Rectangle getExtendedCellBounds(mxCellState mxCellState2) {
            Rectangle rectangle = null;
            double d = mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_ROTATION);
            mxRectangle mxRectangle2 = mxUtils.getBoundingBox(new mxRectangle(mxCellState2), d);
            int n = (int)Math.ceil(mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_STROKEWIDTH) * mxGraphComponent.this.graph.getView().getScale()) + 1;
            mxRectangle2.grow(n);
            if (mxUtils.isTrue(mxCellState2.getStyle(), mxConstants.STYLE_SHADOW)) {
                mxRectangle2.setWidth(mxRectangle2.getWidth() + (double)mxConstants.SHADOW_OFFSETX);
                mxRectangle2.setHeight(mxRectangle2.getHeight() + (double)mxConstants.SHADOW_OFFSETX);
            }
            if (mxCellState2.getLabelBounds() != null) {
                mxRectangle2.add(mxCellState2.getLabelBounds());
            }
            rectangle = mxRectangle2.getRectangle();
            return rectangle;
        }

        public void drawCell(mxICanvas mxICanvas2, Object object) {
            mxCellState mxCellState2 = mxGraphComponent.this.graph.getView().getState(object);
            if (mxCellState2 != null && this.isCellDisplayable(mxCellState2.getCell()) && (!(mxICanvas2 instanceof mxGraphics2DCanvas) || this.hitClip((mxGraphics2DCanvas)mxICanvas2, mxCellState2))) {
                mxGraphComponent.this.graph.drawState(mxICanvas2, mxCellState2, object != mxGraphComponent.this.cellEditor.getEditingCell());
            }
            boolean bl = mxGraphComponent.this.graph.isKeepEdgesInBackground();
            boolean bl2 = mxGraphComponent.this.graph.isKeepEdgesInForeground();
            if (bl) {
                this.drawChildren(object, true, false);
            }
            this.drawChildren(object, !bl && !bl2, true);
            if (bl2) {
                this.drawChildren(object, true, false);
            }
            if (mxCellState2 != null) {
                this.cellDrawn(mxICanvas2, mxCellState2);
            }
        }

        protected void drawChildren(Object object, boolean bl, boolean bl2) {
            mxIGraphModel mxIGraphModel2 = mxGraphComponent.this.graph.getModel();
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = mxIGraphModel2.getChildAt(object, i);
                boolean bl3 = mxIGraphModel2.isEdge(object2);
                if ((!bl2 || bl3) && (!bl || !bl3)) continue;
                this.drawCell(mxGraphComponent.this.canvas, mxIGraphModel2.getChildAt(object, i));
            }
        }

        protected void cellDrawn(mxICanvas mxICanvas2, mxCellState mxCellState2) {
            if (mxGraphComponent.this.isFoldingEnabled() && mxICanvas2 instanceof mxGraphics2DCanvas) {
                ImageIcon imageIcon;
                mxIGraphModel mxIGraphModel2 = mxGraphComponent.this.graph.getModel();
                mxGraphics2DCanvas mxGraphics2DCanvas2 = (mxGraphics2DCanvas)mxICanvas2;
                Graphics2D graphics2D = mxGraphics2DCanvas2.getGraphics();
                boolean bl = mxIGraphModel2.isEdge(mxCellState2.getCell());
                if (mxCellState2.getCell() != mxGraphComponent.this.graph.getCurrentRoot() && (mxIGraphModel2.isVertex(mxCellState2.getCell()) || bl) && (imageIcon = mxGraphComponent.this.getFoldingIcon(mxCellState2)) != null) {
                    Rectangle rectangle = mxGraphComponent.this.getFoldingIconBounds(mxCellState2, imageIcon);
                    graphics2D.drawImage(imageIcon.getImage(), rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
                }
            }
        }

        protected boolean isCellDisplayable(Object object) {
            return object != mxGraphComponent.this.graph.getView().getCurrentRoot() && object != mxGraphComponent.this.graph.getModel().getRoot();
        }
    }
}

