#
# INTEL CONFIDENTIAL
# Copyright 2015 - 2017 Intel Corporation.
#
# The source code contained or described herein and all documents related to
# the source code ("Material") are owned by Intel Corporation or its suppliers
# or licensors. Title to the Material remains with Intel Corporation or its suppliers
# and licensors. The Material may contain trade secrets and proprietary and
# confidential information of Intel Corporation and its suppliers and licensors,
# and is protected by worldwide copyright and trade secret laws and treaty provisions.
# No part of the Material may be used, copied, reproduced, modified, published,
# uploaded, posted, transmitted, distributed, or disclosed in any way without Intel's
# prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellectual property
# right is granted to or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise. Any license
# under such intellectual property rights must be express and approved by Intel in writing.
#
# Unless otherwise agreed by Intel in writing, you may not remove or alter this notice
# or any other notice embedded in Materials by Intel or Intel's suppliers or licensors
# in any way.
#

# useful documentation
# RedHat:
#    /usr/lib/rpm/redhat/macros
#    /usr/lib/rpm/redhat/kmodtool
#    https://wiki.centos.org/HowTos/BuildingKernelModules
# SUSE:
#   /etc/rpm/macros.kernel-source
#   /usr/lib/rpm/kernel-module-subpackage
#   https://drivers.suse.com/doc/kmpm/Kmpm-code11.pdf

%{!?kernel_version: %global kernel_version $(uname -r)}
%{!?kernel_src: %global kernel_src /lib/modules/%{kernel_version}/build}

Summary: 	Set of additional kernel utilities for KNL
Name: 	 	%{name}
Distribution: 	%{distribution}
Version: 	%{version}
Release: 	%{release}
Group:		System/Kernel
License: 	GPLv2
Vendor: 	Intel Corporation
URL: 		http://www.intel.com
ExclusiveArch: 	x86_64
Source0: 	%{name}-%{version}.tar.gz
Source1:	%{preamble_file_name}
BuildRequires:	%kernel_module_package_buildreqs

# disable debug package generation
%define debug_package %{nil}

%if 0%{?suse_version}
%kernel_module_package default -p %preamble_file_name
%else
%kernel_module_package default
%endif

%description
Provides set of utilities for KNL

%prep
%setup -D -q -c -T -a 0

%build
%{__make} \
	KERNEL_SRC=%{kernel_src} \
	KERNEL_VERSION=%{kernel_version}

%install
%{__make} \
	BUILD_ROOT=%{buildroot} \
	BIN_DIR=%{_bindir} \
	KERNEL_SRC=%{kernel_src} \
	KERNEL_VERSION=%{kernel_version} \
	DEPMOD="echo" \
	install

%changelog
