/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.FMException;
import com.intel.stl.api.IConnectionAssistant;
import com.intel.stl.api.SSLStoreCredentialsDeniedException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.common.STLMessages;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DefaultConnectionAssistant
implements IConnectionAssistant {
    public static final int MAX_TRIES = 5;
    public static final long TIME_OUT = 30000L;
    private JPanel certPanel;
    private JTextField keyFileField;
    private JPasswordField keyPwdField;
    private JTextField trustFileField;
    private JPasswordField trustPwdField;

    @Override
    public CertsDescription getSSLStoreCredentials(HostInfo hostInfo) throws SSLStoreCredentialsDeniedException {
        final CertsDescription certs = hostInfo.getCertsDescription();
        if (certs.hasPwds()) {
            return certs;
        }
        final Exchanger<Object> xchgr = new Exchanger<Object>();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CertsDescription newCerts = DefaultConnectionAssistant.this.getNewCerts(certs);
                try {
                    xchgr.exchange(newCerts, 30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        });
        CertsDescription result = null;
        try {
            result = xchgr.exchange(null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (result == null) {
            throw new SSLStoreCredentialsDeniedException(STLMessages.STL20001_CONNECTION_ERROR);
        }
        return result;
    }

    @Override
    public void onSSLStoreError(final FMException fmException) {
        final Exchanger<String> xchgr = new Exchanger<String>();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, StringUtils.getErrorMessage(fmException), "Error", 0);
                try {
                    xchgr.exchange("Ok pressed in Dialog", 30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            xchgr.exchange("");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private CertsDescription getNewCerts(CertsDescription certs) {
        if (this.certPanel == null) {
            this.createCertPanel(certs);
        }
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(null, this.certPanel, STLMessages.STL61001_CERT_CONF.getDescription(), 1, -1, null, options, options[0]);
        if (option == 0) {
            CertsDescription newCerts = new CertsDescription(this.keyFileField.getText(), this.trustFileField.getText());
            newCerts.setKeyStorePwd(this.keyPwdField.getPassword());
            newCerts.setTrustStorePwd(this.trustPwdField.getPassword());
            return newCerts;
        }
        return null;
    }

    private void createCertPanel(CertsDescription certs) {
        this.certPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.certPanel, 1);
        this.certPanel.setLayout(layout);
        JLabel label = new JLabel(STLMessages.STL61002_KEY_STORE_LOC.getDescription());
        this.certPanel.add(label);
        this.keyFileField = new JTextField();
        this.certPanel.add(this.keyFileField);
        label = new JLabel(STLMessages.STL61003_KEY_STORE_PWD.getDescription());
        this.certPanel.add(label);
        this.keyPwdField = new JPasswordField();
        this.certPanel.add(this.keyPwdField);
        label = new JLabel(STLMessages.STL61004_TRUST_STORE_LOC.getDescription());
        this.certPanel.add(label);
        this.trustFileField = new JTextField();
        this.certPanel.add(this.trustFileField);
        label = new JLabel(STLMessages.STL61005_TRUST_STORE_PWD.getDescription());
        this.certPanel.add(label);
        this.trustPwdField = new JPasswordField();
        this.certPanel.add(this.trustPwdField);
        if (certs != null) {
            this.keyFileField.setText(certs.getKeyStoreFile());
            this.trustFileField.setText(certs.getTrustStoreFile());
        }
    }
}

